/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.mediaconverter;

import com.nokia.tools.themeinstaller.odtconverter.ConverterProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class MediaConverter {
    protected static final String MEDIA_CONVERTER_APPLICATION = "media_converter";
    private static final String WINDOWS_EXCUTABLE_EXTENSION = "exe";
    private static final String LINUX_OS_NAME = "linux";
    private static final String OPERATING_SYSTEM_PROPERTY = "os.name";
    protected static final char SPACE = ' ';
    protected static final char DOT = '.';
    private static final String BMP = "bmp";
    private static final String COLOR_SETTING = "color_setting";
    protected static String DEFAULT_SUCCESS_LINE = "Success.";
    protected ConverterProperties iProperties = new ConverterProperties();
    private Process iProcess;
    protected String iExtraParameters = null;

    public String getExtraParameters() {
        return this.iExtraParameters;
    }

    public void setExtraParameters(String aExtraParameters) {
        this.iExtraParameters = aExtraParameters;
    }

    protected String getExecParameters(List aFilenames, String aTargetFile) {
        StringBuffer sb = new StringBuffer();
        URL resource = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        File bin = new File(resource.getPath());
        sb.append(String.valueOf(bin.getParent()) + File.separatorChar);
        if (System.getProperty(OPERATING_SYSTEM_PROPERTY).equalsIgnoreCase(LINUX_OS_NAME)) {
            sb.append(this.iProperties.getProperty(MEDIA_CONVERTER_APPLICATION));
        } else {
            sb.append(String.valueOf(this.iProperties.getProperty(MEDIA_CONVERTER_APPLICATION)) + '.' + WINDOWS_EXCUTABLE_EXTENSION);
        }
        sb.append(' ');
        if (this.iExtraParameters != null) {
            sb.append(this.iExtraParameters);
            sb.append(' ');
        }
        sb.append(aTargetFile);
        sb.append(' ');
        Iterator iterator = aFilenames.iterator();
        while (iterator.hasNext()) {
            sb.append(this.iProperties.getProperty(COLOR_SETTING));
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    protected String[] getEnvironmentVariables() {
        return null;
    }

    protected String getSuccesIndicationLine() {
        return DEFAULT_SUCCESS_LINE;
    }

    public void cancelConversion() {
        if (this.iProcess != null) {
            this.iProcess.destroy();
        }
    }

    public void convertMedia(List aFilenames, String aTargetFile) throws IOException {
        ArrayList newFiles = new ArrayList();
        this.checkMedias(aFilenames, newFiles);
        Runtime rt = Runtime.getRuntime();
        this.iProcess = rt.exec(this.getExecParameters(aFilenames, aTargetFile), this.getEnvironmentVariables());
        try {
            this.iProcess.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Conversion interrupted");
        }
        if (this.iProcess.exitValue() != 0) {
            InputStream input = null;
            BufferedReader in = null;
            StringBuffer sb = null;
            try {
                input = this.iProcess.getErrorStream();
                in = new BufferedReader(new InputStreamReader(input));
                sb = new StringBuffer();
                String line = null;
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            this.deleteTemporaryFiles(newFiles);
            throw new IOException("Conversion failed with error code: " + this.iProcess.exitValue() + "\nError log: " + sb.toString());
        }
        boolean success = false;
        String line = null;
        String lastLine = null;
        InputStream input = null;
        BufferedReader in = null;
        try {
            input = this.iProcess.getInputStream();
            in = new BufferedReader(new InputStreamReader(input));
            while ((line = in.readLine()) != null) {
                if (line.equals(this.getSuccesIndicationLine())) {
                    success = true;
                    break;
                }
                lastLine = line;
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (in != null) {
                in.close();
            }
        }
        this.iProcess = null;
        this.deleteTemporaryFiles(newFiles);
        if (!success) {
            throw new IOException("Running media converter failed: " + lastLine);
        }
    }

    protected void deleteTemporaryFiles(List aNewFiles) throws IOException {
        for (String filename : aNewFiles) {
            File file = new File(filename);
            if (file.delete()) continue;
            throw new IOException("Temporary file deletion failed: " + filename);
        }
    }

    protected void checkMedias(List aFilenames, List aNewFiles) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(BMP);
        if (!writers.hasNext()) {
            throw new IOException("BMP encoder not found");
        }
        ImageWriter bmpWriter = writers.next();
        ArrayList<String> newNames = new ArrayList<String>();
        for (String imageName : aFilenames) {
            String destinationImage;
            block12: {
                ImageInputStream input = ImageIO.createImageInputStream(new File(imageName));
                destinationImage = null;
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
                    if (!readers.hasNext()) {
                        throw new IOException("Unknown file");
                    }
                    ImageReader ir = readers.next();
                    destinationImage = imageName;
                    if (ir.getFormatName().equalsIgnoreCase(BMP)) break block12;
                    ir.setInput(input);
                    IIOImage image = ir.readAll(0, null);
                    destinationImage = String.valueOf(imageName.substring(0, imageName.lastIndexOf(46) + 1)) + BMP;
                    File destFile = new File(destinationImage);
                    int index = 1;
                    while (destFile.exists()) {
                        destinationImage = String.valueOf(imageName.substring(0, imageName.lastIndexOf(46))) + index++ + '.' + BMP;
                        destFile = new File(destinationImage);
                    }
                    ImageOutputStream output = ImageIO.createImageOutputStream(destFile);
                    try {
                        bmpWriter.setOutput(output);
                        bmpWriter.write(image);
                    }
                    finally {
                        if (output != null) {
                            output.close();
                        }
                    }
                    aNewFiles.add(destinationImage);
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                }
            }
            newNames.add(destinationImage);
        }
        aFilenames.clear();
        aFilenames.addAll(newNames);
    }
}

