/*
* Copyright (c) 2008 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
*  Description : block view control.
 *
*/

#ifndef     __CVIMPSTUIBLOCKVIEWCONTROL_H
#define     __CVIMPSTUIBLOCKVIEWCONTROL_H

//  INCLUDES
#include <eiklbo.h>
#include <eikbtgpc.h>

// FORWARD DECLARATIONS
class CAknSingleGraphicStyleListBox;
class MVIMPSTEngine;
class MPbk2KeyEventHandler;
class MVIMPSTCmdHandler;
class CVIMPSTUiBlockView;
// CLASS DECLARATION
/**
 * Search view control. Shows search results
 *  @lib vimpstui.lib
 *  @since S60 v5.0 
 */
class CVIMPSTUiBlockViewControl :  public CCoeControl,
                                	public MEikListBoxObserver,
									public MCoeControlObserver
    {
           
    public: // Constructor and destructor
        /**
         * Creates a new CVIMPSTUiBlockViewControl.
         * @param aBlockedView, reference to blocked view.
         * @param aKeyEventHandler, reference to keyeventhandler.
         * @param aEngine reference to engine.
         * @param aBlockedList pointer to block list.
         */
        static CVIMPSTUiBlockViewControl* NewL( CVIMPSTUiBlockView& aBlockedView,
                                                MPbk2KeyEventHandler& aKeyEventHandler,
        										MVIMPSTEngine& aEngine,
        										RPointerArray<HBufC>* aBlockedList );
        
        /**
         * Creates a new CVIMPSTUiBlockViewControl and leaves it to
         * cleanup stack.
         * @see NewL
         */
        static CVIMPSTUiBlockViewControl* NewLC( CVIMPSTUiBlockView& aBlockedView,
                                                 MPbk2KeyEventHandler& aKeyEventHandler,
        										 MVIMPSTEngine& aEngine,
        										 RPointerArray<HBufC>* aBlockedList );
        
        /**
         * Destructor.
         */
        ~CVIMPSTUiBlockViewControl();

	
    private: 
    
        /**
         * Standard C++ constructor
         * see NewL.
         */    
        CVIMPSTUiBlockViewControl( CVIMPSTUiBlockView& aBlockedView,
                                    MPbk2KeyEventHandler& aKeyEventHandler,
        							MVIMPSTEngine& aEngine,
        							RPointerArray<HBufC>* aBlockedList);
        
        /**
         * Performs the 2nd phase of construction.
         *
         */        
        void ConstructL();

    public: // New functions
    
	   /**
        * sets the primary and secondary text of this view
        */
       void SetEmptyTextsToListboxL();
       
      /**
       * Updates the list box with blocked contact data
       */
       void UpdateBlockedListL();
      
      
       /**
        * returns the list box
        */
		CEikListBox* ListBox() const;

       /**
        * extracts the contactId ,allocates memory for contactId and returns
        * Owership of the contactId is transfered to caller 
        * 
        * @return contactId  : Owenership to caller
        */    
        HBufC* GetFocusedContactLC() const;

	    /**
         * Updates Softkeys according to current focus
         * Default value is false.
         */                     
        void UpdateCbaL();
        
	    /**
         * @return,return current list box item index.
         */                     
        TInt GetCurrentIndex() const;

		/**
		* set focus on aIndex item.
		* @param aIndex, Index of item.on which focus will set.
		*/
		void SetCurrentIndex(TInt aIndex);
		
		/**
		* set the background text to indicate that retriving list from server..
		*/
		void SetUpdatingTextsToListboxL();

    private: // Functions MCoeControlObserver
    
    	/**
	    * Handles events from findpane and forwards them to listbox filter.
	    * @see MCoeControlObserver
	    */
	    void HandleControlEventL( CCoeControl* aControl,TCoeEvent aEventType );  

        /**
        * From MEikListBoxObserver, Handles event's generated by listbox
        * @param aListBox Pointer to listbox from where this event originated
        * @param aEventType Type of event received.
        */
		void HandleListBoxEventL( CEikListBox* aListBox, TListBoxEvent aEventType );

        
        /**
        * From CoeControl, Returns the number of control contained by this class.
        * @return Number of controls contained
        */
        TInt CountComponentControls() const;

        /**
        * From CCoeControl, Returns handle to control pointed by aIndex
        * @param aIndex Wanted control's index [0..n]
        * @return Handle to wanted control
        */
        CCoeControl* ComponentControl( TInt aIndex ) const;

		/**
        * From CCoeControl,respond to size chnaged
        */
		void SizeChanged();
		
        /**
        * From CCoeControl, Handles key-events
        * @param aEvent Event that occured
		* @param aType Type of key-event (EEventKey, EEventKeyUp or EEventKeyDown)
        * @return Containers response to event (EKeyWasNotConsumed/ EKeyWasConsumed)
        */
		TKeyResponse OfferKeyEventL( const TKeyEvent& aEvent, TEventCode aType );
	   	
    private:    // Data
        
        //Not owned: reference to blocked view.
        CVIMPSTUiBlockView& iBlockedView;
        
    	// Not owned: key event handler
    	MPbk2KeyEventHandler& iKeyEventHandler;
    	
	    //Owns
		CAknSingleGraphicStyleListBox* iListBox;

      	//Owns
		CDesCArray* iItemArray;
     	
        //Doesnt own - reference to engine for this service
        MVIMPSTEngine& iEngine;
        
        // CBA. not owned
        CEikButtonGroupContainer* iCba;     

		//pointer to blocked list
		RPointerArray<HBufC>* iBlockedList;//does not own..
        
        //store the focused list box item index.
        TInt iCurrentItemIndex;
	};

#endif      // __CVIMPSTUIBLOCKVIEWCONTROL_H

// End of File
