/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.cssparser;

import com.nokia.tools.themeinstaller.cssparser.CSSHandler;
import com.nokia.tools.themeinstaller.logger.LogWriter;
import com.nokia.tools.themeinstaller.odtconverter.ODTException;
import com.nokia.tools.themeinstaller.odtconverter.ParseOperation;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.helpers.ParserFactory;
import org.w3c.dom.Document;

public class CSSParser
extends ParseOperation
implements Runnable {
    private static final String CSS_PARSER_SYSTEM_VALUE = "org.w3c.css.sac.parser";
    private static final String CSS_PARSER_SYSTEM_KEY = "org.apache.batik.css.parser.Parser";
    private String iFileName;
    private CSSHandler iCSSHandler;
    private Parser iParser;

    public CSSParser(String aFileName) {
        this.iFileName = aFileName;
        ParserFactory factory = new ParserFactory();
        this.iCSSHandler = new CSSHandler();
        System.setProperty(CSS_PARSER_SYSTEM_VALUE, CSS_PARSER_SYSTEM_KEY);
        try {
            this.iParser = factory.makeParser();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load CSS parser");
        }
    }

    public void setDocument(Document aDocument) {
        this.iDOMDocument = aDocument;
    }

    public void run() {
        int error = 0;
        String reason = "";
        try {
            this.iCSSHandler.setDocument(this.iDOMDocument);
            File mainCSS = new File(this.iFileName);
            FileReader r = new FileReader(mainCSS);
            this.iCSSHandler.setImportDirectory(mainCSS.getParent());
            InputSource is = new InputSource((Reader)r);
            this.iParser.setDocumentHandler((DocumentHandler)this.iCSSHandler);
            LogWriter.getInstance().logInfo(String.valueOf(this.getClass().getSimpleName()) + ": Parsing CSS " + this.iFileName);
            this.iParser.parseStyleSheet(is);
            this.iDOMDocument = this.iCSSHandler.getDocument();
        }
        catch (Exception e) {
            reason = e.getMessage();
            error = -4;
        }
        super.operationCompleted(error, reason);
    }

    public void parse() throws IOException, ODTException {
        Thread thread = new Thread(this);
        thread.start();
    }
}

