/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.tools.themeinstaller.installationmanager;

import com.nokia.tools.themeinstaller.installationmanager.IThemeManifest;
import com.nokia.tools.themeinstaller.installationmanager.LanguageSpecificData;
import com.nokia.tools.themeinstaller.installationmanager.Lock;
import com.nokia.tools.themeinstaller.installationmanager.ThemeManifest;
import com.nokia.tools.themeinstaller.installationmanager.ThemeResource;
import com.nokia.tools.themeinstaller.localisation.DTDReader;
import com.nokia.tools.themeinstaller.localisation.Localisation;
import com.nokia.tools.themeinstaller.localisation.LocalisationStore;
import com.nokia.tools.themeinstaller.odtconverter.ConverterProperties;
import com.nokia.tools.themeinstaller.odtconverter.IParseOperationListener;
import com.nokia.tools.themeinstaller.odtconverter.MimeTypeResolver;
import com.nokia.tools.themeinstaller.odtconverter.ThemeStatusResolver;
import com.nokia.tools.themeinstaller.xmlparser.XMLParser;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManifestFactory
implements IParseOperationListener {
    private static final String MULTI_THEME = "datfiles";
    private static final String APP_UID_ELEMENT = "AppUid";
    private static final String PROVIDER_UID_ELEMENT = "Provideruid";
    private static final String THEME_UID_ELEMENT = "ThemeUid";
    private static final String THEME_STATUS_ELEMENT = "ThemeStatus";
    private static final String THEME_FULL_NAME_ELEMENT = "ThemeFullName";
    private static final String THEME_SHORT_NAME_ELEMENT = "ThemeShortName";
    private static final String THEME_VERSION_ELEMENT = "ThemeVersion";
    private static final String FILE_XML_ELEMENT = "FileXML";
    private static final String FILE_CSS_ELEMENT = "FileCSS";
    private static final String FILE_DTD_ELEMENT = "FileDTD";
    private static final String FILE_DAT_ELEMENT = "FileDAT";
    private static final String FILE_RESOURCE_ELEMENT = "FileResource";
    private static final String CACHE_VALUE_MEMORY = "CacheMemory";
    private static final String LOCKING_ELEMENT = "Locking";
    private static final String LOCKED_VALUE = "Locked";
    private static final String CACHE_TYPE_ELEMENT = "CacheType";
    private static final String CACHE_VALUE_NONE = "CacheNone";
    private static final String CACHE_VALUE_FILE = "CacheFile";
    private static final String LANGUAGE_SPECIFIC_ELEMENT = "LanguageSpecific";
    private static final int LANGUAGE_INDEPENDENT = 0;
    private static final int LANG_NOT_SET = -1;
    private static final int RADIX = 16;
    private static final int SCREEN_SIZE_X = 0;
    private static final int SCREEN_SIZE_Y = 0;
    public static int CACHE_TYPE_CACHE_NONE = 0;
    public static int CACHE_TYPE_CACHE_FILE = 1;
    public static int CACHE_TYPE_CACHE_MEMORY = 2;
    public static final int E_XN_UNLOCKED = 0;
    public static final int E_XN_LOCKED = 1;
    public static final String CURRENT_DIR = ".";
    private static final String THEME_PROVIDER_KEY = "theme_provider_name";
    private static final String NAME_SPACE_KEY = "theme_name_space";
    private Lock iLock = new Lock();
    private MimeTypeResolver iMimeTypeResolver = new MimeTypeResolver();
    private ConverterProperties iProperties = ConverterProperties.getInstance();
    private File iLocSettings;

    public ManifestFactory(File aLocSettings) throws IOException {
        this.iLocSettings = aLocSettings;
    }

    public IThemeManifest createManifest(File aFile) throws IOException {
        Document document = this.readManifest(aFile);
        ThemeManifest manifest = new ThemeManifest();
        if (aFile.getParent() == null) {
            manifest.setDataDir(CURRENT_DIR + File.separatorChar);
        } else {
            manifest.setDataDir(String.valueOf(aFile.getParent()) + File.separatorChar);
        }
        String rootNodeName = document.getFirstChild().getNodeName();
        if (rootNodeName == MULTI_THEME) {
            this.parseMultiThemeManifest(document, manifest);
        } else {
            this.parseManifest(document, manifest);
            this.parseLanguageSpecificData(document, manifest);
            this.parseResources(document, manifest, 0);
        }
        return manifest;
    }

    public void parseOperationCompleted(int aErr, String aReason) {
        this.iLock.unLock();
        if (aErr != 0) {
            throw new IllegalArgumentException("Theme manifest parsing failed: " + aErr + ", " + aReason);
        }
    }

    private Document readManifest(File aManifest) {
        XMLParser parser = new XMLParser(aManifest.getPath());
        parser.addListener(this);
        try {
            parser.parse();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Theme manifest parsing failed: " + e.getMessage());
        }
        this.iLock.lock();
        return parser.getDOMDocument();
    }

    private void parseMultiThemeManifest(Document aDocument, IThemeManifest aManifest) {
        NodeList nodes = aDocument.getElementsByTagName(FILE_DAT_ELEMENT);
        Node node = null;
        int i = 0;
        while (i < nodes.getLength()) {
            node = nodes.item(i);
            aManifest.addManifestFile(String.valueOf(aManifest.getDataDir()) + node.getTextContent());
            ++i;
        }
    }

    private void parseManifest(Document aDocument, IThemeManifest aManifest) {
        NodeList nodes = aDocument.getElementsByTagName(APP_UID_ELEMENT);
        Node node = this.checkOneNode(nodes);
        aManifest.setApplicationUid(Long.valueOf(node.getTextContent(), 16));
        nodes = aDocument.getElementsByTagName(PROVIDER_UID_ELEMENT);
        node = this.checkOneNode(nodes);
        aManifest.setProviderUid(Long.valueOf(node.getTextContent(), 16));
        nodes = aDocument.getElementsByTagName(THEME_UID_ELEMENT);
        node = this.checkOneNode(nodes);
        aManifest.setThemeUid(Long.valueOf(node.getTextContent(), 16));
        aManifest.setNameSpace(this.iProperties.getProperty(NAME_SPACE_KEY));
        aManifest.setProviderName(this.iProperties.getProperty(THEME_PROVIDER_KEY));
        nodes = aDocument.getElementsByTagName(THEME_FULL_NAME_ELEMENT);
        if (nodes.getLength() <= 0) {
            throw new IllegalArgumentException("Syntax error in manifest file: theme full name not found");
        }
        aManifest.setThemeFullName(nodes.item(0).getTextContent());
        nodes = aDocument.getElementsByTagName(THEME_SHORT_NAME_ELEMENT);
        node = this.checkOneNode(nodes);
        aManifest.setThemeShortName(node.getTextContent());
        nodes = aDocument.getElementsByTagName(THEME_VERSION_ELEMENT);
        node = this.checkOneNode(nodes);
        aManifest.setThemeVersion(node.getTextContent());
        aManifest.setScreenSizeX(new Integer(0));
        aManifest.setScreenSizeY(new Integer(0));
        nodes = aDocument.getElementsByTagName(THEME_STATUS_ELEMENT);
        int flags = 0;
        int i = 0;
        while (i < nodes.getLength()) {
            node = nodes.item(i);
            flags |= ThemeStatusResolver.getValue(node.getTextContent()).intValue();
            if (node.getTextContent().equals("ThemeStatusLicenceeRestorable")) {
                flags |= 2;
            }
            ++i;
        }
        aManifest.setThemeStatus(new Integer(flags));
        NodeList files = aDocument.getElementsByTagName(FILE_XML_ELEMENT);
        node = this.checkOneNode(files);
        aManifest.setXMLFile(node.getTextContent());
        files = aDocument.getElementsByTagName(FILE_CSS_ELEMENT);
        node = this.checkMaxOneLanguageIndependentNode(files);
        if (node != null) {
            aManifest.setCSSFile(node.getTextContent());
        }
        if ((node = this.checkMaxOneLanguageIndependentNode(files = aDocument.getElementsByTagName(FILE_DTD_ELEMENT))) != null) {
            aManifest.setDTDFile(node.getTextContent());
        }
    }

    private void parseLanguageSpecificData(Document aDocument, IThemeManifest aManifest) throws IOException {
        NodeList languages = aDocument.getElementsByTagName(LANGUAGE_SPECIFIC_ELEMENT);
        Node langSpecificNode = null;
        NamedNodeMap langAttr = null;
        NodeList langSpecificChildren = null;
        Node langSpecificChild = null;
        NodeList resources = aDocument.getElementsByTagName(FILE_RESOURCE_ELEMENT);
        Vector langResources = null;
        int i = 0;
        while (i < languages.getLength()) {
            int langId = -1;
            String extDtd = null;
            String extCss = null;
            String themeFullName = null;
            langSpecificNode = languages.item(i);
            langAttr = langSpecificNode.getAttributes();
            if (langAttr.getLength() == 1) {
                String langStr = langAttr.item(0).getNodeValue();
                langId = Integer.valueOf(langStr);
            }
            langSpecificChildren = langSpecificNode.getChildNodes();
            String nodeName = null;
            int j = 0;
            while (j < langSpecificChildren.getLength()) {
                langSpecificChild = langSpecificChildren.item(j);
                nodeName = langSpecificChild.getNodeName();
                if (FILE_DTD_ELEMENT.equals(nodeName)) {
                    extDtd = langSpecificChild.getTextContent();
                } else if (FILE_CSS_ELEMENT.equals(nodeName)) {
                    extCss = langSpecificChild.getTextContent();
                } else if (THEME_FULL_NAME_ELEMENT.equals(nodeName)) {
                    themeFullName = langSpecificChild.getTextContent();
                }
                ++j;
            }
            langResources = this.parseResources(aManifest, resources, langId);
            if (langId == -1 || extDtd == null) {
                throw new IllegalArgumentException("Syntax error in language specifications of the manifest");
            }
            File dtd = null;
            if (this.iLocSettings != null) {
                LocalisationStore ls = LocalisationStore.getInstance(this.iLocSettings);
                Localisation l = ls.getLocalisation(aManifest.getApplicationUid(), aManifest.getProviderUid(), aManifest.getThemeUid());
                dtd = l.findDTD(extDtd);
            } else {
                dtd = new File(String.valueOf(aManifest.getDataDir()) + extDtd);
            }
            themeFullName = DTDReader.readEntity(dtd, themeFullName);
            LanguageSpecificData language = new LanguageSpecificData(new Integer(langId), extDtd, extCss, themeFullName, langResources);
            aManifest.addLanguage(language);
            ++i;
        }
        LanguageSpecificData language = new LanguageSpecificData(new Integer(0), null, null, null, null);
        aManifest.addLanguage(language);
    }

    private void parseResources(Document aDocument, IThemeManifest aManifest, int aLanguageId) {
        NodeList resourceList = aDocument.getElementsByTagName(FILE_RESOURCE_ELEMENT);
        Vector resources = this.parseResources(aManifest, resourceList, aLanguageId);
        Enumeration e = resources.elements();
        while (e.hasMoreElements()) {
            aManifest.addResource((ThemeResource)e.nextElement());
        }
    }

    private Vector parseResources(IThemeManifest aManifest, NodeList aNodeList, int aLanguageId) {
        Vector<ThemeResource> result = new Vector<ThemeResource>();
        Node node = null;
        int count = aNodeList.getLength();
        int i = 0;
        while (i < count) {
            ThemeResource resource;
            node = aNodeList.item(i);
            String filename = node.getTextContent();
            NamedNodeMap attributes = node.getAttributes();
            int cacheType = CACHE_TYPE_CACHE_NONE;
            int lockingPolicy = 0;
            Node cacheTypeNode = attributes.getNamedItem(CACHE_TYPE_ELEMENT);
            if (cacheTypeNode == null || cacheTypeNode.getTextContent().equals(CACHE_VALUE_NONE)) {
                cacheType = CACHE_TYPE_CACHE_NONE;
            } else if (cacheTypeNode.getTextContent().equals(CACHE_VALUE_FILE)) {
                cacheType = CACHE_TYPE_CACHE_FILE;
            } else if (cacheTypeNode.getTextContent().equals(CACHE_VALUE_MEMORY)) {
                cacheType = CACHE_TYPE_CACHE_MEMORY;
            } else {
                throw new IllegalArgumentException("Syntax error in the manifest, can not resolve resource cache type");
            }
            Node locking = attributes.getNamedItem(LOCKING_ELEMENT);
            if (locking != null && locking.getTextContent().equals(LOCKED_VALUE)) {
                lockingPolicy = 1;
            }
            if ((aManifest.getThemeStatus() & 2) != 0) {
                lockingPolicy = 1;
            }
            String mime = this.iMimeTypeResolver.getMimeType(filename);
            int resourceType = this.iMimeTypeResolver.getResourceType(filename);
            Node parent = node.getParentNode();
            NamedNodeMap attr = parent.getAttributes();
            if (attr.getLength() == 1 && aLanguageId == Integer.valueOf(attr.item(0).getNodeValue())) {
                resource = new ThemeResource(filename, cacheType, lockingPolicy, aManifest.getNameSpace(), resourceType, mime);
                result.add(resource);
            } else if (aLanguageId == 0 && !LANGUAGE_SPECIFIC_ELEMENT.equals(parent.getNodeName())) {
                resource = new ThemeResource(filename, cacheType, lockingPolicy, aManifest.getNameSpace(), resourceType, mime);
                result.add(resource);
            }
            ++i;
        }
        return result;
    }

    private Node checkOneNode(NodeList aNodeList) {
        if (aNodeList.getLength() != 1) {
            throw new IllegalArgumentException("Syntax error in manifest file, more child nodes than expected");
        }
        return aNodeList.item(0);
    }

    private Node checkMaxOneLanguageIndependentNode(NodeList aNodeList) {
        Node result = null;
        int count = 0;
        int i = 0;
        while (i < aNodeList.getLength()) {
            Node node = aNodeList.item(i);
            Node parent = node.getParentNode();
            if (!LANGUAGE_SPECIFIC_ELEMENT.equals(parent.getNodeName())) {
                result = node;
                ++count;
            }
            ++i;
        }
        if (count > 1) {
            throw new IllegalArgumentException("Syntax error in manifest file, more language independent child nodes than expected");
        }
        return result;
    }
}

