/*
* Copyright (c) 2002 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  UIDs for project Provisioning
*
*/



#ifndef PROVISIONINGUID_H
#define PROVISIONINGUID_H

//  CONSTANTS  

#define KAUTENTICATIONSUCCESS 1
#define KAUTENTICATIONFAILURE 2
#define KAUTENTICATIONCANCEL 3

#define KLANDSCAPE 640
#define KPORTRAIT 360
#define KCOLLAPSED 60
#define KEXPANDED 120
#define KLENGTH 256

/// ECOM plugin
#define KECOMUid2 0x10009D8D

/// Normal Symbian OS DLL
#define KSymbianDLLUid2 0x1000008d

/// UID2 for Provisioning BIO control
#define KProvisioningBCUid2 0x10005F5F

/// UID3 for Provisioning BIO control
#define KProvisioningBCUid3 0x101F84D3

/// UID for the Provisioning Message type for BIO database
#define KProvisioningMessageTypeUid 0x101F84D1

/// UID2 for the handler plugin for WAP Provisioning documents
#define KProvisioningHandlerUid2 KECOMUid2

/// UID3 for the handler plugin DLL for WAP Provisioning documents
#define KProvisioningHandlerUid3 0x101F84D2

/// UID for the handler plugin implementation
#define KProvisioningHandlerImplUid 0x101F84D3

/// UID of the Content Type Handler plugin interface
#define KProvisioningHandlerInterface 0x101F3E5E

/// UID2 of the Provisioning Parser DLL
#define KProvisioningParserUid2 KSymbianDLLUid2

/// UID3 of the Provisioning Parser DLL
#define KProvisioningParserUid3 0x101F84D4

/// UID of the Provisisioning Adapter plugin interface
#define KProvisioningAdapterInterface 0x101F84D5

/// UID2 of the Provisioning Engine DLL
#define KProvisioningEngineUid2 KSymbianDLLUid2

/// UID3 of the Provisioning Engine DLL
#define KProvisioningEngineUid3 0x101F84D6

/// UID for HTTPHeader stream in WAP Provisioning message
#define KProvisioningMessageStreamUid 0x101F84D7

/// UID2 for the APAdapter DLL
#define KProvisioningAPAdapterDllUid2 KECOMUid2

/// UID3 for the APAdapter DLL
#define KProvisioningAPAdapterDllUid3 0x101F84D8

/// UID for the APAdapter
#define KProvisioningAPAdapterUid 0x101F84D9

/// UID2 for the Browser+MMSAdapter DLL
#define KProvisioningWAPAdapterDllUid2 KECOMUid2

/// UID3 for the Browser+MMSAdapter DLL
#define KProvisioningWAPAdapterDllUid3 0x101F84DC

/// UID for the BrowserAdapter
#define KProvisioningBrowserAdapterUid 0x101F84DB

/// UID for the MMSAdapter
#define KProvisioningMMSAdapterUid 0x101F84DD

/// UID2 for the DataSyncAdapter DLL
#define KProvisioningDataSyncAdapterDllUid2 KECOMUid2

/// UID3 for the DataSyncAdapter DLL
#define KProvisioningDataSyncAdapterDllUid3 0x101F84DE

/// UID for the DataSyncAdapter
#define KProvisioningDataSyncAdapterUid 0x101F84DF

/// UID2 for the DeviceManagementAdapter DLL
#define KProvisioningDeviceManagementAdapterDllUid2 KECOMUid2

/// UID3 for the DeviceManagementAdapter DLL
#define KProvisioningDeviceManagementAdapterDllUid3 0x101F84E0

/// UID for the DeviceManagementAdapter
#define KProvisioningDeviceManagementAdapterUid 0x101F84E1

/// UID2 for the IMAdapter DLL
#define KProvisioningIMAdapterDllUid2 KECOMUid2

/// UID3 for the IMAdapter DLL
#define KProvisioningIMAdapterDllUid3 0x101F84E2

/// UID for the IMAdapter
#define KProvisioningIMAdapterUid 0x101F84E3

/// UID2 for the StreamingAdapter DLL
#define KProvisioningStreamingAdapterUid2 KECOMUid2

/// UID3 for the StreamingAdapter DLL
#define KProvisioningStreamingAdapterDllUid3 0x101F84E6

/// UID for the StreamingAdapter
#define KProvisioningStreamingAdapterUid 0x101F84E7

/// UID2 for the JavaAdapter DLL
#define KProvisioningJavaAdapterUid2 KECOMUid2

/// UID3 for the JavaAdapter DLL
#define KProvisioningJavaAdapterDllUid3 0x101F84E8

/// UID for the JavaAdapter
#define KProvisioningJavaAdapterUid 0x101F84E9

/// UID2 for Symbian application
#define KProvisioningCxUID2 0x100039CE

/// UID3 for ProvisioningCx application
#define KProvisioningCxUID3 0x101F8597

/// UID for the PresenceAdapter
#define KProvisioningPecAdapterUid 0x102072D3

#endif      //  PROVISIONINGUID_H
            
// End of File
