/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.midp.test.midptest;

import com.nokia.midp.test.midptest.MIDPTest;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;

public class ResourceReadingTest
extends Form
implements CommandListener,
Runnable {
    Command backCommand = new Command("Back", 2, 8);
    Command startCommand = new Command("Start", 1, 1);
    Command startMulti10Command = new Command("Start multi 10", 1, 1);
    Command startMulti100Command = new Command("Start multi 100", 1, 1);
    Command startMulti1000Command = new Command("Start multi 1000", 1, 1);
    Command imageCreationFromStreamCommand = new Command("Image from stream test", 1, 5);
    boolean multi = false;
    int multiTimes = 100;
    String[] files = new String[]{"/224_data", "/1074_data", "/1225_data", "/1781_data", "/16029_data", "/64116_data", "/128232_data", "/256464_data"};
    byte[] arr = new byte[256464];

    public ResourceReadingTest() {
        super("Resource Reading");
        this.setCommandListener(this);
        this.addCommand(this.backCommand);
        this.addCommand(this.startCommand);
        this.addCommand(this.startMulti10Command);
        this.addCommand(this.startMulti100Command);
        this.addCommand(this.startMulti1000Command);
        this.addCommand(this.imageCreationFromStreamCommand);
    }

    private void readFile(String string, boolean bl) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new NullPointerException("null stream, no such file?");
        }
        try {
            if (bl) {
                this.append(string + "\n");
            }
            if (bl) {
                this.append("Available: " + inputStream.available() + "\n");
            }
            long l = System.currentTimeMillis();
            int n = inputStream.read(this.arr, 0, this.arr.length);
            long l2 = System.currentTimeMillis();
            if (bl) {
                this.append("Read:" + n + " (" + (l2 - l) + "ms)\n");
            }
            if (bl) {
                this.append("\n");
            }
        }
        catch (IOException iOException) {
            this.append("IOException\n");
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this && command == this.backCommand) {
            MIDPTest.goBack();
        } else if (command == this.startCommand) {
            Thread thread = new Thread(this);
            thread.start();
        } else if (command == this.startMulti10Command) {
            this.append("Please wait, running multi read test 10 times.\n");
            this.multiTimes = 10;
            this.multi = true;
            Thread thread = new Thread(this);
            thread.start();
        } else if (command == this.startMulti100Command) {
            this.append("Please wait, running multi read test 100 times.\n");
            this.multiTimes = 100;
            this.multi = true;
            Thread thread = new Thread(this);
            thread.start();
        } else if (command == this.startMulti1000Command) {
            this.append("Please wait, running multi read test 1000 times.\n");
            this.multiTimes = 1000;
            this.multi = true;
            Thread thread = new Thread(this);
            thread.start();
        } else if (command == this.imageCreationFromStreamCommand) {
            for (int i = 0; i < this.files.length; ++i) {
                this.append(this.files[i] + "\n");
                InputStream inputStream = this.getClass().getResourceAsStream(this.files[i]);
                try {
                    Image image = Image.createImage((InputStream)inputStream);
                    this.append(image);
                    this.append("\n");
                    continue;
                }
                catch (IOException iOException) {
                    this.append("IOException on Image.createImage\n");
                    continue;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.append("OutOfMemoryError on Image.createImage\n");
                }
            }
        }
    }

    public void run() {
        if (this.multi) {
            long l = System.currentTimeMillis();
            for (int i = 0; i < this.multiTimes; ++i) {
                for (int j = 0; j < this.files.length; ++j) {
                    this.readFile(this.files[j], false);
                }
            }
            long l2 = System.currentTimeMillis();
            this.append("Read files " + this.multiTimes + " took " + (l2 - l) + " ms\n");
        } else {
            for (int i = 0; i < this.files.length; ++i) {
                this.readFile(this.files[i], true);
            }
        }
        this.multi = false;
    }
}

