/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.midp.test.midptest;

import com.nokia.midp.test.midptest.MIDPTest;
import com.nokia.midp.test.midptest.NoUIMIDlet;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;

public class UIStateTest
extends Form
implements CommandListener {
    private Command okCommand = new Command("OK", 4, 1);
    private Command backCommand = new Command("Back", 2, 8);
    private Command backgroundCommand = new Command("setCurrent(null)", 1, 1);
    private Command backForegroundCommand = new Command("setCurrent(this)", 1, 2);
    private Command isShownCommand = new Command("isShown()", 1, 3);
    private Command pauseAppCommand = new Command("pauseApp count", 1, 4);
    private Command destroyAppCommand = new Command("destroyApp()", 1, 5);
    private Command condExitCommand = new Command("Cond. exit test", 1, 6);
    private Command showHideNotifyCommand = new Command("Show/hide notify", 1, 3);
    private Command nextCanvas = new Command("Next Canvas", 1, 4);
    private Command toggleFCModeCanvas = new Command("Toggle normal/fc mode ", 1, 5);
    private Command resumeRequestCommand = new Command("Resume request", 1, 10);
    private Command showTimedAlertFromBG = new Command("Show timed BG Alert", 1, 11);
    private Command showAlertFromBG = new Command("Show BG Alert", 1, 11);
    private Command noUIMIDletsCommand = new Command("Launch no UI MIDlet", 1, 11);
    private Command noUIMIDletCheckCommand = new Command("Check no UI MIDlet", 1, 11);
    Timer timer = new Timer();
    public static int pauseCount = 0;
    public static boolean condExitTest = false;
    private Canvas showHideCanvas = null;
    private boolean fullScreenModeStatus = false;

    public UIStateTest() {
        super("UI State Test");
        this.setCommandListener(this);
        this.addCommand(this.backCommand);
        this.addCommand(this.backgroundCommand);
        this.addCommand(this.backForegroundCommand);
        this.addCommand(this.isShownCommand);
        this.addCommand(this.pauseAppCommand);
        this.addCommand(this.destroyAppCommand);
        this.addCommand(this.condExitCommand);
        this.addCommand(this.showHideNotifyCommand);
        this.addCommand(this.resumeRequestCommand);
        this.addCommand(this.showAlertFromBG);
        this.addCommand(this.showTimedAlertFromBG);
        this.addCommand(this.noUIMIDletsCommand);
        this.addCommand(this.noUIMIDletCheckCommand);
        this.append("Select command.");
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this && command == this.backCommand) {
            MIDPTest.goBack();
        } else if (displayable != this && (command == this.backCommand || command == this.okCommand)) {
            MIDPTest.getDisplay().setCurrent((Displayable)this);
        } else if (command == this.backgroundCommand) {
            while (this.size() != 0) {
                this.delete(0);
            }
            this.append("setCurrent(null) called in 3 seconds.");
            this.timer.schedule(new TimerTask(){

                public void run() {
                    MIDPTest.getDisplay().setCurrent(null);
                    UIStateTest.this.append("Called setCurrent(null).");
                }
            }, 3000L);
        } else if (command == this.backForegroundCommand) {
            while (this.size() != 0) {
                this.delete(0);
            }
            this.append("setCurrent(this) called in 5 seconds.");
            this.timer.schedule(new TimerTask(){

                public void run() {
                    MIDPTest.getDisplay().setCurrent((Displayable)UIStateTest.this);
                    UIStateTest.this.append("Called setCurrent(this).");
                }
            }, 5000L);
        } else if (command == this.isShownCommand) {
            while (this.size() != 0) {
                this.delete(0);
            }
            this.append("isShown() checked in 3 seconds.");
            this.timer.schedule(new TimerTask(){

                public void run() {
                    boolean bl = UIStateTest.this.isShown();
                    UIStateTest.this.append("isShown(): " + bl);
                }
            }, 3000L);
        } else if (command == this.showHideNotifyCommand) {
            if (this.showHideCanvas == null) {
                this.showHideCanvas = new ShowHideCanvas("First canvas");
            }
            MIDPTest.getDisplay().setCurrent((Displayable)this.showHideCanvas);
        } else if (command == this.nextCanvas) {
            System.out.println("First canvas/command action -> setCurrent(Second canvas)");
            MIDPTest.getDisplay().setCurrent((Displayable)new ShowHideCanvas("Second canvas"));
        } else if (command == this.toggleFCModeCanvas) {
            Canvas canvas = (Canvas)displayable;
            this.fullScreenModeStatus = !this.fullScreenModeStatus;
            System.out.println("Going to fc mode: " + this.fullScreenModeStatus);
            canvas.setFullScreenMode(this.fullScreenModeStatus);
        } else if (command == this.pauseAppCommand) {
            while (this.size() != 0) {
                this.delete(0);
            }
            this.append("pauseApp has been called for this MIDlet " + pauseCount + " times.");
        } else if (command == this.destroyAppCommand) {
            while (this.size() != 0) {
                this.delete(0);
            }
            this.append("destroyApp has been called for this MIDlet " + MIDPTest.getInstance().getDestroyCount() + " times.");
        } else if (command == this.condExitCommand) {
            while (this.size() != 0) {
                this.delete(0);
            }
            condExitTest = true;
            this.append("(Only usable if there a way to do MIDlet exit from platform that causes destroyApp(false) call.) Conditional exit test. Exit the MIDlet.");
        } else if (command == this.resumeRequestCommand) {
            while (this.size() != 0) {
                this.delete(0);
            }
            this.append("notifyPaused()");
            MIDPTest.getInstance().notifyPaused();
            this.append("resumeRequest() in 5 seconds.");
            this.timer.schedule(new TimerTask(){

                public void run() {
                    UIStateTest.this.append("Calling resumeRequest.");
                    MIDPTest.getInstance().resumeRequest();
                }
            }, 5000L);
        } else if (command == this.showTimedAlertFromBG) {
            MIDPTest.getDisplay().setCurrent(null);
            this.timer.schedule(new TimerTask(){

                public void run() {
                    UIStateTest.this.append("Showing timed Alert from BG.");
                    Alert alert = new Alert(null, "1 message received.", null, AlertType.INFO);
                    MIDPTest.getDisplay().setCurrent((Displayable)alert);
                }
            }, 5000L);
        } else if (command == this.showAlertFromBG) {
            MIDPTest.getDisplay().setCurrent(null);
            this.timer.schedule(new TimerTask(){

                public void run() {
                    UIStateTest.this.append("Showing Alert from BG.");
                    Alert alert = new Alert(null, "1 message received.", null, AlertType.INFO);
                    alert.addCommand(UIStateTest.this.okCommand);
                    alert.addCommand(UIStateTest.this.backCommand);
                    alert.setCommandListener((CommandListener)UIStateTest.this);
                    MIDPTest.getDisplay().setCurrent((Displayable)alert);
                }
            }, 5000L);
        } else if (command == this.noUIMIDletsCommand) {
            long l = System.currentTimeMillis() + 10000L;
            try {
                long l2 = PushRegistry.registerAlarm((String)"com.nokia.midp.test.midptest.NoUIMIDlet", (long)l);
                this.append("registerAlarm returned: " + l2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.append("com.nokia.midp.test.midptest.NoUIMIDlet not found for registerAlarm.");
            }
            catch (ConnectionNotFoundException connectionNotFoundException) {
                this.append("Auto execution not supported (PushRegistry.registerAlarm).");
            }
            catch (SecurityException securityException) {
                this.append("Auto execution not allowed (SecurityException).");
            }
        } else if (command == this.noUIMIDletCheckCommand) {
            while (this.size() != 0) {
                this.delete(0);
            }
            this.append("RMS data added by NoUIMIDlet: " + NoUIMIDlet.getInstance().getRMSCount() + ".\n");
            NoUIMIDlet.killMIDlet();
        }
    }

    class ShowHideCanvas
    extends Canvas {
        Command dummy1 = new Command("Dummy to allow menu", 1, 1);
        Command dummy2 = new Command("Dummy to allow menu", 1, 2);
        Command dummy3 = new Command("Dummy to allow menu", 1, 3);
        Command dummy4 = new Command("Dummy to allow menu", 1, 3);
        Command dummy5 = new Command("Dummy to allow menu", 1, 3);
        String name;
        int _paintCount = 0;
        int _showNotifyCount = 0;
        int _hideNotifyCount = 0;
        int _sizeChangedCount = 0;

        ShowHideCanvas(String string) {
            this.name = string;
            this.addCommand(UIStateTest.this.backCommand);
            this.addCommand(this.dummy1);
            this.addCommand(this.dummy2);
            this.addCommand(this.dummy3);
            this.addCommand(this.dummy4);
            this.addCommand(this.dummy5);
            this.addCommand(UIStateTest.this.nextCanvas);
            this.addCommand(UIStateTest.this.toggleFCModeCanvas);
            this.setCommandListener(UIStateTest.this);
        }

        protected void paint(Graphics graphics) {
            System.out.println(this.name + "/paint: " + this._paintCount);
            ++this._paintCount;
            int n = graphics.getFont().getHeight();
            graphics.setGrayScale(255);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setGrayScale(0);
            graphics.drawString("Show notify #" + this._showNotifyCount, 0, 0 * n, 20);
            graphics.drawString("Hide notify #" + this._hideNotifyCount, 0, 1 * n, 20);
        }

        protected void showNotify() {
            System.out.println(this.name + "/show: " + this._showNotifyCount);
            ++this._showNotifyCount;
            this.repaint();
        }

        protected void hideNotify() {
            System.out.println(this.name + "/hide: " + this._hideNotifyCount);
            ++this._hideNotifyCount;
            this.repaint();
        }

        protected void sizeChanged(int n, int n2) {
            System.out.println(this.name + "/sizeChanged: " + this._sizeChangedCount);
            ++this._sizeChangedCount;
            this.repaint();
        }
    }
}

