/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.midp.test.midptest;

import com.nokia.midp.test.midptest.MIDPTest;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;

public class PlatformRequestTest
extends List
implements CommandListener {
    private Command okCommand = new Command("OK", 4, 1);
    private Command backCommand = new Command("Back", 2, 8);
    private Command customCommand = new Command("Custom", 8, 9);
    private Command doPlatformRequest = new Command("Select", 8, 1);
    private TextBox customTextBox = null;
    private String[] urls = new String[]{"http://ea.mobile.nokia.com/ea", "http://wap.google.com", "http://midlet.org", "tel:+35812345678901234", "https://foo.bar", "tel:040123456789p19283#098#", "http://midlet.org/repository/macrospace/goldminer/GoldminerTrium.jad"};

    public PlatformRequestTest() {
        super("Platform Request", 3);
        this.setSelectCommand(this.doPlatformRequest);
        this.addCommand(this.backCommand);
        this.addCommand(this.customCommand);
        this.setCommandListener(this);
        for (int i = 0; i < this.urls.length; ++i) {
            this.append(this.urls[i], null);
        }
        this.setFitPolicy(1);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this && command == this.backCommand) {
            MIDPTest.goBack();
        } else if (displayable != this && command == this.backCommand) {
            MIDPTest.getDisplay().setCurrent((Displayable)this);
        } else if (command == this.doPlatformRequest) {
            String string = this.getString(this.getSelectedIndex());
            this.doPlatformRequest(string);
        } else if (command == this.customCommand) {
            this.customTextBox = new TextBox("Custom", "", 500, 0);
            this.customTextBox.addCommand(this.okCommand);
            this.customTextBox.addCommand(this.backCommand);
            this.customTextBox.setCommandListener((CommandListener)this);
            MIDPTest.getDisplay().setCurrent((Displayable)this.customTextBox);
        } else if (command == this.okCommand && displayable == this.customTextBox) {
            String string = this.customTextBox.getString();
            this.doPlatformRequest(string);
            MIDPTest.getDisplay().setCurrent((Displayable)this);
        }
    }

    private void doPlatformRequest(String string) {
        try {
            boolean bl = MIDPTest.getInstance().platformRequest(string);
            if (!bl) {
                this.showAlert("Platform request returned.");
            } else {
                this.showAlert("You must exit the MIDlet for request to be processed.");
            }
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            this.showAlert("URL not supported.");
        }
    }

    private void showAlert(String string) {
        Alert alert = new Alert(null, string, null, null);
        MIDPTest.getDisplay().setCurrent((Displayable)alert);
    }
}

