/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.midp.test.midptest;

import com.nokia.midp.test.midptest.MIDPTest;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;

public class TimeTest
extends Form
implements CommandListener,
Runnable {
    private Command backCommand = new Command("Back", 2, 8);
    private Command autoUpdateCommand = new Command("Auto update", 1, 2);
    private StringItem sysTimeStringItem;
    private StringItem calTimeStringItem;
    private StringItem gmtTimeStringItem;
    private StringItem[] calTimeOtherTZStringItems;
    String[] timeZoneIDs;
    Thread autoThread = null;
    boolean stopThread = false;

    public TimeTest() {
        super("Time Test");
        this.setCommandListener(this);
        this.addCommand(this.backCommand);
        this.addCommand(this.autoUpdateCommand);
        long l = System.currentTimeMillis();
        this.append("Sys time (UTC): ");
        this.sysTimeStringItem = new StringItem(null, "" + l);
        this.append((Item)this.sysTimeStringItem);
        this.append("\n");
        this.gmtTimeStringItem = new StringItem(null, this.getCalTime("GMT"));
        this.append((Item)this.gmtTimeStringItem);
        this.append("\nDefault time zone:\n");
        TimeZone timeZone = TimeZone.getDefault();
        this.append(timeZone.getID() + "\n");
        this.append("Is default time zone label \"LOCAL\": " + timeZone.getID().equals("LOCAL"));
        this.append("Uses daylight time: " + timeZone.useDaylightTime() + "\n");
        this.append("Raw offset: " + timeZone.getRawOffset() + "\n");
        this.append("Calendar time for default TZ:\n");
        this.calTimeStringItem = new StringItem(null, this.getCalTime(null));
        this.append((Item)this.calTimeStringItem);
        this.append("\nAll supported time zones:\n");
        this.timeZoneIDs = TimeZone.getAvailableIDs();
        this.calTimeOtherTZStringItems = new StringItem[this.timeZoneIDs.length];
        for (int i = 0; i < this.timeZoneIDs.length; ++i) {
            this.append("--" + this.timeZoneIDs[i] + "--\n");
            this.calTimeOtherTZStringItems[i] = new StringItem(null, this.getCalTime(this.timeZoneIDs[i]));
            this.append((Item)this.calTimeOtherTZStringItems[i]);
            this.append("\n");
        }
        this.append("\n\n");
        this.append("Negative date value in Calendar:");
        Date date = new Date(-90000000L);
        this.append("Date (divided by 1000):\n" + date.getTime() / 1000L + "\n");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String string = "Date:" + calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5) + ":" + calendar.get(11) + "-" + calendar.get(12);
        this.append(string);
        this.append("TimeZone Generic form ID tests:\n");
        this.tzGenericForm("GMT+02:00", 0x6DDD00L);
        this.tzGenericForm("GMT+2:00", 0x6DDD00L);
        this.tzGenericForm("GMT-0200", -7200000L);
        this.tzGenericForm("GMT-200", -7200000L);
        this.tzGenericForm("GMT+02", 0x6DDD00L);
        this.tzGenericForm("GMT+2", 0x6DDD00L);
    }

    private void tzGenericForm(String string, long l) {
        boolean bl = false;
        TimeZone timeZone = TimeZone.getTimeZone(string);
        if ((long)timeZone.getRawOffset() == l) {
            bl = true;
        }
        this.append("Supports generic form (tested with \"" + string + "\"): " + bl);
        this.append("\nReported offset for generic form was: " + timeZone.getRawOffset());
    }

    public void run() {
        while (!this.stopThread) {
            this.updateTimes();
            Thread.yield();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("TimeTest thread interrupted.");
            }
        }
        this.autoThread = null;
    }

    private void updateTimes() {
        long l = System.currentTimeMillis();
        this.sysTimeStringItem.setText("" + l);
        this.calTimeStringItem.setText(this.getCalTime(null));
        this.gmtTimeStringItem.setText(this.getCalTime("GMT"));
        for (int i = 0; i < this.calTimeOtherTZStringItems.length; ++i) {
            this.calTimeOtherTZStringItems[i].setText(this.getCalTime(this.timeZoneIDs[i]));
        }
    }

    private String getCalTime(String string) {
        Calendar calendar = null;
        calendar = string == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(string));
        int n = calendar.get(5);
        int n2 = calendar.get(2);
        int n3 = calendar.get(1);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        int n7 = calendar.get(14);
        StringBuffer stringBuffer = new StringBuffer(25);
        stringBuffer.append(n);
        stringBuffer.append('.');
        stringBuffer.append(n2);
        stringBuffer.append('.');
        stringBuffer.append(n3);
        stringBuffer.append('\n');
        stringBuffer.append(n4);
        stringBuffer.append(':');
        stringBuffer.append(n5);
        stringBuffer.append(':');
        stringBuffer.append(n6);
        stringBuffer.append('.');
        stringBuffer.append(n7);
        return stringBuffer.toString();
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this && command == this.backCommand) {
            this.stopThread = true;
            MIDPTest.goBack();
        } else if (command == this.autoUpdateCommand && this.autoThread == null) {
            this.autoThread = new Thread(this);
            try {
                this.autoThread.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Alert alert = new Alert("Cannot start update thread.");
                MIDPTest.getDisplay().setCurrent((Displayable)alert);
            }
        }
    }
}

