/*
* Copyright (c) 2003 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  WV messages  DTD descriptions
*
*
*/


static const TText16* const KCspHeaderDtd11[] = 
    {

    _S16( "<WV-CSP-Message (Session)>" ),
    _S16( "<Session (SessionDescriptor,Transaction+)>" ),
    _S16( "<SessionDescriptor (SessionType,SessionID?)>" ),
    _S16( "<SessionType (#PCDATA)>" ),
    _S16( "<SessionID (#PCDATA)>" ),
    _S16( "<Transaction (TransactionDescriptor,TransactionContent)>" ),
    _S16( "<TransactionDescriptor (TransactionMode,TransactionID?,Poll?)>" ),
    _S16( "<TransactionMode (#PCDATA)>" ),
    _S16( "<TransactionID (#PCDATA)>" ),
    _S16( "<Poll (#PCDATA)>" ),
    _S16( "<TransactionContent (Login-Request | Status | Logout-Request)>" ),
    _S16( "<EndOfTable (#PCDATA)>" ),
        
    };

static const TText16* const KCspContentDtd11[] = 
    {

    _S16( "<Status (Result, ClientID?)>" ),
    _S16( "<Polling-Request EMPTY>" ),
    _S16( "<Login-Request (UserID,ClientID, Password?, DigestBytes?, DigestSchema?, TimeToLive?, SessionCookie)>" ),
    _S16( "<Logout-Request EMPTY>" ),
    _S16( "<Disconnect (Result)>" ),
    _S16( "<KeepAlive-Request (TimeToLive?)>" ),
    _S16( "<SendMessage-Request (DeliveryReport?, MessageInfo, ContentData)>" ),
    _S16( "<SetDeliveryMethod-Request (DeliveryMethod, AcceptedContentLength?, GroupID?)>" ),
    _S16( "<GetMessageList-Request (GroupID?, MessageCount?)>" ),
    _S16( "<RejectMessage-Request (MessageID+)>" ),
    _S16( "<MessageNotification (MessageInfo)>" ),
    _S16( "<GetMessage-Request (MessageID)>" ),
    _S16( "<NewMessage (MessageInfo, ContentData)>" ),
    _S16( "<MessageDelivered (MessageID)>" ),
    _S16( "<DeliveryReport-Request (Result, MessageInfo)>" ),
    _S16( "<ForwardMessage-Request (MessageID, Recipient)>" ),
    _S16( "<DigestBytes (#PCDATA)>" ),
    _S16( "<DigestSchema (#PCDATA)>" ),
    _S16( "<Password (#PCDATA)>" ),
    _S16( "<Nonce (#PCDATA)>" ),
    _S16( "<Result (Code, Description?, DetailedResult*)>" ),
    _S16( "<Code (#PCDATA)>" ),
    _S16( "<Description (#PCDATA)>" ),
    _S16( "<DetailedResult (Code, Description?, UserID*, GroupID*, ScreenName*)>" ),
    _S16( "<SessionCookie (#PCDATA)>" ),
    _S16( "<Sender (User | Group)>" ),
    _S16( "<Recipient (User*, Group*, ContactList*)>" ),
    _S16( "<User (UserID, ClientID?)>" ),
    _S16( "<Group (GroupID | ScreenName)>" ),
    _S16( "<UserID (#PCDATA)>" ),
    _S16( "<ClientID (URL?, MSISDN?)>" ),
    _S16( "<GroupID (#PCDATA)>" ),
    _S16( "<MessageID (#PCDATA)>" ),
    _S16( "<MessageURI (#PCDATA)>" ),
    _S16( "<ScreenName (SName, GroupID)>" ),
    _S16( "<NickName (Name, UserID)>" ),
    _S16( "<URLList (URL+)>" ),
    _S16( "<URL (#PCDATA)>" ),
    _S16( "<MSISDN (#PCDATA)>" ),
    _S16( "<KeepAliveTime (#PCDATA)>" ),
    _S16( "<TimeToLive (#PCDATA)>" ),
    _S16( "<Attribute (Name, Value)>" ),
    _S16( "<SName (#PCDATA)>" ),
    _S16( "<Name (#PCDATA)>" ),
    _S16( "<Value (#PCDATA)>" ),
    _S16( "<Validity (#PCDATA)>" ),
    _S16( "<MessageInfo (MessageID?, MessageURI?, ContentType?, ContentEncoding?, ContentSize, Recipient, Sender, DateTime?, Validity?)>" ),
    _S16( "<DateTime (#PCDATA)>" ),
    _S16( "<MessageCount (#PCDATA)>" ),
    _S16( "<DeliveryReport (#PCDATA)>" ),
    _S16( "<DeliveryMethod (#PCDATA)>" ),
    _S16( "<Logo (ContentType, ContentSize?, ContentEncoding, ContentData)>" ),
    _S16( "<ContentType (#PCDATA)>" ),
    _S16( "<ContentData (#PCDATA)>" ),
    _S16( "<ContentSize (#PCDATA)>" ),
    _S16( "<ContentEncoding (#PCDATA)>" ),
    _S16( "<GetSPInfo-Request (ClientID?)>" ),
    _S16( "<Search-Request (SearchPairList*, SearchLimit?, SearchID?, SearchIndex?)>" ),
    _S16( "<StopSearch-Request (SearchID)>" ),
    _S16( "<ClientCapability-Request (ClientID, CapabilityList?)>" ),
    _S16( "<CapabilityRequest (#PCDATA)>" ),
    _S16( "<CapabilityList (ClientType, InitialDeliveryMethod, SubList1, AcceptedTransferEncoding*, AcceptedContentLength, SupportedBearer*, MultiTrans, ParserSize, SupportedCIRMethod*, UDPPort?, TCPAddress?, TCPPort?, ServerPollMin?, DefaultLanguage?)>" ),
    _S16( "<SubList1 (SubList2 | AcceptedContentType*)>" ),
	_S16( "<SubList2 (AnyContent, AcceptedCharSet*)>" ),
    _S16( "<ClientType (#PCDATA)>" ),
    _S16( "<InitialDeliveryMethod (#PCDATA)>" ),
    _S16( "<AnyContent (#PCDATA)>" ),
    _S16( "<AcceptedCharSet (#PCDATA)>" ),
    _S16( "<AcceptedContentType (#PCDATA)>" ),
    _S16( "<AcceptedTransferEncoding (#PCDATA)>" ),
    _S16( "<AcceptedContentLength (#PCDATA)>" ),
    _S16( "<SupportedBearer (#PCDATA)>" ),
    _S16( "<MultiTrans (#PCDATA)>" ),
    _S16( "<ParserSize (#PCDATA)>" ),
    _S16( "<SupportedCIRMethod (#PCDATA)>" ),
    _S16( "<UDPPort (#PCDATA)>" ),
    _S16( "<TCPAddress (#PCDATA)>" ),
    _S16( "<TCPPort (#PCDATA)>" ),
    _S16( "<ServerPollMin (#PCDATA)>" ),
    _S16( "<DefaultLanguage (#PCDATA)>" ),
    _S16( "<GroupList (GroupID+)>" ),
    _S16( "<UserList (User*, ScreenName*)>" ),
    _S16( "<ContactList (#PCDATA)>" ),
    _S16( "<DefaultContactList (#PCDATA)>" ),
    _S16( "<AddNickList (SubList3*)>" ),
    _S16( "<NickList (SubList3*)>" ),
	_S16( "<SubList3 (NickName | UserID)>" ),
    _S16( "<RemoveNickList (UserID+)>" ),
    _S16( "<DefaultList (#PCDATA)>" ),
    _S16( "<ClientCapability-Request (ClientID, CapabilityList?)>" ),
    _S16( "<CapabilityRequest (#PCDATA)>" ),
    _S16( "<ClientType (#PCDATA)>" ),
    _S16( "<InitialDeliveryMethod (#PCDATA)>" ),
    _S16( "<AnyContent (#PCDATA)>" ),
    _S16( "<AcceptedCharSet (#PCDATA)>" ),
    _S16( "<AcceptedContentType (#PCDATA)>" ),
    _S16( "<AcceptedTransferEncoding (#PCDATA)>" ),
    _S16( "<Service-Request (ClientID, Functions?, AllFunctionsRequest)>" ),
    _S16( "<AllFunctionsRequest (#PCDATA)>" ),
    _S16( "<AllFunctions (WVCSPFeat)>" ),
    _S16( "<Functions (WVCSPFeat)>" ),
    _S16( "<WVCSPFeat (FundamentalFeat?, PresenceFeat?, IMFeat?, GroupFeat?)>" ),
    _S16( "<FundamentalFeat (ServiceFunc?, SearchFunc?, InviteFunc?)>" ),
    _S16( "<PresenceFeat (ContListFunc?, PresenceAuthFunc?, PresenceDeliverFunc?, AttListFunc?)>" ),
    _S16( "<IMFeat (IMSendFunc?, IMReceiveFunc?, IMAuthFunc?)>" ),
    _S16( "<GroupFeat (GroupMgmtFunc?, GroupUseFunc?, GroupAuthFunc?)>" ),
    _S16( "<ServiceFunc (GETSPI?)>" ),
    _S16( "<SearchFunc (SRCH?, STSRC?)>" ),
    _S16( "<InviteFunc (INVIT?, CAINV?)>" ),
    _S16( "<ContListFunc (GCLI?, CCLI?, DCLI?, MCLS?)>" ),
    _S16( "<PresenceAuthFunc (GETWL?, REACT?, CAAUT?)>" ),
    _S16( "<PresenceDeliverFunc (GETPR?, UPDPR?)>" ),
    _S16( "<AttListFunc (CALI?, DALI?, GALS?)>" ),
    _S16( "<IMSendFunc (MDELIV?, FWMSG?)>" ),
    _S16( "<IMReceiveFunc (SETD?, GETLM?, GETM?, REJCM?, NOTIF?, NEWM?)>" ),
    _S16( "<IMAuthFunc (GLBLU?, BLENT?)>" ),
    _S16( "<GroupMgmtFunc (CREAG?, DELGR?, GETGP?, SETGP?)>" ),
    _S16( "<GroupUseFunc (SUBGCN?, GRCHN?)>" ),
    _S16( "<GroupAuthFunc (GETGM?, ADDGM?, RMVGM?, MBRAC?, REJEC?)>" ),
    _S16( "<GETSPI EMPTY>" ),
    _S16( "<SRCH EMPTY>" ),
    _S16( "<STSRC EMPTY>" ),
    _S16( "<INVIT EMPTY>" ),
    _S16( "<CAINV EMPTY>" ),
    _S16( "<GCLI EMPTY>" ),
    _S16( "<CCLI EMPTY>" ),
    _S16( "<DCLI EMPTY>" ),
    _S16( "<MCLS EMPTY>" ),
    _S16( "<GETWL EMPTY>" ),
    _S16( "<REACT EMPTY>" ),
    _S16( "<CAAUT EMPTY>" ),
    _S16( "<GETPR EMPTY>" ),
    _S16( "<UPDPR EMPTY>" ),
    _S16( "<CALI EMPTY>" ),
    _S16( "<DALI EMPTY>" ),
    _S16( "<GALS EMPTY>" ),
    _S16( "<MDELIV EMPTY>" ),
    _S16( "<FWMSG EMPTY>" ),
    _S16( "<SETD EMPTY>" ),
    _S16( "<GETLM EMPTY>" ),
    _S16( "<GETM EMPTY>" ),
    _S16( "<REJCM EMPTY>" ),
    _S16( "<NOTIF EMPTY>" ),
    _S16( "<NEWM EMPTY>" ),
    _S16( "<GLBLU EMPTY>" ),
    _S16( "<BLENT EMPTY>" ),
    _S16( "<CREAG EMPTY>" ),
    _S16( "<DELGR EMPTY>" ),
    _S16( "<GETGP EMPTY>" ),
    _S16( "<SETGP EMPTY>" ),
    _S16( "<SUBGCN EMPTY>" ),
    _S16( "<GRCHN EMPTY>" ),
    _S16( "<GETGM EMPTY>" ),
    _S16( "<ADDGM EMPTY>" ),
    _S16( "<RMVGM EMPTY>" ),
    _S16( "<MBRAC EMPTY>" ),
    _S16( "<REJEC EMPTY>" ),
    _S16( "<GetBlockedList-Request EMPTY>" ),
    _S16( "<BlockUser-Request (BlockList?, GrantList?)>" ),
    _S16( "<BlockList (InUse?, SubList4?)>" ),
	_S16( "<SubList4 (EntityList | SubList5)>" ),
	_S16( "<SubList5 (AddList?, RemoveList?)>" ),
    _S16( "<DeleteAttributeList-Request (UserID*, ContactList*, DefaultList)>" ),
    _S16( "<CreateAttributeList-Request (PresenceSubList, UserID*, ContactList*, DefaultList)>" ),
    _S16( "<ListManage-Request (ContactList, SubList6?)>" ),
	_S16( "<SubList6 (AddNickList | RemoveNickList | ContactListProperties)>" ),
    _S16( "<DeleteList-Request (ContactList)>" ),
    _S16( "<CreateList-Request (ContactList, NickList?, ContactListProperties?)>" ),
    _S16( "<UpdatePresence-Request (PresenceSubList)>" ),
    _S16( "<CancelAuth-Request (UserID)>" ),
    _S16( "<PresenceAuth-User (UserID, Acceptance)>" ),
    _S16( "<SubscribePresence-Request (User*, ContactList*, PresenceSubList?)>" ),
    _S16( "<GetPresence-Request (SubList7, PresenceSubList?)>" ),
	_S16( "<SubList7 (User+ | ContactList+)>" ),
    _S16( "<PresenceSubList (OnlineStatus?, Registration?, ClientInfo?, TimeZone?, GeoLocation?, Address?, FreeTextLocation?, PLMN?, CommCap?, UserAvailability?, PreferredContacts?, PreferredLanguage?, StatusText?, StatusMood?, Alias?, StatusContent?, ContactInfo?)>" ),
    _S16( "<AcceptedContentLength (#PCDATA)>" ),
    _S16( "<SupportedBearer (#PCDATA)>" ),
    _S16( "<MultiTrans (#PCDATA)>" ),
    _S16( "<ParserSize (#PCDATA)>" ),
    _S16( "<SupportedCIRMethod (#PCDATA)>" ),
    _S16( "<UDPPort (#PCDATA)>" ),
    _S16( "<TCPAddress (#PCDATA)>" ),
    _S16( "<TCPPort (#PCDATA)>" ),
    _S16( "<ServerPollMin (#PCDATA)>" ),
    _S16( "<DefaultLanguage (#PCDATA)>" ),
    _S16( "<GroupList (GroupID+)>" ),
    _S16( "<UserList (User*, ScreenName*)>" ),
    _S16( "<ContactList (#PCDATA)>" ),
    _S16( "<DefaultContactList (#PCDATA)>" ),
    _S16( "<NickList (NickName*)>" ),
    _S16( "<AddNickList (NickName*)>" ),
    _S16( "<RemoveNickList (UserID+)>" ),
    _S16( "<DefaultList (#PCDATA)>" ),
    _S16( "<GetAttributeList-Request (DefaultList, ContactList*, User*)>" ),
    _S16( "<UnsubscribePresence-Request (User*, ContactList*)>" ),
    _S16( "<GetList-Request EMPTY>" ),
    _S16( "<GetWatcherList-Request EMPTY>" ),
    _S16( "<Acceptance (#PCDATA)>" ),
    _S16( "<SearchPairList (SearchElement, SearchString)>" ),
    _S16( "<SearchElement (#PCDATA)>" ),
    _S16( "<SearchString (#PCDATA)>" ),
    _S16( "<SearchLimit (#PCDATA)>" ),
    _S16( "<SearchID (#PCDATA)>" ),
    _S16( "<SearchIndex (#PCDATA)>" ),
    _S16( "<SearchFindings (#PCDATA)>" ),
    _S16( "<SearchResult (UserList?, GroupList?)>" ),
    _S16( "<CreateGroup-Request (GroupID, GroupProperties, JoinGroup, ScreenName?, SubscribeNotification)>" ),
    _S16( "<DeleteGroup-Request (GroupID)>" ),
    _S16( "<JoinGroup-Request (GroupID, ScreenName?, JoinedRequest?, SubscribeNotification)>" ),
    _S16( "<JoinGroup (#PCDATA)>" ),
    _S16( "<SubscribeNotification (#PCDATA)>" ),
    _S16( "<LeaveGroup-Request (GroupID)>" ),
    _S16( "<LeaveGroup-Response (GroupID?, Result)>" ),
    _S16( "<GetGroupMembers-Request (GroupID)>" ),
    _S16( "<AddGroupMembers-Request (GroupID, UserList)>" ),
    _S16( "<RemoveGroupMembers-Request (GroupID, UserList)>" ),
    _S16( "<MemberAccess-Request (GroupID, Admin?, Mod?, Users?)>" ),
    _S16( "<GetGroupProps-Request (GroupID)>" ),
    _S16( "<SetGroupProps-Request (GroupID, GroupProperties?, OwnProperties?)>" ),
    _S16( "<RejectList-Request (GroupID, AddList?, RemoveList?)>" ),
    _S16( "<SubscribeGroupNotice-Request (GroupID, SubscribeType)>" ),
    _S16( "<GroupChangeNotice (GroupID, Joined?, Left?, GroupProperties?, OwnProperties?)>" ),
    _S16( "<GrantList (InUse?, SubList8?)>" ),
	_S16( "<SubList8 (EntityList | SubList9)>" ),
	_S16( "<SubList9 (AddList?, RemoveList?)>" ),
    _S16( "<EntityList (UserID*, ScreenName*, GroupID*)>" ),
    _S16( "<AddList (UserID*, ScreenName*, GroupID*)>" ),
    _S16( "<RemoveList (UserID*, ScreenName*, GroupID*)>" ),
    _S16( "<InUse (#PCDATA)>" ),
    _S16( "<ContactListProperties (Property+)>" ),
    _S16( "<GroupProperties (Property+, WelcomeNote?)>" ),
    _S16( "<OwnProperties (Property+)>" ),
    _S16( "<Property (Name, Value?)>" ),
    _S16( "<WelcomeNote (ContentType, ContentEncoding?, ContentData)>" ),
    _S16( "<JoinedRequest (#PCDATA)>" ),
    _S16( "<Admin (UserList)>" ),
    _S16( "<Mod (UserList)>" ),
    _S16( "<Users (UserList)>" ),
    _S16( "<SubscribeType (#PCDATA)>" ),
    _S16( "<Joined (ScreenName+)>" ),
    _S16( "<Left (ScreenName+)>" ),
    _S16( "<Invite-Request (InviteID, InviteType, Recipient, GroupID?, PresenceSubList?, URLList?, InviteNote?, ScreenName?, Validity)>" ),
    _S16( "<InviteUser-Response (InviteID, Acceptance, ResponseNote?, ScreenName?)>" ),
    _S16( "<CancelInvite-Request (InviteID, Recipient, InviteNote?, URLList?, ScreenName?)>" ),
    _S16( "<InviteID (#PCDATA)>" ),
    _S16( "<InviteType (#PCDATA)>" ),
    _S16( "<InviteNote (#PCDATA)>" ),
    _S16( "<ResponseNote (#PCDATA)>" ),
    _S16( "<EndOfTable (#PCDATA)>" ),


        };

    static const TText16* const KCspPresenceDtd11[] = 
    {

    _S16( "<PresenceSubList (OnlineStatus?, Registration?, ClientInfo?, TimeZone?, GeoLocation?, Address?, FreeTextLocation?, PLMN?, CommCap?, UserAvailability?, PreferredContacts?, PreferredLanguage?, StatusText?, StatusMood?, Alias?, StatusContent?, ContactInfo?)>" ),
    _S16( "<Qualifier (#PCDATA)>" ),
    _S16( "<PresenceValue (#PCDATA)>" ),
    _S16( "<OnlineStatus (Qualifier?, PresenceValue?)>" ),
    _S16( "<Registration (Qualifier?, PresenceValue?)>" ),
    _S16( "<FreeTextLocation (Qualifier?, PresenceValue?)>" ),
    _S16( "<PLMN (Qualifier?, PresenceValue?)>" ),
    _S16( "<UserAvailability (Qualifier?, PresenceValue?)>" ),
    _S16( "<PreferredLanguage (Qualifier?, PresenceValue?)>" ),
    _S16( "<StatusText (Qualifier?, PresenceValue?)>" ),
    _S16( "<StatusMood (Qualifier?, PresenceValue?)>" ),
    _S16( "<Alias (Qualifier?, PresenceValue?)>" ),
    _S16( "<ClientInfo (Qualifier?, ClientType?, DevManufacturer?, ClientProducer?, Model?, ClientVersion?, Language?)>" ),
    _S16( "<ClientType (#PCDATA)>" ),
    _S16( "<DevManufacturer (#PCDATA)>" ),
    _S16( "<ClientProducer (#PCDATA)>" ),
    _S16( "<Model (#PCDATA)>" ),
    _S16( "<ClientVersion (#PCDATA)>" ),
    _S16( "<Language (#PCDATA)>" ),
    _S16( "<TimeZone (Qualifier?, Zone?)>" ),
    _S16( "<Zone (#PCDATA)>" ),
    _S16( "<GeoLocation (Qualifier?, Longitude?, Latitude?, Altitude?, Accuracy?)>" ),
    _S16( "<Longitude (#PCDATA)>" ),
    _S16( "<Latitude (#PCDATA)>" ),
    _S16( "<Altitude (#PCDATA)>" ),
    _S16( "<Accuracy (#PCDATA)>" ),
    _S16( "<Address (Qualifier?, Country?, City?, Street?, Crossing1?, Crossing2?, Building?, NamedArea?, Accuracy?)>" ),
    _S16( "<Country (#PCDATA)>" ),
    _S16( "<City (#PCDATA)>" ),
    _S16( "<Street (#PCDATA)>" ),
    _S16( "<Crossing1 (#PCDATA)>" ),
    _S16( "<Crossing2 (#PCDATA)>" ),
    _S16( "<Building (#PCDATA)>" ),
    _S16( "<NamedArea (#PCDATA)>" ),
    _S16( "<CommCap (Qualifier?, CommC*)>" ),
    _S16( "<CommC (Cap, Status, Contact?, Note?)>" ),
    _S16( "<Cap (#PCDATA)>" ),
    _S16( "<Status (#PCDATA)>" ),
    _S16( "<Contact (#PCDATA)>" ),
    _S16( "<Note (#PCDATA)>" ),
    _S16( "<PreferredContacts (Qualifier?, AddrPref*)>" ),
    _S16( "<AddrPref (PrefC, Caddr, Cstatus, CName?,Cpriority?)>" ),
    _S16( "<PrefC (#PCDATA)>" ),
    _S16( "<Caddr (#PCDATA)>" ),
    _S16( "<Cstatus (#PCDATA)>" ),
    _S16( "<CName (#PCDATA)>" ),
    _S16( "<Cpriority (#PCDATA)>" ),
    _S16( "<StatusContent (Qualifier?, DirectContent?, ReferredContent?, ContentType?)>" ),
    _S16( "<DirectContent (#PCDATA)>" ),
    _S16( "<ReferredContent (#PCDATA)>" ),
    _S16( "<ContentType (#PCDATA)>" ),
    _S16( "<ContactInfo (Qualifier?, ContainedvCard?, ReferredvCard?)>" ),
    _S16( "<ContainedvCard (#PCDATA)>" ),
    _S16( "<ReferredvCard (#PCDATA)>" ),
    _S16( "<EndOfTable (#PCDATA)>" ),

    };

//////////////////////////////////////////////////////////////////////////
// CSP 1.2 tables


const   TInt KImpsHeaderDtd12Count =              14;
const   TInt KImpsTransactionDtd12Count =         287;
const   TInt KImpsPresenceDtd12Count =            58;


static const TText16* const KCspHeaderDtd12[] = 
    {
    _S16( "<WV-CSP-Message (Session)>"),
    _S16( "<Session (SessionDescriptor, Transaction+, Poll? , CIR?)>"),
    _S16( "<SessionDescriptor (SessionType, SessionID?)>"),
    _S16( "<SessionType (#PCDATA)>"),
    _S16( "<SessionID (#PCDATA)>"),
    _S16( "<Transaction (TransactionDescriptor, TransactionContent, ExtBlock*)>"),
    _S16( "<TransactionDescriptor (TransactionMode, TransactionID)>"),
    _S16( "<TransactionMode (#PCDATA)>"),
    _S16( "<TransactionID (#PCDATA)>"),
    _S16( "<Poll (#PCDATA)>"),
    _S16( "<CIR (#PCDATA)>"),
    _S16( "<TransactionContent (Login-Request | Status | Logout-Request)>" ),
    _S16( "<ExtBlock (APIClient?)>"), // extending the transaction with APIClient only in SendMessage and NewMessage
    _S16( "<APIClient (#PCDATA)>"),
    _S16( "<EndOfTable (#PCDATA)>" )
    };

static const TText16* const KCspContentDtd12[] = 
    {
    _S16( "<Status (Result, ClientID?)>"),
    _S16( "<Polling-Request EMPTY>"),
    _S16( "<Login-Request (UserID, ClientID, Password?, DigestBytes?, DigestSchema*, TimeToLive?, SessionCookie)>"),
    _S16( "<Login-Response (ClientID, Result, Nonce?, DigestSchema?, SessionID?, KeepAliveTime?, CapabilityRequest?)>"),
    _S16( "<Service-Request (Functions, AllFunctionsRequest)>"),
    _S16( "<Service-Response (Functions?, AllFunctions?)>"),
    _S16( "<ClientCapability-Request (CapabilityList)>"),
    _S16( "<ClientCapability-Response (AgreedCapabilityList)>"),
    _S16( "<Logout-Request EMPTY>"),
    _S16( "<Disconnect (Result)>"),
    _S16( "<KeepAlive-Request (TimeToLive?)>"),
    _S16( "<KeepAlive-Response (Result, KeepAliveTime?)>"),
    _S16( "<GetSPInfo-Request (ClientID?)>"),
    _S16( "<GetSPInfo-Response (ClientID?, Name, Logo?, Description?,URL?)>"),
    _S16( "<Search-Request (SearchPairList*, SearchLimit?, SearchID?, SearchIndex?)>"),
    _S16( "<StopSearch-Request (SearchID)>"),
    _S16( "<Search-Response (SearchID?, SearchFindings, CompletionFlag, SearchIndex, SearchResult?)>"),
    _S16( "<CompletionFlag (#PCDATA)>"),
    _S16( "<Invite-Request (InviteID, InviteType, Recipient, GroupID?, PresenceSubList?, URLList?, InviteNote?, ScreenName?, Validity?)>"),
    _S16( "<Invite-Response (InviteID, Acceptance, Sender, ResponseNote?)>"),
    _S16( "<InviteUser-Request (InviteID, InviteType, Sender, GroupID?, PresenceSubList?, URLList?, InviteNote?, Validity?)>"),
    _S16( "<InviteUser-Response (InviteID, Acceptance, Sender, ResponseNote?, ScreenName?)>"),
    _S16( "<CancelInvite-Request (InviteID, Recipient?, InviteNote?, URLList?, ScreenName?)>"),
    _S16( "<CancelInviteUser-Request (InviteID, Sender, InviteNote?, URLList?)>"),
    _S16( "<VerifyID-Request (IDList)>"),
    _S16( "<SubscribePresence-Request (User*, ContactList*, PresenceSubList?, AutoSubscribe)>"),
    _S16( "<UnsubscribePresence-Request (User*, ContactList*)>"),
    _S16( "<PresenceNotification-Request (Presence+)>"),
    _S16( "<GetWatcherList-Request (HistoryPeriod?, MaxWatcherList?)>"),
    _S16( "<GetWatcherList-Response (HistoryPeriod?, Watcher*)>"),
    _S16( "<GetPresence-Request (Sublist1, PresenceSubList?)>"),
    _S16( "<Sublist1 (User+ | ContactList+)>"),
    _S16( "<GetPresence-Response (Result, Presence*)>"),
    _S16( "<PresenceAuth-Request (UserID, PresenceSubList?)>"),
    _S16( "<PresenceAuth-User (UserID, Acceptance, PresenceSubList?)>"),
    _S16( "<CancelAuth-Request (UserID)>"),
    _S16( "<GetReactiveAuthStatus-Request (UserID*)>"),
    _S16( "<GetReactiveAuthStatus-Response (ReactiveAuthStatusList)>"),
    _S16( "<UpdatePresence-Request (PresenceSubList)>"),
    _S16( "<GetList-Request EMPTY>"),
    _S16( "<GetList-Response (ContactList*, DefaultContactList?)>"),
    _S16( "<CreateList-Request (ContactList, NickList?, ContactListProperties?)>"),
    _S16( "<DeleteList-Request (ContactList)>"),
    _S16( "<ListManage-Request (ContactList, Sublist2?, ReceiveList)>"),
    _S16( "<Sublist2 (AddNickList | RemoveNickList | ContactListProperties)>"),
    _S16( "<ListManage-Response (Result, NickList?, ContactListProperties?)>"),
    _S16( "<CreateAttributeList-Request (PresenceSubList, UserID*, ContactList*, DefaultList)>"),
    _S16( "<DeleteAttributeList-Request (UserID*, ContactList*, DefaultList)>"),
    _S16( "<GetAttributeList-Request (DefaultList, ContactList*, User*)>"),
    _S16( "<GetAttributeList-Response (Result, DefaultAttributeList?, Presence*)>"),
    _S16( "<SendMessage-Request (DeliveryReport, MessageInfo, ContentData?)>"),
    _S16( "<SendMessage-Response (Result, MessageID?)>"),
    _S16( "<SetDeliveryMethod-Request (DeliveryMethod, AcceptedContentLength?, GroupID?)>"),
    _S16( "<GetMessageList-Request (GroupID?, MessageCount?)>"),
    _S16( "<GetMessageList-Response (MessageInfo*)>"),
    _S16( "<RejectMessage-Request (MessageID+)>"),
    _S16( "<MessageNotification (MessageInfo)>"),
    _S16( "<GetMessage-Request (MessageID)>"),
    _S16( "<GetMessage-Response (MessageInfo, ContentData?)>"),
    _S16( "<NewMessage (MessageInfo, ContentData?)>"),
    _S16( "<MessageDelivered (MessageID)>"),
    _S16( "<DeliveryReport-Request (Result, DeliveryTime?, MessageInfo)>"),
    _S16( "<DeliveryTime (#PCDATA)>"),
    _S16( "<ForwardMessage-Request (MessageID, Recipient)>"),
    _S16( "<GetBlockedList-Request EMPTY>"),
    _S16( "<GetBlockedList-Response (BlockList?, GrantList?)>"),
    _S16( "<BlockUser-Request (BlockList?, GrantList?)>"),
    _S16( "<CreateGroup-Request (GroupID, GroupProperties, JoinGroup, ScreenName?, SubscribeNotification)>"),
    _S16( "<DeleteGroup-Request (GroupID)>"),
    _S16( "<JoinGroup-Request (GroupID, ScreenName?, JoinedRequest, SubscribeNotification, OwnProperties?)>"),
    _S16( "<JoinGroup (#PCDATA)>"),
    _S16( "<SubscribeNotification (#PCDATA)>"),
    _S16( "<JoinGroup-Response (UserMapList?, WelcomeNote?)>"),
    _S16( "<LeaveGroup-Request (GroupID)>"),
    _S16( "<LeaveGroup-Response (GroupID?, Result)>"),
    _S16( "<GetGroupMembers-Request (GroupID)>"),
    _S16( "<GetGroupMembers-Response (Admin?, Mod?, Users?)>"),
    _S16( "<GetJoinedUsers-Request (GroupID)>"),
    _S16( "<GetJoinedUsers-Response (AdminMapList | UserMapList)>"),
    _S16( "<AddGroupMembers-Request (GroupID, UserList)>"),
    _S16( "<RemoveGroupMembers-Request (GroupID, UserList)>"),
    _S16( "<MemberAccess-Request (GroupID, Admin?, Mod?, Users?)>"),
    _S16( "<GetGroupProps-Request (GroupID)>"),
    _S16( "<GetGroupProps-Response (GroupProperties, OwnProperties)>"),
    _S16( "<SetGroupProps-Request (GroupID, GroupProperties?, OwnProperties?)>"),
    _S16( "<RejectList-Request (GroupID, AddList?, RemoveList?)>"),
    _S16( "<RejectList-Response (UserList?)>"),
    _S16( "<SubscribeGroupNotice-Request (GroupID, SubscribeType)>"),
    _S16( "<SubscribeGroupNotice-Response (Value)>"),
    _S16( "<GroupChangeNotice (GroupID, Joined?, Left?, GroupProperties?, OwnProperties?)>"),
    _S16( "<Extended-Request (#PCDATA)>"),
    _S16( "<Extended-Response (#PCDATA)>"),
    _S16( "<DigestBytes (#PCDATA)>"),
    _S16( "<DigestSchema (#PCDATA)>"),
    _S16( "<Password (#PCDATA)>"),
    _S16( "<Nonce (#PCDATA)>"),
    _S16( "<CapabilityRequest (#PCDATA)>"),
    _S16( "<CapabilityList (ClientType, InitialDeliveryMethod, Sublist3, AcceptedTransferEncoding*, AcceptedContentLength, SupportedBearer*, MultiTrans, ParserSize, SupportedCIRMethod*, UDPPort?, ServerPollMin?, DefaultLanguage?)>"),
    _S16( "<Sublist3 (Sublist4 | AcceptedContentType*)>"),
    _S16( "<Sublist4 (AnyContent, AcceptedCharSet*)>"),
    _S16( "<AgreedCapabilityList (SupportedBearer*, SupportedCIRMethod*, TCPAddress?, TCPPort?, ServerPollMin?, CIRURL?)>"),
    _S16( "<ClientType (#PCDATA)>"),
    _S16( "<InitialDeliveryMethod (#PCDATA)>"),
    _S16( "<AnyContent (#PCDATA)>"),
    _S16( "<AcceptedCharSet (#PCDATA)>"),
    _S16( "<AcceptedContentType (#PCDATA)>"),
    _S16( "<AcceptedTransferEncoding (#PCDATA)>"),
    _S16( "<AcceptedContentLength (#PCDATA)>"),
    _S16( "<SupportedBearer (#PCDATA)>"),
    _S16( "<MultiTrans (#PCDATA)>"),
    _S16( "<ParserSize (#PCDATA)>"),
    _S16( "<SupportedCIRMethod (#PCDATA)>"),
    _S16( "<UDPPort (#PCDATA)>"),
    _S16( "<TCPAddress (#PCDATA)>"),
    _S16( "<TCPPort (#PCDATA)>"),
    _S16( "<ServerPollMin (#PCDATA)>"),
    _S16( "<DefaultLanguage (#PCDATA)>"),
    _S16( "<CIRURL (URL)>"),
    _S16( "<Result (Code, Description?, DetailedResult*)>"),
    _S16( "<Code (#PCDATA)>"),
    _S16( "<Description (#PCDATA)>"),
    _S16( "<DetailedResult (Code, Description?, UserID*, GroupID*, ScreenName*, MessageID*, ContactList*, Domain*)>"),
    _S16( "<HistoryPeriod (#PCDATA)>"),
    _S16( "<Watcher (User, WatcherStatus?)>"),
    _S16( "<WatcherStatus (#PCDATA)>"),
    _S16( "<SessionCookie (#PCDATA)>"),
    _S16( "<Sender (User | Group)>"),
    _S16( "<Recipient (User*, Group*, ContactList*)>"),
    _S16( "<User (UserID, ClientID?)>"),
    _S16( "<Group (GroupID | ScreenName)>"),
    _S16( "<UserID (#PCDATA)>"),
    _S16( "<ClientID (URL?, MSISDN?)>"),
    _S16( "<GroupID (#PCDATA)>"),
    _S16( "<IDList (UserID*, ContactList*, GroupID*, ScreenName*, Domain*)>"),
    _S16( "<MessageID (#PCDATA)>"),
    _S16( "<MessageURI (#PCDATA)>"),
    _S16( "<ScreenName (SName, GroupID)>"),
    _S16( "<NickName (Name, UserID)>"),
    _S16( "<URLList (URL+)>"),
    _S16( "<URL (#PCDATA)>"),
    _S16( "<MSISDN (#PCDATA)>"),
    _S16( "<GroupList (GroupID+)>"),
    _S16( "<UserList (User*, ScreenName*)>"),
    _S16( "<ContactList (#PCDATA)>"),
    _S16( "<DefaultContactList (#PCDATA)>"),
    _S16( "<NickList ((NickName | UserID)*)>"),
    _S16( "<AddNickList (Sublist5+)>"),
    _S16( "<Sublist5 (NickName | UserID)>"),
    _S16( "<ReceiveList (#PCDATA)>"),
    _S16( "<RemoveNickList (UserID+)>"),
    _S16( "<DefaultList (#PCDATA)>"),
    _S16( "<ReactiveAuthStatusList (ReactiveAuthStatus*)>"),
    _S16( "<ReactiveAuthStatus (UserID, ReactiveAuthState, PresenceSubList?)>"),
    _S16( "<ReactiveAuthState (#PCDATA)>"),
    _S16( "<SearchPairList (SearchElement, SearchString)>"),
    _S16( "<SearchElement (#PCDATA)>"),
    _S16( "<SearchString (#PCDATA)>"),
    _S16( "<SearchLimit (#PCDATA)>"),
    _S16( "<SearchID (#PCDATA)>"),
    _S16( "<SearchIndex (#PCDATA)>"),
    _S16( "<SearchFindings (#PCDATA)>"),
    _S16( "<SearchResult (UserList?, GroupList?)>"),
    _S16( "<InviteID (#PCDATA)>"),
    _S16( "<InviteType (#PCDATA)>"),
    _S16( "<InviteNote (#PCDATA)>"),
    _S16( "<Acceptance (#PCDATA)>"),
    _S16( "<ResponseNote (#PCDATA)>"),
    _S16( "<DefaultAttributeList (PresenceSubList*)>"),
    _S16( "<Presence (Sublist6, PresenceSubList*)>"),
    _S16( "<Sublist6 (UserID | ContactList)>"),
    _S16( "<PresenceSubList (OnlineStatus?,Registration?, ClientInfo?, TimeZone?, GeoLocation?,Address?,FreeTextLocation?,PLMN?,CommCap?,UserAvailability?, PreferredContacts?,PreferredLanguage?,StatusText?, StatusMood?, Alias?, StatusContent?, ContactInfo?, InfoLink?)>"),
    _S16( "<AutoSubscribe (#PCDATA)>"),
    _S16( "<KeepAliveTime (#PCDATA)>"),
    _S16( "<TimeToLive (#PCDATA)>"),
    _S16( "<SName (#PCDATA)>"),
    _S16( "<Name (#PCDATA)>"),
    _S16( "<Value (#PCDATA)>"),
    _S16( "<Validity (#PCDATA)>"),
    _S16( "<MessageInfo (MessageID?, MessageURI?, ContentType?, ContentEncoding?, ContentSize, Recipient, Sender, DateTime?, Validity?)>"),
    _S16( "<DateTime (#PCDATA)>"),
    _S16( "<MessageCount (#PCDATA)>"),
    _S16( "<DeliveryReport (#PCDATA)>"),
    _S16( "<DeliveryMethod (#PCDATA)>"),
    _S16( "<BlockList (InUse?, Sublist7?)>"),
    _S16( "<Sublist7 (EntityList| Sublist8)>"),
    _S16( "<Sublist8 (AddList?, RemoveList?)>"),
    _S16( "<GrantList (InUse?, Sublist9?)>"),
    _S16( "<Sublist9 (EntityList| Sublist10)>"),
    _S16( "<Sublist10 (AddList?, RemoveList?)>"),
    _S16( "<EntityList (UserID*, ScreenName*, GroupID*)>"),
    _S16( "<AddList (UserID*, ScreenName*, GroupID*)>"),
    _S16( "<RemoveList (UserID*, ScreenName*, GroupID*)>"),
    _S16( "<InUse (#PCDATA)>"),
    _S16( "<ContactListProperties (Property+)>"),
    _S16( "<GroupProperties (Property+, WelcomeNote?)>"),
    _S16( "<OwnProperties (Property+)>"),
    _S16( "<Property (Name, Value?)>"),
    _S16( "<WelcomeNote (ContentType, ContentEncoding?, ContentData)>"),
    _S16( "<JoinedRequest (#PCDATA)>"),
    _S16( "<Admin (UserList)>"),
    _S16( "<Mod (UserList)>"),
    _S16( "<Users (UserList)>"),
    _S16( "<AdminMapList (AdminMapping?, ModMapping?, UserMapping?)>"),
    _S16( "<UserMapList (UserMapping?)>"),
    _S16( "<AdminMapping (Mapping+)>"),
    _S16( "<ModMapping (Mapping+)>"),
    _S16( "<UserMapping (Mapping+)>"),
    _S16( "<Mapping (SName, UserID?)>"),
    _S16( "<SubscribeType (#PCDATA)>"),
    _S16( "<Joined (UserMapList)>"),
    _S16( "<Left (UserList)>"),
    _S16( "<Logo (ContentType, ContentSize?, ContentEncoding, ContentData)>"),
    _S16( "<ContentType (#PCDATA)>"),
    _S16( "<ContentData (#PCDATA)>"),
    _S16( "<ContentSize (#PCDATA)>"),
    _S16( "<ContentEncoding (#PCDATA)>"),
    _S16( "<AllFunctionsRequest (#PCDATA)>"),
    _S16( "<AllFunctions (WVCSPFeat)>"),
    _S16( "<Functions (WVCSPFeat)>"),
    _S16( "<WVCSPFeat (FundamentalFeat?, PresenceFeat?, IMFeat?, GroupFeat?)>"),
    _S16( "<FundamentalFeat (Sublist11?)>"),
    _S16( "<Sublist11 (MF | Sublist12)>"),
    _S16( "<Sublist12 (ServiceFunc?, SearchFunc?, InviteFunc?)>"),
    _S16( "<PresenceFeat (Sublist13?)>"),
    _S16( "<Sublist13 (MP | Sublist14)>"),
    _S16( "<Sublist14 (ContListFunc?, PresenceAuthFunc?, PresenceDeliverFunc?, AttListFunc?)>"),
    _S16( "<IMFeat (Sublist15?)>"),
    _S16( "<Sublist15 (MM | Sublist16)>"),
    _S16( "<Sublist16 (IMSendFunc?, IMReceiveFunc?, IMAuthFunc?)>"),
    _S16( "<GroupFeat (Sublist17?)>"),
    _S16( "<Sublsit17 (MG | Sublist18)>"),
    _S16( "<Sublist18 (GroupMgmtFunc?, GroupUseFunc?, GroupAuthFunc?)>"),
    _S16( "<MF EMPTY>"),
    _S16( "<MP EMPTY>"),
    _S16( "<MM EMPTY>"),
    _S16( "<MG EMPTY>"),
    _S16( "<ServiceFunc (GETSPI?)>"),
    _S16( "<SearchFunc (SRCH?, STSRC?)>"),
    _S16( "<InviteFunc (INVIT?, CAINV?)>"),
    _S16( "<ContListFunc (GCLI?, CCLI?, DCLI?, MCLS?)>"),
    _S16( "<PresenceAuthFunc (GETWL?, REACT?, CAAUT?, GETAUT?)>"),
    _S16( "<PresenceDeliverFunc (GETPR?, UPDPR?)>"),
    _S16( "<AttListFunc (CALI?, DALI?, GALS?)>"),
    _S16( "<IMSendFunc (MDELIV?, FWMSG?)>"),
    _S16( "<IMReceiveFunc (SETD?, GETLM?, GETM?, REJCM?, NOTIF?, NEWM?)>"),
    _S16( "<IMAuthFunc (GLBLU?, BLENT?)>"),
    _S16( "<GroupMgmtFunc (CREAG?, DELGR?, GETGP?, SETGP?)>"),
    _S16( "<GroupUseFunc (SUBGCN?, GRCHN?)>"),
    _S16( "<GroupAuthFunc (GETGM?, ADDGM?, RMVGM?, MBRAC?, REJEC?)>"),
    _S16( "<GETSPI EMPTY>"),
    _S16( "<SRCH EMPTY>"),
    _S16( "<STSRC EMPTY>"),
    _S16( "<INVIT EMPTY>"),
    _S16( "<CAINV EMPTY>"),
    _S16( "<GCLI EMPTY>"),
    _S16( "<CCLI EMPTY>"),
    _S16( "<DCLI EMPTY>"),
    _S16( "<MCLS EMPTY>"),
    _S16( "<GETWL EMPTY>"),
    _S16( "<REACT EMPTY>"),
    _S16( "<CAAUT EMPTY>"),
    _S16( "<GETAUT EMPTY>"),
    _S16( "<GETPR EMPTY>"),
    _S16( "<UPDPR EMPTY>"),
    _S16( "<CALI EMPTY>"),
    _S16( "<DALI EMPTY>"),
    _S16( "<GALS EMPTY>"),
    _S16( "<MDELIV EMPTY>"),
    _S16( "<FWMSG EMPTY>"),
    _S16( "<SETD EMPTY>"),
    _S16( "<GETLM EMPTY>"),
    _S16( "<GETM EMPTY>"),
    _S16( "<REJCM EMPTY>"),
    _S16( "<NOTIF EMPTY>"),
    _S16( "<NEWM EMPTY>"),
    _S16( "<GLBLU EMPTY>"),
    _S16( "<BLENT EMPTY>"),
    _S16( "<CREAG EMPTY>"),
    _S16( "<DELGR EMPTY>"),
    _S16( "<GETGP EMPTY>"),
    _S16( "<SETGP EMPTY>"),
    _S16( "<SUBGCN EMPTY>"),
    _S16( "<GRCHN EMPTY>"),
    _S16( "<GETGM EMPTY>"),
    _S16( "<ADDGM EMPTY>"),
    _S16( "<RMVGM EMPTY>"),
    _S16( "<MBRAC EMPTY>"),
    _S16( "<REJEC EMPTY>"),
    _S16( "<EndOfTable (#PCDATA)>" )
    };

static const TText16* const KCspPresenceDtd12[] = 
    {
    _S16( "<PresenceSubList (OnlineStatus?,Registration?, ClientInfo?, TimeZone?, GeoLocation?,Address?,FreeTextLocation?,PLMN?,CommCap?,UserAvailability?, PreferredContacts?,PreferredLanguage?,StatusText?, StatusMood?, Alias?, StatusContent?, ContactInfo?, InfoLink?)>"),
    _S16( "<Qualifier (#PCDATA)>"),
    _S16( "<PresenceValue (#PCDATA)>"),
    _S16( "<OnlineStatus (Qualifier?, PresenceValue?)>"),
    _S16( "<Registration (Qualifier?, PresenceValue?)>"),
    _S16( "<FreeTextLocation (Qualifier?, PresenceValue?)>"),
    _S16( "<PLMN (Qualifier?, PresenceValue?)>"),
    _S16( "<UserAvailability (Qualifier?, PresenceValue?)>"),
    _S16( "<PreferredLanguage (Qualifier?, PresenceValue?)>"),
    _S16( "<StatusText (Qualifier?, PresenceValue?)>"),
    _S16( "<StatusMood (Qualifier?, PresenceValue?)>"),
    _S16( "<Alias (Qualifier?, PresenceValue?)>"),
    _S16( "<TimeZone (Qualifier?, Zone?)>"),
    _S16( "<ClientInfo (Qualifier?, ClientType?, DevManufacturer?, ClientProducer?, Model?, ClientVersion?, Language?)>"),
    _S16( "<ClientType (#PCDATA)>"),
    _S16( "<DevManufacturer (#PCDATA)>"),
    _S16( "<ClientProducer (#PCDATA)>"),
    _S16( "<Model (#PCDATA)>"),
    _S16( "<ClientVersion (#PCDATA)>"),
    _S16( "<Language (#PCDATA)>"),
    _S16( "<Zone (#PCDATA)>"),
    _S16( "<GeoLocation (Qualifier?, Longitude?, Latitude?, Altitude?, Accuracy?)>"),
    _S16( "<Longitude (#PCDATA)>"),
    _S16( "<Latitude (#PCDATA)>"),
    _S16( "<Altitude (#PCDATA)>"),
    _S16( "<Accuracy (#PCDATA)>"),
    _S16( "<Address (Qualifier?, Country?, City?, Street?, Crossing1?, Crossing2?, Building?, NamedArea?, Accuracy?)>"),
    _S16( "<Country (#PCDATA)>"),
    _S16( "<City (#PCDATA)>"),
    _S16( "<Street (#PCDATA)>"),
    _S16( "<Crossing1 (#PCDATA)>"),
    _S16( "<Crossing2 (#PCDATA)>"),
    _S16( "<Building (#PCDATA)>"),
    _S16( "<NamedArea (#PCDATA)>"),
    _S16( "<CommCap (Qualifier?, CommC*)>"),
    _S16( "<CommC (Cap, Status, Contact?, Note?)>"),
    _S16( "<Cap (#PCDATA)>"),
    _S16( "<Status (#PCDATA)>"),
    _S16( "<Contact (#PCDATA)>"),
    _S16( "<Note (#PCDATA)>"),
    _S16( "<PreferredContacts (Qualifier?, AddrPref*)>"),
    _S16( "<AddrPref (PrefC, Caddr, Cstatus, Cname?,Cpriority?)>"),
    _S16( "<PrefC (#PCDATA)>"),
    _S16( "<Caddr (#PCDATA)>"),
    _S16( "<Cstatus (#PCDATA)>"),
    _S16( "<Cname (#PCDATA)>"),
    _S16( "<Cpriority (#PCDATA)>"),
    _S16( "<StatusContent (Qualifier?, DirectContent?, ReferredContent?, ContentType?)>"),
    _S16( "<DirectContent (#PCDATA)>"),
    _S16( "<ReferredContent (#PCDATA)>"),
    _S16( "<ContactInfo (Qualifier?, ContainedvCard?, ReferredvCard?)>"),
    _S16( "<ContainedvCard (#PCDATA)>"),
    _S16( "<ReferredvCard (#PCDATA)>"),
    _S16( "<InfoLink (Qualifier?, Inf_link*)>"),
    _S16( "<Inf_link (Link, Text?, ContentType?)>"),
    _S16( "<Link (#PCDATA)>"),
    _S16( "<Text (#PCDATA)>"),
    _S16( "<ContentType (#PCDATA)>"),
    _S16( "<EndOfTable (#PCDATA)>" )
    };
