/*
* Copyright (c) 2002 Nokia Corporation and/or its subsidiary(-ies). 
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:  Intended to be implemented by the observer
*
*/



#ifndef __MPENGGLOBALEVENTOBSERVER_H__
#define __MPENGGLOBALEVENTOBSERVER_H__

//  INCLUDES

#include	<e32def.h>

// CLASS DECLARATION
class CPEngSessionSlotId;
class CPEngSessionSlotEvent;
class CPEngSessionSlotState;

/**
 *	Global event listener of the storage Server
 *	This class is meant to be implemented by the listener
 *	of the global events
 *
 *  @lib PEngStoreMan2.dll
 *  @since 3.0
 */
class MPEngGlobalEventObserver
    {
    public:

        /**
         *	Handle new Global event of the presence server
         *	Event can be one the basic three kinds
         *	1.	Session Slot Created, also generated when new application
         *		registers to the Session Slot
         *	2.	Session slot deleted,also generated when any application
         *		unregisters from the Session Slot
         *	3.	Session Slot global event generated by the Presence Server
         *
         *	@since 3.0
         *	@param aSessionEvent new global event
         */
        virtual void HandleNewSessionSlotEventL(
            const CPEngSessionSlotEvent& aSessionEvent ) = 0;

        /**
         *  Handle observer error
         *  Error from the Handling of the New Session slot event,
         *	or errors from the notify engine are reported through
         *	this function
         *
         *  @since 3.0
         *  @param aError code of the error
         */
        virtual void HandleObserverError( TInt aError ) = 0;
    };

#endif      // __MPENGGLOBALEVENTOBSERVER_H__

// End of File