/*
 * Decompiled with CFR 0.152.
 */
package JsrTestRunner;

import j2meunit.framework.AssertionFailedError;
import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestListener;
import j2meunit.framework.TestResult;
import j2meunit.framework.TestSuite;
import j2meunit.midletui.TestRunner;
import j2meunit.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class JsrTestRunner
extends TestRunner {
    protected static final String RESULTS_DIR = "file:///C:/data/images/JsrTestResults/";
    protected String iResultFilename = null;
    protected OutputStream out;
    protected PrintStream stream;
    protected FileConnection filecon;
    protected Canvas kanvas;
    protected boolean iFirstTime = true;
    protected boolean errorOrFailure = false;
    protected int iCount;

    public JsrTestRunner() {
        try {
            System.out.println(RESULTS_DIR);
            FileConnection jsrTest_dir = (FileConnection)Connector.open((String)RESULTS_DIR);
            if (!jsrTest_dir.exists()) {
                jsrTest_dir.mkdir();
            }
            this.iResultFilename = this.getResultFilename();
            System.out.println("File : " + this.iResultFilename);
            this.filecon = (FileConnection)Connector.open((String)this.iResultFilename);
            if (!this.filecon.exists()) {
                this.filecon.create();
            }
            this.out = this.filecon.openOutputStream();
        }
        catch (Exception e) {
            System.out.println("Error: Unable to open file");
            e.printStackTrace();
            System.out.println("Using standard output");
            this.out = System.out;
        }
        this.stream = new PrintStream(this.out);
        this.setWriter(this.stream);
        this.setOutputMode(true, true);
        this.kanvas = new Canvas(){

            protected void paint(Graphics aGraphics) {
            }
        };
        this.kanvas.setFullScreenMode(true);
    }

    public void addToResultsList(String sText) {
        if (sText.charAt(0) != '<') {
            sText = "<comment><text><![CDATA[" + sText + "]]></text></comment>";
        }
        if (sText.startsWith("<debug>")) {
            sText = "<debug><![CDATA[" + sText.substring(7, sText.length() - 8) + "]]></debug>";
        }
        if (this.bScreenOutput) {
            this.getResultsList().append(sText, null);
        }
        if (this.bTextOutput) {
            this.aWriter.println(sText);
        }
        this.aWriter.flush();
    }

    public synchronized void startTest(Test test) {
        this.addToResultsList("<test>");
        this.addToResultsList("<id>" + test.toString() + "</id>");
        this.errorOrFailure = false;
    }

    public void endTest(Test test) {
        if (this.errorOrFailure) {
            this.addToResultsList("<result>failed</result>");
        } else {
            this.addToResultsList("<result>ok</result>");
        }
        this.addToResultsList("</test>");
        if (this.aProgressBar != null) {
            this.aProgressBar.setValue(this.aProgressBar.getValue() + 1);
            this.aFailureInfo.setText(Integer.toString(this.aResult.failureCount()));
            this.aErrorInfo.setText(Integer.toString(this.aResult.errorCount()));
        }
    }

    public synchronized void addError(Test test, Throwable t) {
        this.addToResultsList("<error><![CDATA[" + t.toString() + "]]></error>");
        this.errorOrFailure = true;
    }

    public synchronized void addFailure(Test test, AssertionFailedError e) {
        this.addToResultsList("<failure><![CDATA[" + e.toString() + "]]></failure>");
        this.errorOrFailure = true;
    }

    public synchronized void print(TestResult result) {
        this.addToResultsList("<numberoftests>" + String.valueOf(result.runCount()) + "</numberoftests>");
        int passRate = (result.runCount() * 100 - result.failureCount() * 100 - result.errorCount() * 100) / result.runCount();
        this.addToResultsList("<passrate>" + String.valueOf(passRate) + "</passrate>");
        this.addToResultsList("</tests>");
    }

    protected void startApp() throws MIDletStateChangeException {
        try {
            String testClassAttribute = "TestClassName";
            String testClassName = "";
            String[] testClassNames = new String[1000];
            int index = 0;
            for (int i = 1; i <= 1000; ++i) {
                testClassName = this.getAppProperty(testClassAttribute);
                if (testClassName != null && testClassName.length() > 0) {
                    testClassNames[index++] = testClassName;
                    System.out.println("Added test class: " + testClassAttribute + "=" + testClassName);
                }
                testClassAttribute = "TestClassName" + new Integer(i).toString();
            }
            this.start(testClassNames);
        }
        catch (Exception e) {
            System.out.println("Exception while setting up tests: " + e);
            e.printStackTrace();
        }
        if (this.stream.checkError()) {
            System.out.println("error writing log");
        }
    }

    protected void start(String[] rTestCaseClasses) {
        this.addToResultsList("<?xml version=\"1.0\"?>");
        this.addToResultsList("<tests>");
        final Test aTestSuite = this.createTestSuite(rTestCaseClasses);
        this.parseOptions();
        if (this.bScreenOutput) {
            Display rDisplay = Display.getDisplay((MIDlet)this);
            Form aForm = new Form("TestRunner");
            this.iCount = aTestSuite.countTestSteps();
            this.aProgressBar = new Gauge(null, false, this.iCount, 0);
            this.aFailureInfo = new StringItem("Failures:", "0");
            this.aErrorInfo = new StringItem("Errors:", "0");
            aForm.append("Testing...");
            aForm.append((Item)this.aProgressBar);
            aForm.append((Item)this.aFailureInfo);
            aForm.append((Item)this.aErrorInfo);
            rDisplay.setCurrent((Displayable)aForm);
        }
        new Thread(){

            public void run() {
                try {
                    JsrTestRunner.this.doRun(aTestSuite);
                    JsrTestRunner.this.notifyDestroyed();
                }
                catch (Exception e) {
                    System.out.println("Exception while running test: " + e);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected void doRun(Test suite) {
        this.aResult = new TestResult();
        this.aResult.addListener((TestListener)this);
        long startTime = System.currentTimeMillis();
        suite.run(this.aResult);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        this.addToResultsList("<runtime>" + StringUtil.elapsedTimeAsString((long)runTime) + "</runtime>");
        this.print(this.aResult);
    }

    protected Test createTestSuite(String[] rTestCaseClasses) {
        if (rTestCaseClasses.length < 1) {
            System.out.println("Usage: TestRunner testCaseName1 [... testCaseNameN]");
            System.exit(-1);
        }
        TestSuite aSuite = new TestSuite();
        for (int i = 0; i < rTestCaseClasses.length; ++i) {
            try {
                String sClass = rTestCaseClasses[i];
                TestCase aCase = (TestCase)Class.forName(sClass).newInstance();
                aSuite.addTest(aCase.suite());
                continue;
            }
            catch (NullPointerException npe) {
                continue;
            }
            catch (Exception e) {
                System.out.println("Access to TestCase " + rTestCaseClasses[i] + " failed: " + e.getMessage() + " - " + e.getClass().getName());
            }
        }
        return aSuite;
    }

    protected void parseOptions() {
        String availableResolutions;
        String platform;
        String testRunName;
        String moduleName;
        String options = this.getAppProperty("JsrTestRunner-Options");
        if (options != null && options.length() > 0 && options.indexOf("disableUI") > -1) {
            this.bScreenOutput = false;
            System.out.println("SpedeRunner: UI disabled");
        }
        if ((moduleName = this.getAppProperty("ModuleName")) != null && moduleName.length() > 0) {
            this.addToResultsList("<modulename>" + moduleName + "</modulename>");
        }
        if ((testRunName = this.getAppProperty("TestRunName")) != null && testRunName.length() > 0) {
            this.addToResultsList("<testrunname>" + testRunName + "</testrunname>");
        }
        if ((platform = System.getProperty("microedition.platform")) != null && platform.length() > 0) {
            this.addToResultsList("<platform>" + platform + "</platform>");
        }
        if ((availableResolutions = this.getAppProperty("AvailableResolutions")) != null && availableResolutions.length() > 0) {
            this.addToResultsList("<AvailableResolutions>" + availableResolutions + "</AvailableResolutions>");
        }
    }

    public String getProperty(String property) {
        return this.getAppProperty(property);
    }

    protected String getResultFilename() throws IOException {
        String dest_Test_Dir;
        FileConnection test_dir;
        String moduleName = this.getAppProperty("ModuleName");
        if (moduleName == null || moduleName.length() < 1) {
            moduleName = "UnKnown Module";
        }
        if ((test_dir = (FileConnection)Connector.open((String)(dest_Test_Dir = RESULTS_DIR + moduleName + "/"))).exists()) {
            Calendar kalendar = Calendar.getInstance();
            String oldDirName = "old_" + moduleName + "_testresults_" + kalendar.getTime();
            oldDirName = oldDirName.replace(':', ' ');
            test_dir.rename(oldDirName);
        }
        ((FileConnection)Connector.open((String)dest_Test_Dir)).mkdir();
        return dest_Test_Dir + moduleName + ".xml";
    }
}

