/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.tools.security.midp;

import com.nokia.mj.impl.security.midp.authorization.SecurityPolicy;
import com.nokia.mj.impl.security.midp.authorization.SecurityPolicyPermission;
import com.nokia.mj.impl.security.midp.authorization.SecurityPolicyPermissionSettings;
import com.nokia.mj.impl.security.midp.common.PermissionMappingTable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Vector;

public final class PolicyEditor {
    private int offset = 0;
    private byte[] policy;
    private SecurityPolicy securityPolicy;
    private static String destPath;
    private static final String POLICY_FILE_EXTENSION = ".txt";
    private Hashtable allSettings = new Hashtable();

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage: SecurityPolicyEditor <sourcePath> <destPath>\n       where <sourcePath> = Path to the directory from where policies in the external format will be read\n             <destPath> = Path to the directory where the policies in the internal format will be stored");
            System.exit(1);
        }
        destPath = stringArray[1];
        File[] fileArray = new File(stringArray[0]).listFiles();
        if (fileArray == null || fileArray.length == 0) {
            System.out.println("No files under " + stringArray[0] + ". Security system can not operate without security policy files");
            System.exit(1);
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile() || !fileArray[i].getName().toLowerCase().endsWith(POLICY_FILE_EXTENSION)) continue;
            PolicyEditor policyEditor = new PolicyEditor();
            policyEditor.edit(fileArray[i].getAbsolutePath());
        }
    }

    private void edit(String string) {
        try {
            this.policy = this.read(string);
            this.parse();
            this.serialize(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read(String string) throws IOException {
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[2048];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }

    private void parse() {
        SecurityPolicyPermission securityPolicyPermission;
        String string = null;
        this.find("domain", true);
        if (this.offset >= this.policy.length) {
            throw new IllegalArgumentException("Invalid security policy - missing domain information");
        }
        string = this.extractToken(';');
        Vector<SecurityPolicyPermission> vector = new Vector<SecurityPolicyPermission>();
        Vector<SecurityPolicyPermission> vector2 = new Vector<SecurityPolicyPermission>();
        this.find("grant");
        while (this.offset < this.policy.length) {
            Object object;
            int n;
            Object object2;
            String string2;
            SecurityPolicyPermissionSettings securityPolicyPermissionSettings = null;
            securityPolicyPermission = null;
            int n2 = this.getType(this.extractToken());
            String string3 = null;
            if (n2 == 1) {
                string3 = this.extractToken('\"', '\"');
                this.check(string3, "User grant group without name");
                if (string3.startsWith("\"")) {
                    string3 = string3.substring(1);
                }
                if (string3.endsWith("\"")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string2 = this.extractToken('{');
                this.check(string2, "User grant group without interaction modes");
                object2 = this.split(string2, ",");
                if (object2 == null || ((String[])object2).length == 0) {
                    throw new IllegalArgumentException("Missing interaction modes for an user grant group");
                }
                n = this.getInteractionMode(object2[0]);
                object = this.getInteractionModes((String[])object2);
                securityPolicyPermissionSettings = new SecurityPolicyPermissionSettings(string3, n, (int[])object);
                this.allSettings.put(string3, securityPolicyPermissionSettings);
            } else if (n2 == 3 && (string3 = this.extractToken('\"', '\"')) != null && string3.length() > 0 && string3.indexOf("{") == -1) {
                n2 = 4;
                securityPolicyPermissionSettings = (SecurityPolicyPermissionSettings)this.allSettings.get(string3);
                if (securityPolicyPermissionSettings == null) {
                    string2 = this.extractToken('{');
                    object2 = this.split(string2, ",");
                    if (object2 != null && ((String[])object2).length > 0) {
                        n = this.getInteractionMode((String)object2[0]);
                        object = this.getInteractionModes((String[])object2);
                        securityPolicyPermission = new SecurityPolicyPermissionSettings(string3, n, (int[])object);
                    } else {
                        securityPolicyPermission = new SecurityPolicyPermissionSettings(string3);
                    }
                }
            }
            this.find("permission");
            while (this.offset < this.policy.length && this.policy[this.offset] != 125) {
                string2 = this.extractToken(';');
                object2 = null;
                String string4 = null;
                if (this.policy[this.offset] != 59) {
                    object2 = this.extractToken(';');
                    if (object2 != null && ((String)object2).length() > 2) {
                        if (((String)object2).charAt(0) == '\"') {
                            object2 = ((String)object2).substring(1);
                        }
                        if (((String)object2).charAt(((String)object2).length() - 1) == '\"') {
                            object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                        }
                    }
                    if (this.policy[this.offset] != 59 && (string4 = this.extractToken(';')) != null && string4.length() > 2) {
                        if (string4.charAt(0) == '\"') {
                            string4 = string4.substring(1);
                        }
                        if (string4.charAt(string4.length() - 1) == '\"') {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                    }
                }
                if ((object = PermissionMappingTable.get((String)string2)) != null) {
                    string2 = object.getName();
                }
                String[] stringArray = this.split(string4, ",");
                if (securityPolicyPermission != null && securityPolicyPermission.getCurrentInteractionMode() == -1) {
                    securityPolicyPermission = null;
                }
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (securityPolicyPermission == null) {
                            vector.add(this.getSecurityPolicyPermission(string2, (String)object2, stringArray[i], n2, securityPolicyPermissionSettings));
                            continue;
                        }
                        vector2.add(this.getSecurityPolicyPermission(string2, (String)object2, stringArray[i], n2, (SecurityPolicyPermissionSettings)securityPolicyPermission));
                    }
                } else if (securityPolicyPermission == null) {
                    vector.add(this.getSecurityPolicyPermission(string2, (String)object2, string4, n2, securityPolicyPermissionSettings));
                } else {
                    vector2.add(this.getSecurityPolicyPermission(string2, (String)object2, string4, n2, (SecurityPolicyPermissionSettings)securityPolicyPermission));
                }
                this.find("permission");
            }
            this.find("grant", true);
        }
        if (vector.size() == 0 && vector2.size() == 0) {
            throw new IllegalArgumentException("Invalid security policy - missing/invalid permissions information");
        }
        for (int i = 0; i < vector2.size(); ++i) {
            securityPolicyPermission = (SecurityPolicyPermission)vector2.elementAt(i);
            SecurityPolicyPermissionSettings securityPolicyPermissionSettings = (SecurityPolicyPermissionSettings)this.allSettings.get(securityPolicyPermission.getUserSecuritySettings().getName());
            if (securityPolicyPermissionSettings != null) {
                vector.add(this.getSecurityPolicyPermission(securityPolicyPermission.getName(), securityPolicyPermission.getTarget(), securityPolicyPermission.getActionList(), securityPolicyPermission.getType(), securityPolicyPermissionSettings));
                continue;
            }
            vector.add(securityPolicyPermission);
        }
        Object[] objectArray = new SecurityPolicyPermission[vector.size()];
        vector.copyInto(objectArray);
        this.securityPolicy = new SecurityPolicy(string, (SecurityPolicyPermission[])objectArray);
    }

    private void serialize(String string) throws IOException {
        int n = (string = new File(string).getName()).indexOf(".");
        if (n == -1) {
            n = string.length();
        }
        string = string.substring(0, n);
        FileOutputStream fileOutputStream = new FileOutputStream(destPath + File.separator + string + ".ser");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this.securityPolicy);
        objectOutputStream.close();
    }

    private void find(String string, boolean bl) {
        byte[] byArray = string.getBytes();
        while (this.offset < this.policy.length && (bl || this.policy[this.offset] != 125)) {
            if (this.policy[this.offset] == byArray[0]) {
                int n;
                ++this.offset;
                for (n = 1; n < byArray.length && this.policy[this.offset] == byArray[n]; ++n) {
                    ++this.offset;
                }
                if (n == byArray.length) break;
            }
            ++this.offset;
        }
    }

    private String extractToken(char c, char c2, char c3) {
        String string = "";
        while (c != ' ' && this.offset < this.policy.length && this.policy[this.offset] == 32) {
            ++this.offset;
        }
        while (this.offset < this.policy.length && this.policy[this.offset] == c) {
            ++this.offset;
        }
        while (this.offset < this.policy.length && this.policy[this.offset] != c2 && this.policy[this.offset] != 10 && this.policy[this.offset] != 13 && (c3 == '\uffff' || this.policy[this.offset] != c3)) {
            string = string + (char)this.policy[this.offset];
            ++this.offset;
        }
        if (string.length() == 0) {
            return null;
        }
        if (c2 != ' ') {
            ++this.offset;
        }
        return string;
    }

    private int getInteractionMode(String string) {
        if (string.equalsIgnoreCase("oneshot")) {
            return 1;
        }
        if (string.equalsIgnoreCase("session")) {
            return 2;
        }
        if (string.equalsIgnoreCase("blanket")) {
            return 3;
        }
        if (string.equalsIgnoreCase("no")) {
            return 4;
        }
        throw new IllegalArgumentException("Invalid interaction mode " + string);
    }

    private int[] getInteractionModes(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.getInteractionMode(stringArray[i]);
        }
        return nArray;
    }

    private int getType(String string) {
        if (string.equalsIgnoreCase("user")) {
            return 1;
        }
        if (string.equalsIgnoreCase("allowed")) {
            return 2;
        }
        if (string.equalsIgnoreCase("assigned")) {
            return 3;
        }
        throw new IllegalArgumentException("Invalid grant group type " + string);
    }

    private void find(String string) {
        this.find(string, false);
    }

    private String extractToken() {
        return this.extractToken(' ', ' ', '\uffff');
    }

    private String extractToken(char c) {
        return this.extractToken(' ', ' ', c);
    }

    private String extractToken(char c, char c2) {
        return this.extractToken(c, c2, '\uffff');
    }

    private void check(String string, String string2) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(string2);
        }
    }

    private String[] split(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return new String[]{string};
        }
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(string2);
        while (n != -1) {
            vector.addElement(string.substring(0, n));
            string = string.substring(n + string2.length());
            n = string.indexOf(string2);
        }
        vector.addElement(string);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private SecurityPolicyPermission getSecurityPolicyPermission(String string, String string2, String string3, int n, SecurityPolicyPermissionSettings securityPolicyPermissionSettings) {
        if (securityPolicyPermissionSettings == null && n == 4) {
            return new SecurityPolicyPermission(string, string2, string3, 3);
        }
        return new SecurityPolicyPermission(string, string2, string3, n, securityPolicyPermissionSettings);
    }
}

