/*
 * Decompiled with CFR 0.152.
 */
package bcexchanger.ui;

import bcexchanger.BCExchangerMIDlet;
import bcexchanger.comm.ExchangerCommImpl;
import bcexchanger.comm.ServiceDiscoveryState;
import bcexchanger.ui.AddressBookScreen;
import bcexchanger.ui.AlertMessage;
import bcexchanger.ui.ProgressScreen;
import bcexchanger.ui.Screen;
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;

public class MainScreen
extends Screen {
    private Command changeBCCommand;
    private Command exitCommand;
    private Command sendBCCommand;
    private TextBox textBox;
    private int typeOfOperation = ServiceDiscoveryState.PUT;

    public MainScreen(BCExchangerMIDlet _midlet) {
        super(_midlet);
        this.midlet.initComm();
        String text = "Business Card Exchanger allows you to define your own business card and exhange it with business cards of other users in vicinity running the same application. The exchange is done over Bluetooth and free of charge.\n\nUse 'Change own card' to choose own card from the address book.\nUse 'Exchange card' to initate the search and exchange of the cards.\n\nThe application is always waiting for connections from remote devices.";
        this.textBox = new TextBox("Business Card Exchanger", text, 999, 131072);
        this.changeBCCommand = new Command("Change own card", 8, 1);
        this.exitCommand = new Command("Exit", 7, 1);
        this.sendBCCommand = new Command("Exchange cards", 8, 1);
        this.textBox.addCommand(this.changeBCCommand);
        this.textBox.addCommand(this.exitCommand);
        this.textBox.addCommand(this.sendBCCommand);
        this.textBox.setCommandListener((CommandListener)this);
        this.displayable = this.textBox;
    }

    public void commandAction(Command command, Displayable _displayable) {
        if (_displayable != this.textBox) {
            throw new RuntimeException("Internal error #16");
        }
        if (command == this.sendBCCommand) {
            try {
                this.setTypeOfOperation(ServiceDiscoveryState.PUT);
                ((ExchangerCommImpl)this.midlet.getExchanger()).startSending(ServiceDiscoveryState.PUT);
                String text = "Searching for devices...";
                this.midlet.changeScreen(new ProgressScreen(this.midlet, text));
            }
            catch (IOException e0) {
                this.midlet.changeScreen(new AlertMessage(this.midlet, "Cannot start inquiry " + e0, null));
            }
            catch (Exception exception) {}
        } else if (command == this.changeBCCommand) {
            this.midlet.changeScreen(new AddressBookScreen(this.midlet));
        } else if (command == this.exitCommand) {
            this.midlet.quit();
        } else {
            throw new RuntimeException("Internal error #18");
        }
    }

    public int getTypeOfOperation() {
        return this.typeOfOperation;
    }

    public void setTypeOfOperation(int typeOfOperation) {
        this.typeOfOperation = typeOfOperation;
    }
}

