/*
 * Decompiled with CFR 0.152.
 */
package bcexchanger.comm;

import bcexchanger.comm.ExchangerState;
import bcexchanger.comm.ExchangerStateParent;
import bcexchanger.comm.IdleState;
import bcexchanger.comm.ReceiveState;
import bcexchanger.comm.SendState;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.obex.Operation;

public class ServiceDiscoveryState
extends ExchangerState
implements DiscoveryListener,
Runnable {
    private Thread serviceDiscoveryThread;
    private Vector services = new Vector();
    private DiscoveryAgent agent;
    private int serviceDiscoveryID;
    private Vector devices;
    private boolean canceled = false;
    public static int GET = 0;
    public static int PUT = 1;

    public ServiceDiscoveryState(ExchangerStateParent _parent, Vector _devices, int oper) throws IOException {
        super(_parent);
        this.devices = _devices;
        LocalDevice local = LocalDevice.getLocalDevice();
        this.agent = local.getDiscoveryAgent();
        this.serviceDiscoveryThread = new Thread(this);
        this.serviceDiscoveryThread.start();
    }

    public void startSending(int op) throws Exception {
        throw new IOException("Service discovery is in progress. Service discovery has to be canceled before starting new sending process");
    }

    public void cancelSending() {
        this.canceled = true;
        this.agent.cancelServiceSearch(this.serviceDiscoveryID);
    }

    public void deviceDiscovered(RemoteDevice arg0, DeviceClass arg1) {
        throw new RuntimeException("Internal error #8: ServiceDiscoveryState.deviceDiscovered() should not be called");
    }

    public void inquiryCompleted(int arg0) {
        throw new RuntimeException("Internal error #9: ServiceDiscoveryState.inquiryCompleted() should not be called");
    }

    public void servicesDiscovered(int id, ServiceRecord[] _services) {
        int i = 0;
        while (i < _services.length) {
            this.services.addElement(_services[i]);
            ++i;
        }
    }

    public synchronized void serviceSearchCompleted(int arg0, int arg1) {
        this.notify();
    }

    public synchronized void run() {
        Enumeration e = this.devices.elements();
        UUID[] uuids = new UUID[]{new UUID(this.parent.getUUID(), false)};
        while (e.hasMoreElements() && !this.canceled) {
            RemoteDevice device = (RemoteDevice)e.nextElement();
            try {
                this.serviceDiscoveryID = this.agent.searchServices(null, uuids, device, (DiscoveryListener)this);
            }
            catch (Exception e0) {
                this.parent.getListener().onServiceDiscoveryComplete(2);
                this.parent.setState(new IdleState(this.parent));
                return;
            }
            try {
                this.wait();
            }
            catch (Exception e0) {
                // empty catch block
            }
        }
        if (this.canceled) {
            try {
                this.parent.getListener().onServiceDiscoveryComplete(1);
                this.parent.setState(new IdleState(this.parent));
            }
            catch (Exception e1) {
                throw new RuntimeException("Internal error #10: ServiceDicoveryState.run()");
            }
        }
        if (this.services.isEmpty()) {
            try {
                this.parent.getListener().onServiceDiscoveryComplete(3);
                this.parent.setState(new IdleState(this.parent));
            }
            catch (Exception e1) {}
        } else if (this.services.size() == 1) {
            try {
                ServiceRecord serviceRecord = (ServiceRecord)this.services.firstElement();
                this.parent.getListener().onServiceDiscoveryComplete(0);
                SendState state = new SendState(this.parent, serviceRecord.getConnectionURL(0, false));
                this.parent.setState(state);
                state.doSend();
                state = null;
                Thread.sleep(new Long(5000L));
                ReceiveState rstate = new ReceiveState(this.parent, serviceRecord.getConnectionURL(0, false));
                this.parent.setState(rstate);
                rstate.doGet();
                rstate = null;
                Thread.sleep(new Long(5000L));
            }
            catch (Exception serviceRecord) {}
        } else {
            try {
                Vector friendlyNames = this.createFriendlyNamesList(this.services);
                int index = this.parent.getListener().resolveMultipleServices(friendlyNames);
                if (!this.canceled) {
                    ServiceRecord serviceRecord = (ServiceRecord)this.services.elementAt(index);
                    this.parent.getListener().onServiceDiscoveryComplete(0);
                    SendState state = new SendState(this.parent, serviceRecord.getConnectionURL(0, false));
                    this.parent.setState(state);
                    state.doSend();
                    state = null;
                    Thread.sleep(new Long(5000L));
                    ReceiveState rstate = new ReceiveState(this.parent, serviceRecord.getConnectionURL(0, false));
                    this.parent.setState(rstate);
                    rstate.doGet();
                    rstate = null;
                    Thread.sleep(new Long(5000L));
                } else {
                    this.parent.getListener().onServiceDiscoveryComplete(1);
                    this.parent.setState(new IdleState(this.parent));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Vector createFriendlyNamesList(Vector _services) {
        Vector<String> friendlyNames = new Vector<String>();
        Enumeration e = _services.elements();
        while (e.hasMoreElements()) {
            ServiceRecord serviceRecord = (ServiceRecord)e.nextElement();
            RemoteDevice device = serviceRecord.getHostDevice();
            try {
                friendlyNames.addElement(device.getFriendlyName(false));
            }
            catch (IOException e1) {
                friendlyNames.addElement(device.getBluetoothAddress());
            }
        }
        return friendlyNames;
    }

    public int onGet(Operation op) {
        return 201;
    }

    public int onPut(Operation op) {
        return 201;
    }
}

