/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;

public class TestResult {
    protected Vector fFailures = new Vector();
    protected Vector fErrors = new Vector();
    protected Vector fListeners = new Vector();
    protected int fRunTests = 0;
    private boolean fStop = false;

    public synchronized void addError(Test test, Throwable throwable) {
        this.fErrors.addElement(new TestFailure(test, throwable));
        Enumeration enumeration = this.cloneListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((TestListener)enumeration.nextElement()).addError(test, throwable);
        }
    }

    public synchronized void addFailure(Test test, AssertionFailedError assertionFailedError) {
        this.fFailures.addElement(new TestFailure(test, assertionFailedError));
        Enumeration enumeration = this.cloneListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((TestListener)enumeration.nextElement()).addFailure(test, assertionFailedError);
        }
    }

    public synchronized void addListener(TestListener testListener) {
        this.fListeners.addElement(testListener);
    }

    public synchronized void removeListener(TestListener testListener) {
        this.fListeners.removeElement(testListener);
    }

    private synchronized Vector cloneListeners() {
        return (Vector)this.fListeners.clone();
    }

    public void endTest(Test test) {
        Enumeration enumeration = this.cloneListeners().elements();
        while (enumeration.hasMoreElements()) {
            ((TestListener)enumeration.nextElement()).endTest(test);
        }
    }

    public synchronized int errorCount() {
        return this.fErrors.size();
    }

    public synchronized Enumeration errors() {
        return this.fErrors.elements();
    }

    public synchronized int failureCount() {
        return this.fFailures.size();
    }

    public synchronized Enumeration failures() {
        return this.fFailures.elements();
    }

    protected void run(final TestCase testCase) {
        this.startTest(testCase);
        Protectable protectable = new Protectable(){

            public void protect() throws Throwable {
                testCase.runBare();
            }
        };
        this.runProtected(testCase, protectable);
        this.endTest(testCase);
    }

    public synchronized int runCount() {
        return this.fRunTests;
    }

    public void runProtected(Test test, Protectable protectable) {
        try {
            protectable.protect();
        }
        catch (AssertionFailedError assertionFailedError) {
            this.addFailure(test, assertionFailedError);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.addError(test, throwable);
        }
    }

    public synchronized boolean shouldStop() {
        return this.fStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTest(Test test) {
        int n = test.countTestCases();
        Object object = this;
        synchronized (object) {
            this.fRunTests += n;
        }
        object = this.cloneListeners().elements();
        while (object.hasMoreElements()) {
            ((TestListener)object.nextElement()).startTest(test);
        }
    }

    public synchronized void stop() {
        this.fStop = true;
    }

    public synchronized boolean wasSuccessful() {
        return this.failureCount() == 0 && this.errorCount() == 0;
    }
}

