/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.StandardTestSuiteLoader;
import junit.runner.TestSuiteLoader;
import junit.runner.Version;
import junit.textui.ResultPrinter;

public class TestRunner
extends BaseTestRunner {
    private ResultPrinter fPrinter;
    public static final int SUCCESS_EXIT = 0;
    public static final int FAILURE_EXIT = 1;
    public static final int EXCEPTION_EXIT = 2;

    public TestRunner() {
        this(System.out);
    }

    public TestRunner(PrintStream printStream) {
        this(new ResultPrinter(printStream));
    }

    public TestRunner(ResultPrinter resultPrinter) {
        this.fPrinter = resultPrinter;
    }

    public static void run(Class clazz) {
        TestRunner.run(new TestSuite(clazz));
    }

    public static TestResult run(Test test) {
        TestRunner testRunner = new TestRunner();
        return testRunner.doRun(test);
    }

    public static void runAndWait(Test test) {
        TestRunner testRunner = new TestRunner();
        testRunner.doRun(test, true);
    }

    public TestSuiteLoader getLoader() {
        return new StandardTestSuiteLoader();
    }

    public void testFailed(int n, Test test, Throwable throwable) {
    }

    public void testStarted(String string) {
    }

    public void testEnded(String string) {
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    public TestResult doRun(Test test) {
        return this.doRun(test, false);
    }

    public TestResult doRun(Test test, boolean bl) {
        TestResult testResult = this.createTestResult();
        testResult.addListener(this.fPrinter);
        long l = System.currentTimeMillis();
        test.run(testResult);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.fPrinter.print(testResult, l3);
        this.pause(bl);
        return testResult;
    }

    protected void pause(boolean bl) {
        if (!bl) {
            return;
        }
        this.fPrinter.printWaitPrompt();
        try {
            System.in.read();
        }
        catch (Exception exception) {}
    }

    public static void main(String[] stringArray) {
        TestRunner testRunner = new TestRunner();
        try {
            TestResult testResult = testRunner.start(stringArray);
            if (!testResult.wasSuccessful()) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(2);
        }
    }

    protected TestResult start(String[] stringArray) throws Exception {
        String string = "";
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-wait")) {
                bl = true;
            } else if (stringArray[n].equals("-c")) {
                string = this.extractClassName(stringArray[++n]);
            } else if (stringArray[n].equals("-v")) {
                System.err.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
            } else {
                string = stringArray[n];
            }
            ++n;
        }
        if (string.equals("")) {
            throw new Exception("Usage: TestRunner [-wait] testCaseName, where name is the name of the TestCase class");
        }
        try {
            Test test = this.getTest(string);
            return this.doRun(test, bl);
        }
        catch (Exception exception) {
            throw new Exception("Could not create and run test suite: " + exception);
        }
    }

    protected void runFailed(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public void setPrinter(ResultPrinter resultPrinter) {
        this.fPrinter = resultPrinter;
    }
}

