/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends InputStream {
    protected InputStream in;
    protected byte[] buf;
    protected int count;
    protected int pos;

    public BufferedInputStream(InputStream in) {
        this.in = in;
        this.buf = new byte[512];
    }

    public BufferedInputStream(InputStream in, int size) {
        this.in = in;
        if (size <= 0) {
            throw new IllegalArgumentException(Msg.getString("K0058"));
        }
        this.buf = new byte[size];
    }

    public synchronized int available() throws IOException {
        return this.count - this.pos + this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
        this.buf = null;
    }

    private int fillbuf() throws IOException {
        int result = this.in.read(this.buf);
        this.pos = 0;
        this.count = result == -1 ? 0 : result;
        return result;
    }

    public synchronized int read() throws IOException {
        if (this.buf != null) {
            if (this.pos >= this.count && this.fillbuf() == -1) {
                return -1;
            }
            if (this.count - this.pos > 0) {
                return this.buf[this.pos++] & 0xFF;
            }
            return -1;
        }
        throw new IOException(Msg.getString("K0059"));
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.buf != null && buffer != null) {
            if (offset >= 0 && offset <= buffer.length && length >= 0 && length <= buffer.length - offset) {
                int required;
                if (length == 0) {
                    return 0;
                }
                if (this.pos < this.count) {
                    int copylength = this.count - this.pos >= length ? length : this.count - this.pos;
                    System.arraycopy((Object)this.buf, this.pos, (Object)buffer, offset, copylength);
                    this.pos += copylength;
                    if (copylength == length || this.in.available() == 0) {
                        return copylength;
                    }
                    offset += copylength;
                    required = length - copylength;
                } else {
                    required = length;
                }
                while (true) {
                    int read;
                    if (required >= this.buf.length) {
                        read = this.in.read(buffer, offset, required);
                        if (read == -1) {
                            return required == length ? -1 : length - required;
                        }
                    } else {
                        if (this.fillbuf() == -1) {
                            return required == length ? -1 : length - required;
                        }
                        read = this.count - this.pos >= required ? required : this.count - this.pos;
                        System.arraycopy((Object)this.buf, this.pos, (Object)buffer, offset, read);
                        this.pos += read;
                    }
                    if ((required -= read) == 0) {
                        return length;
                    }
                    if (this.in.available() == 0) {
                        return length - required;
                    }
                    offset += read;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.buf == null) {
            throw new IOException(Msg.getString("K0059"));
        }
        throw new NullPointerException(Msg.getString("K0047"));
    }

    public synchronized long skip(long amount) throws IOException {
        if (amount < 1L) {
            return 0L;
        }
        if ((long)(this.count - this.pos) >= amount) {
            this.pos = (int)((long)this.pos + amount);
            return amount;
        }
        long read = this.count - this.pos;
        this.pos = this.count;
        return read + this.in.skip(amount - read);
    }
}

