/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.http;

import com.ibm.oti.connection.BufferedInputStream;
import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.DataConnection;
import com.ibm.oti.connection.http.Header;
import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.ContentConnection;
import javax.microedition.io.StreamConnection;

public class Connection
extends DataConnection
implements CreateConnection,
ContentConnection {
    static final String GET = "GET";
    static final String HEAD = "HEAD";
    static final String POST = "POST";
    static final int HTTP_OK = 200;
    static final int HTTP_NO_CONTENT = 204;
    static final int HTTP_MULT_CHOICE = 300;
    static final int HTTP_MOVED_PERM = 301;
    static final int HTTP_MOVED_TEMP = 302;
    static final int HTTP_SEE_OTHER = 303;
    static final int HTTP_NOT_MODIFIED = 304;
    static final int HTTP_USE_PROXY = 305;
    static final int HTTP_BAD_REQUEST = 400;
    private static boolean allowProxyParameter = false;
    private static final int UNOPENED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    int access;
    String host;
    String file;
    int httpVersion = 1;
    boolean sentRequest = false;
    boolean conClosed = false;
    String method = "GET";
    int responseCode = -1;
    String responseMessage;
    Header reqHeader = new Header(false);
    Header resHeader;
    boolean timeout;
    InputStream is;
    InputStream uis;
    OutputStream socketOut;
    HttpOutputStream os;
    String proxyName;
    int port;
    int proxyPort;
    boolean followRedirects = true;
    boolean sendChunked = false;
    String socketOptions = "";
    StreamConnection socket;
    boolean connected = false;
    private int inputStatus = 0;
    private int outputStatus = 0;

    public Connection() {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
    }

    public void close() throws IOException {
        this.conClosed = true;
        if (this.inputStatus != 1 && (this.os == null || this.os.closed)) {
            if (this.os != null) {
                this.os.close();
            }
            if (this.uis != null) {
                this.uis.close();
            }
            this.closeSocket();
        }
    }

    void closeConnection() throws IOException {
        this.conClosed = true;
        this.closeSocket();
    }

    void closeSocket() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        if (this.socketOut != null) {
            this.socketOut.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public long getDate() throws IOException {
        return this.getHeaderFieldDate("Date", 0L);
    }

    public long getExpiration() throws IOException {
        return this.getHeaderFieldDate("Expires", 0L);
    }

    public String getFile() {
        if (this.file == null) {
            return null;
        }
        int index = this.file.indexOf(63);
        if (index != -1) {
            return this.file.substring(0, index);
        }
        index = this.file.indexOf(35);
        if (index == -1) {
            return this.file;
        }
        return this.file.substring(0, index);
    }

    public String getHeaderField(int pos) throws IOException {
        if (this.conClosed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        this.doRequest();
        return this.resHeader.get(pos + 1);
    }

    public String getHeaderField(String key) throws IOException {
        if (this.conClosed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        this.doRequest();
        if (key == null) {
            return null;
        }
        return this.resHeader.get(key);
    }

    public long getHeaderFieldDate(String field, long defaultValue) throws IOException {
        String date = this.getHeaderField(field);
        if (date == null) {
            return defaultValue;
        }
        return Util.parseDate(date);
    }

    public int getHeaderFieldInt(String field, int defaultValue) throws IOException {
        try {
            return Integer.parseInt(this.getHeaderField(field));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public String getHeaderFieldKey(int pos) throws IOException {
        if (this.conClosed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        this.doRequest();
        return this.resHeader.getKey(pos + 1);
    }

    public String getHost() {
        return this.host;
    }

    public long getLastModified() throws IOException {
        return this.getHeaderFieldDate("Last-Modified", 0L);
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return "http";
    }

    public String getQuery() {
        if (this.file == null) {
            return null;
        }
        int index = this.file.indexOf(63);
        if (index == -1) {
            return null;
        }
        String query = this.file.substring(index + 1);
        if ((index = query.indexOf(35)) == -1) {
            return query;
        }
        return query.substring(0, index);
    }

    public String getRef() {
        if (this.file == null) {
            return null;
        }
        int index = this.file.indexOf(35);
        if (index == -1) {
            return null;
        }
        return this.file.substring(index + 1);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public String getRequestProperty(String field) {
        return this.reqHeader.get(field);
    }

    public int getResponseCode() throws IOException {
        int last;
        if (this.conClosed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        this.doRequest();
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        String response = this.resHeader.get(0);
        if (response == null || !response.startsWith("HTTP/")) {
            return -1;
        }
        response.trim();
        int mark = response.indexOf(" ") + 1;
        if (mark == 0) {
            return -1;
        }
        if (response.charAt(mark - 2) != '1') {
            this.httpVersion = 0;
        }
        if ((last = mark + 3) > response.length()) {
            last = response.length();
        }
        this.responseCode = Integer.parseInt(response.substring(mark, last));
        if (last + 1 <= response.length()) {
            this.responseMessage = response.substring(last + 1);
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        if (this.conClosed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.responseMessage != null) {
            return this.responseMessage;
        }
        this.getResponseCode();
        return this.responseMessage;
    }

    public String getURL() {
        StringBuffer url = new StringBuffer(this.getProtocol());
        url.append(':');
        if (this.host != null) {
            url.append("//");
            url.append(this.host);
        }
        if (this.port != this.getDefaultPort()) {
            url.append(':');
            url.append(this.port);
        }
        if (this.file != null) {
            url.append(this.file);
        }
        return url.toString();
    }

    public void setRequestMethod(String method) throws IOException {
        if (this.sentRequest) {
            throw new IOException(Msg.getString("K0037"));
        }
        if (this.os != null) {
            return;
        }
        if (!(method.equals(GET) || method.equals(HEAD) || method.equals(POST))) {
            throw new IOException(Msg.getString("K00ad"));
        }
        this.method = method;
    }

    public void setRequestProperty(String field, String newValue) throws IOException {
        if (this.sentRequest) {
            throw new IOException(Msg.getString("K0037"));
        }
        if (this.os != null) {
            return;
        }
        this.reqHeader.add(field, newValue);
    }

    public void setSocketParameters(String params) {
        if (!params.startsWith(";")) {
            throw new IllegalArgumentException();
        }
        this.socketOptions = params;
    }

    public void setConnectionParameters(String params) {
        String[][] equates = ConnectionUtil.getParameters(params);
        int[] result = new int[1];
        int i = 0;
        while (i < equates.length) {
            String value;
            String key = equates[i][0];
            equates[i][0] = equates[i][0].toLowerCase();
            if (equates[i][0].equals("proxy") && equates[i][1] != null) {
                this.setProxy(equates[i][1]);
            } else if (ConnectionUtil.intParam("httpversion", equates[i], 1, result)) {
                if (result[0] > 1) {
                    throw new IllegalArgumentException(Msg.getString("K009f", key, equates[i][1]));
                }
                this.httpVersion = result[0];
            } else if (equates[i][0].equals("followredirects") && equates[i][1] != null) {
                value = equates[i][1].toLowerCase();
                if (value.equals("false")) {
                    this.followRedirects = false;
                } else if (!value.equals("true")) {
                    throw new IllegalArgumentException(Msg.getString("K00b5", equates[i][1]));
                }
            } else if (equates[i][0].equals("chunked") && equates[i][1] != null) {
                value = equates[i][1].toLowerCase();
                if (value.equals("true")) {
                    this.sendChunked = true;
                } else if (!value.equals("false")) {
                    throw new IllegalArgumentException(Msg.getString("K00b5", equates[i][1]));
                }
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", key));
            }
            ++i;
        }
    }

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean throwTimeout) throws IOException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        if (allowProxyParameter) {
            String[][] equates = ConnectionUtil.NO_PARAMETERS;
            int index = spec.indexOf(59);
            if (index != -1) {
                equates = ConnectionUtil.getParameters(spec.substring(index + 1));
                StringBuffer url = new StringBuffer(spec.substring(0, index));
                int i = 0;
                while (i < equates.length) {
                    if (equates[i][0].equals("j9proxy")) {
                        this.setProxy(equates[i][1]);
                    } else {
                        url.append(';');
                        url.append(equates[i][0]);
                        if (equates[i][1] != null) {
                            url.append('=');
                            url.append(equates[i][1]);
                        }
                    }
                    ++i;
                }
                spec = url.toString();
            }
        }
        this.access = access;
        this.timeout = throwTimeout;
        this.parseURL(spec);
        if (this.host == null) {
            throw new IllegalArgumentException(Msg.getString("K01cd", this.host));
        }
        String proxyHost = System.getProperty("http.proxyHost");
        String portString = System.getProperty("http.proxyPort");
        if (proxyHost != null) {
            this.proxyName = proxyHost;
            this.proxyPort = portString != null ? Integer.parseInt(portString) : 80;
        }
        return this;
    }

    private void setProxy(String proxy) {
        int index = proxy.indexOf(58);
        if (index == -1) {
            this.proxyName = proxy;
            this.proxyPort = 80;
        } else {
            this.proxyName = proxy.substring(0, index);
            String port = proxy.substring(index + 1);
            try {
                this.proxyPort = Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Msg.getString("K00af", port));
            }
            if (this.proxyPort < 0 || this.proxyPort > 65535) {
                throw new IllegalArgumentException(Msg.getString("K00b0"));
            }
        }
    }

    protected int getDefaultPort() {
        return 80;
    }

    private void parseURL(String url) {
        String hostPart = null;
        if (!url.startsWith("//")) {
            if (url.startsWith("/")) {
                this.file = url;
            } else {
                int index = -1;
                if (this.file != null) {
                    index = this.file.lastIndexOf(47);
                }
                this.file = index == -1 ? "/" + url : String.valueOf(this.file.substring(0, index + 1)) + url;
            }
            return;
        }
        int index = (url = url.substring(2)).indexOf(47);
        if (index == -1) {
            hostPart = url;
        } else {
            hostPart = url.substring(0, index);
            this.file = url.substring(index);
        }
        index = hostPart.indexOf(58);
        if (index != -1) {
            this.host = hostPart.substring(0, index);
            String portString = hostPart.substring(index + 1);
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Msg.getString("K00b1"));
            }
            if (this.port < 0 || this.port > 65535) {
                throw new IllegalArgumentException(Msg.getString("K0325", this.port));
            }
        } else {
            if (hostPart.length() > 0) {
                this.host = hostPart;
            }
            this.port = this.getDefaultPort();
        }
    }

    void doRequest() throws IOException {
        if (this.sentRequest) {
            if (this.resHeader == null && this.os != null) {
                this.os.sendCache(true);
                this.readServerResponse();
                this.getContentStream();
            }
            return;
        }
        int redirect = 0;
        try {
            while (true) {
                this.sendRequest();
                if (this.os != null && this.os.isChunked()) {
                    this.os.sendCache(true);
                }
                this.readServerResponse();
                if (!this.followRedirects || this.responseCode != 300 && this.responseCode != 301 && this.responseCode != 302 && this.responseCode != 303 && this.responseCode != 305 || this.os != null) break;
                if (++redirect > 4) {
                    throw new IOException(Msg.getString("K0093"));
                }
                String location = this.resHeader.get("Location");
                if (location == null) break;
                if (location.startsWith(String.valueOf(this.getProtocol()) + ':')) {
                    int start = this.getProtocol().length() + 1;
                    if (this.responseCode == 305) {
                        if (location.startsWith("//", start)) {
                            this.setProxy(location.substring(start + 2));
                        } else {
                            this.setProxy(location.substring(start));
                        }
                    } else {
                        this.parseURL(location.substring(start));
                    }
                } else if (this.responseCode == 305) {
                    if (location.startsWith("//")) {
                        this.setProxy(location.substring(2));
                    } else {
                        this.setProxy(location);
                    }
                } else {
                    this.parseURL(location);
                }
                this.closeSocket();
                this.connected = false;
            }
            this.getContentStream();
        }
        catch (RuntimeException e) {
            try {
                this.closeSocket();
            }
            catch (Exception exception) {}
            throw e;
        }
        catch (IOException e) {
            try {
                this.closeSocket();
            }
            catch (Exception exception) {}
            throw e;
        }
    }

    void readHeaders(Header headers) throws IOException {
        String line;
        while ((line = this.readln()) != null && line.length() > 1) {
            int idx = line.indexOf(":");
            if (idx < 0) {
                headers.add(null, line.trim());
                continue;
            }
            headers.add(line.substring(0, idx), line.substring(idx + 1).trim());
        }
    }

    private byte[] createRequest() throws IOException {
        String agent;
        StringBuffer output = new StringBuffer(256);
        output.append(this.method);
        output.append(' ');
        output.append(this.requestString());
        output.append(' ');
        output.append("HTTP/1.");
        if (this.httpVersion == 0) {
            output.append("0\r\n");
        } else {
            output.append("1\r\n");
        }
        if (this.reqHeader.get("User-Agent") == null && (agent = System.getProperty("http.agent")) != null) {
            output.append("User-Agent: ");
            output.append(agent);
            output.append("\r\n");
        }
        if (this.reqHeader.get("Host") == null) {
            output.append("Host: ");
            output.append(this.getHost());
            int port = this.getPort();
            if (port != 80) {
                output.append(':');
                output.append(Integer.toString(port));
            }
            output.append("\r\n");
        }
        if (this.httpVersion > 0 && this.reqHeader.get("Connection") == null) {
            output.append("Connection: close\r\n");
        }
        if (this.os != null) {
            if (this.reqHeader.get("Content-Type") == null) {
                output.append("Content-Type: application/x-www-form-urlencoded\r\n");
            }
            if (this.os.isCached()) {
                output.append("Content-Length: ");
                output.append(Integer.toString(this.os.size()));
                output.append("\r\n");
            } else if (this.os.isChunked()) {
                output.append("Transfer-Encoding: chunked\r\n");
            }
        }
        int i = 0;
        while (i < this.reqHeader.length()) {
            String lKey;
            String key = this.reqHeader.getKey(i);
            if (!(key == null || (lKey = key.toLowerCase()).equals("content-length") || (this.os == null || this.os.isChunked()) && lKey.equals("transfer-encoding"))) {
                output.append(key);
                output.append(": ");
                output.append(this.reqHeader.get(i));
                output.append("\r\n");
            }
            ++i;
        }
        output.append("\r\n");
        return output.toString().getBytes("ISO8859_1");
    }

    void sendRequest() throws IOException {
        byte[] request = this.createRequest();
        this.connect();
        byte[] outbuf = null;
        if (this.os != null && this.os.isCached()) {
            outbuf = this.os.toByteArray();
        }
        this.socketOut.write(request);
        if (outbuf != null) {
            this.socketOut.write(outbuf);
        }
        if (this.os == null || outbuf != null) {
            this.socketOut.flush();
        }
        this.sentRequest = true;
    }

    void readServerResponse() throws IOException {
        this.is = new BufferedInputStream(this.socket.openInputStream());
        do {
            this.responseCode = -1;
            this.responseMessage = null;
            this.resHeader = new Header(true);
            String line = this.readln();
            if (line == null) continue;
            this.resHeader.add(null, line.trim());
            this.readHeaders(this.resHeader);
        } while (this.getResponseCode() == 100);
    }

    /*
     * Unable to fully structure code
     */
    String readln() throws IOException {
        lastCr = false;
        result = new StringBuffer(80);
        c = this.is.read();
        if (c >= 0) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            if (lastCr) {
                result.append('\r');
                lastCr = false;
            }
            if (c == 13) {
                lastCr = true;
            } else {
                result.append((char)c);
            }
            c = this.is.read();
            if (c < 0) break;
lbl17:
            // 2 sources

            ** while (c != 10)
        }
lbl18:
        // 2 sources

        return result.toString();
    }

    protected void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.socket = this.openSocket(this.timeout, this.socketOptions);
        this.connected = true;
        this.socketOut = this.socket.openOutputStream();
    }

    protected StreamConnection openSocket(boolean timeout, String socketOptions) throws IOException {
        this.openNetworkInterfaceAndUpdateProxyInformation();
        String spec = "//" + this.getHostName() + ":" + this.getHostPort() + socketOptions;
        com.ibm.oti.connection.socket.Connection connection = new com.ibm.oti.connection.socket.Connection(0);
        return (StreamConnection)((CreateConnection)connection).setParameters2(spec, 3, timeout);
    }

    protected void openNetworkInterfaceAndUpdateProxyInformation() {
        String httpProxyHost = System.getProperty("http.proxyHost");
        String httpProxyPort = System.getProperty("http.proxyPort");
        if (httpProxyHost == null || httpProxyPort == null) {
            String[] proxyValues = VM.getHttpProxyParms();
            if (proxyValues == null) {
                return;
            }
            this.proxyName = proxyValues[0];
            this.proxyPort = Integer.parseInt(proxyValues[1]);
            VM.setSystemProperty("http.proxyHost", this.proxyName);
            VM.setSystemProperty("http.proxyPort", proxyValues[1]);
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.conClosed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.inputStatus != 0) {
            throw new IOException(Msg.getString("K0192"));
        }
        this.doRequest();
        this.inputStatus = 1;
        return new InputStream(){

            public int available() throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                return Connection.this.uis.available();
            }

            public int read() throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                return Connection.this.uis.read();
            }

            public int read(byte[] buf, int offset, int length) throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                return Connection.this.uis.read(buf, offset, length);
            }

            public long skip(int amount) throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                return Connection.this.uis.skip(amount);
            }

            public void close() throws IOException {
                if (Connection.this.inputStatus != 2) {
                    Connection.this.inputStatus = 2;
                    Connection.this.closeSocket();
                }
            }
        };
    }

    private InputStream getContentStream() throws IOException {
        String encoding = this.resHeader.get("Transfer-Encoding");
        if (encoding != null && encoding.toLowerCase().equals("chunked")) {
            this.uis = new ChunkedInputStream();
            return this.uis;
        }
        String sLength = this.resHeader.get("Content-Length");
        if (sLength != null) {
            try {
                int length = Integer.parseInt(sLength);
                this.uis = new LimitedInputStream(length);
                return this.uis;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.uis = this.is;
        return this.uis;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.conClosed) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 2 && this.access != 3) {
            throw new IOException(Msg.getString("K00aa"));
        }
        if (this.sentRequest && this.os == null) {
            throw new IOException(Msg.getString("K0037"));
        }
        if (this.outputStatus != 0) {
            throw new IOException(Msg.getString("K0192"));
        }
        if (this.os == null) {
            this.method = POST;
            String encoding = this.reqHeader.get("Transfer-Encoding");
            if (encoding != null) {
                encoding = encoding.toLowerCase();
            }
            this.os = new HttpOutputStream(this.sendChunked || "chunked".equals(encoding));
        }
        this.outputStatus = 1;
        return new OutputStream(){

            public void write(int value) throws IOException {
                if (Connection.this.outputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                Connection.this.os.write(value);
            }

            public void write(byte[] buf, int offset, int length) throws IOException {
                if (Connection.this.outputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                Connection.this.os.write(buf, offset, length);
            }

            public void flush() throws IOException {
                if (Connection.this.outputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                Connection.this.os.flush();
            }

            public void close() throws IOException {
                if (Connection.this.outputStatus != 2) {
                    Connection.this.outputStatus = 2;
                    Connection.this.os.close();
                }
            }
        };
    }

    private String requestString() {
        if (this.proxyName != null) {
            return this.getURL();
        }
        return this.file == null ? "/" : this.file;
    }

    protected String getHostName() {
        if (this.proxyName != null) {
            return this.proxyName;
        }
        return this.getHost();
    }

    protected int getHostPort() {
        if (this.proxyName != null) {
            return this.proxyPort;
        }
        return this.getPort();
    }

    public long getLength() {
        try {
            String sLength = this.getHeaderField("Content-Length");
            if (sLength == null) {
                return -1L;
            }
            return Long.parseLong(sLength);
        }
        catch (IOException iOException) {
            return -1L;
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public String getEncoding() {
        try {
            return this.getHeaderField("Content-Encoding");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getType() {
        try {
            return this.getHeaderField("Content-Type");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected boolean isClosed() {
        return this.conClosed;
    }

    public static void allowProxyParameter() {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        allowProxyParameter = true;
    }

    private final class LimitedInputStream
    extends InputStream {
        int bytesRemaining;

        public LimitedInputStream(int length) {
            this.bytesRemaining = length;
        }

        public void close() throws IOException {
            this.bytesRemaining = 0;
            Connection.this.closeSocket();
        }

        public int available() throws IOException {
            int result = Connection.this.is.available();
            if (result > this.bytesRemaining) {
                return this.bytesRemaining;
            }
            return result;
        }

        public int read() throws IOException {
            if (this.bytesRemaining <= 0) {
                return -1;
            }
            int result = Connection.this.is.read();
            --this.bytesRemaining;
            return result;
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            int result;
            if (buf == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || offset > buf.length || buf.length - offset < length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.bytesRemaining <= 0) {
                return -1;
            }
            if (length > this.bytesRemaining) {
                length = this.bytesRemaining;
            }
            if ((result = Connection.this.is.read(buf, offset, length)) > 0) {
                this.bytesRemaining -= result;
            }
            return result;
        }

        public long skip(int amount) throws IOException {
            long result;
            if (this.bytesRemaining <= 0) {
                return -1L;
            }
            if (amount > this.bytesRemaining) {
                amount = this.bytesRemaining;
            }
            if ((result = Connection.this.is.skip(amount)) > 0L) {
                this.bytesRemaining = (int)((long)this.bytesRemaining - result);
            }
            return result;
        }
    }

    private final class ChunkedInputStream
    extends InputStream {
        int bytesRemaining = -1;
        boolean atEnd = false;

        public ChunkedInputStream() throws IOException {
            this.readChunkSize();
        }

        public void close() throws IOException {
            this.atEnd = true;
            Connection.this.closeSocket();
        }

        public int available() throws IOException {
            int result = Connection.this.is.available();
            if (result > this.bytesRemaining) {
                return this.bytesRemaining;
            }
            return result;
        }

        private void readChunkSize() throws IOException {
            String size;
            int index;
            if (this.atEnd) {
                return;
            }
            if (this.bytesRemaining == 0) {
                Connection.this.readln();
            }
            if ((index = (size = Connection.this.readln()).indexOf(";")) >= 0) {
                size = size.substring(0, index);
            }
            this.bytesRemaining = Integer.parseInt(size.trim(), 16);
            if (this.bytesRemaining == 0) {
                this.atEnd = true;
                Connection.this.readHeaders(Connection.this.resHeader);
            }
        }

        public int read() throws IOException {
            if (this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1;
            }
            --this.bytesRemaining;
            return Connection.this.is.read();
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            int result;
            if (buf == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || offset > buf.length || buf.length - offset < length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1;
            }
            if (length > this.bytesRemaining) {
                length = this.bytesRemaining;
            }
            if ((result = Connection.this.is.read(buf, offset, length)) > 0) {
                this.bytesRemaining -= result;
            }
            return result;
        }

        public long skip(int amount) throws IOException {
            long result;
            if (this.atEnd) {
                return -1L;
            }
            if (this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (amount > this.bytesRemaining) {
                amount = this.bytesRemaining;
            }
            if ((result = Connection.this.is.skip(amount)) > 0L) {
                this.bytesRemaining = (int)((long)this.bytesRemaining - result);
            }
            return result;
        }
    }

    private final class HttpOutputStream
    extends OutputStream {
        static final int MAX = 1024;
        ByteArrayOutputStream cache = new ByteArrayOutputStream(1031);
        boolean chunked;
        boolean closed = false;

        public HttpOutputStream(boolean chunked) {
            this.chunked = chunked;
        }

        private void output(String output) throws IOException {
            Connection.this.socketOut.write(output.getBytes("ISO8859_1"));
        }

        synchronized void sendCache(boolean close) throws IOException {
            if (this.cache == null) {
                return;
            }
            int size = this.cache.size();
            if (size > 0 || close) {
                if (size > 0) {
                    this.output(String.valueOf(Integer.toHexString(size)) + "\r\n");
                    this.cache.write(13);
                    this.cache.write(10);
                }
                if (close) {
                    this.cache.write(48);
                    this.cache.write(13);
                    this.cache.write(10);
                    this.cache.write(13);
                    this.cache.write(10);
                }
                Connection.this.socketOut.write(this.cache.toByteArray());
                if (close) {
                    Connection.this.socketOut.flush();
                    this.chunked = false;
                    this.cache = null;
                } else {
                    this.cache.reset();
                }
            }
        }

        public synchronized void flush() throws IOException {
            if (this.closed) {
                throw new IOException(Msg.getString("K0059"));
            }
            if (!Connection.this.sentRequest) {
                this.chunked = true;
                Connection.this.sendRequest();
            }
            this.sendCache(false);
            Connection.this.socketOut.flush();
        }

        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            IOException ex = null;
            try {
                if (this.chunked) {
                    if (Connection.this.sentRequest && Connection.this.socketOut != null) {
                        this.sendCache(this.closed);
                    }
                } else if (!Connection.this.sentRequest) {
                    Connection.this.sendRequest();
                }
            }
            catch (IOException e) {
                ex = e;
            }
            if (Connection.this.conClosed) {
                if (Connection.this.socketOut != null) {
                    Connection.this.socketOut.close();
                }
                if (Connection.this.socket != null) {
                    Connection.this.socket.close();
                }
            }
            if (ex != null) {
                throw ex;
            }
        }

        public synchronized void write(int data) throws IOException {
            if (this.closed) {
                throw new IOException(Msg.getString("K0059"));
            }
            if (this.cache != null) {
                this.cache.write(data);
                if (this.chunked && this.cache.size() >= 1024) {
                    this.sendCache(false);
                }
            }
        }

        public synchronized void write(byte[] buffer, int offset, int count) throws IOException {
            if (this.closed) {
                throw new IOException(Msg.getString("K0059"));
            }
            if (buffer == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || count < 0 || offset > buffer.length || buffer.length - offset < count) {
                throw new ArrayIndexOutOfBoundsException(Msg.getString("K002f"));
            }
            if (!this.chunked || this.cache.size() + count < 1024) {
                if (this.cache != null) {
                    this.cache.write(buffer, offset, count);
                }
            } else {
                if (this.chunked) {
                    if (!Connection.this.sentRequest) {
                        Connection.this.sendRequest();
                    }
                    this.output(String.valueOf(Integer.toHexString(count + this.cache.size())) + "\r\n");
                }
                Connection.this.socketOut.write(this.cache.toByteArray());
                this.cache.reset();
                Connection.this.socketOut.write(buffer, offset, count);
                if (this.chunked) {
                    this.output("\r\n");
                }
            }
        }

        synchronized int size() {
            return this.cache.size();
        }

        synchronized byte[] toByteArray() {
            byte[] result = this.cache.toByteArray();
            this.cache = null;
            return result;
        }

        boolean isCached() {
            return !this.chunked;
        }

        boolean isChunked() {
            return this.chunked;
        }
    }
}

