/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.connection.socket;

import com.ibm.oti.connection.ConnectionUtil;
import com.ibm.oti.connection.CreateConnection;
import com.ibm.oti.connection.socket.Socket;
import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamConnection;

public class Connection
extends Socket
implements CreateConnection,
StreamConnection {
    static final int DEFAULT_TIMEOUT = 8000;
    private static final int UNOPENED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private String host;
    private int access;
    private int port = 0;
    private int timeout = 0;
    private int inputStatus = 0;
    private int outputStatus = 0;
    private int tcpNoDelay;

    public Connection() {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
    }

    public Connection(int access) {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        this.host = "";
        this.access = access;
    }

    public javax.microedition.io.Connection setParameters2(String spec, int access, boolean timeout) throws IOException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        if (spec.startsWith("//") && (spec.length() > 3 && spec.charAt(2) == ':' || spec.length() > 2 && spec.charAt(2) == ';')) {
            Class connectionClass = null;
            try {
                connectionClass = Class.forName("com.ibm.oti.connection.serversocket.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConnectionNotFoundException(Msg.getString("K0002", "serversocket"));
            }
            boolean exception = false;
            CreateConnection connection = null;
            try {
                connection = (CreateConnection)connectionClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                exception = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                exception = true;
            }
            if (exception) {
                throw new ConnectionNotFoundException(Msg.getString("K0003", connectionClass));
            }
            return connection.setParameters2(spec, access, timeout);
        }
        this.setParameters(spec, access, timeout);
        return this;
    }

    private void setParameters(String spec, int access, boolean timeout) throws IOException {
        if (!VM.callerIsBootstrap()) {
            throw new SecurityException();
        }
        String[][] equates = ConnectionUtil.NO_PARAMETERS;
        int index = spec.indexOf(59);
        if (index != -1) {
            equates = ConnectionUtil.getParameters(spec.substring(index + 1));
            spec = spec.substring(0, index);
        }
        this.setParameters(spec, equates, access, timeout);
    }

    private void setParameters(String spec, String[][] equates, int access, boolean throwTimeout) throws IOException {
        int[] result = new int[1];
        boolean setNoDelay = false;
        boolean setKeepAlive = false;
        int linger = -1;
        int rcvbuf = 0;
        int sndbuf = 0;
        int i = 0;
        while (i < equates.length) {
            String value;
            String key = equates[i][0];
            equates[i][0] = equates[i][0].toLowerCase();
            if (ConnectionUtil.intParam("so_timeout", equates[i], 1, result)) {
                this.timeout = result[0];
            } else if (ConnectionUtil.intParam("so_linger", equates[i], 1, result)) {
                linger = result[0];
                if (linger > 65535) {
                    linger = 65535;
                }
            } else if (equates[i][0].equals("tcp_nodelay")) {
                value = equates[i][1].toLowerCase();
                if (value.equals("true")) {
                    setNoDelay = true;
                } else if (!value.equals("false")) {
                    throw new IllegalArgumentException(Msg.getString("K00b5", equates[i][1]));
                }
            } else if (equates[i][0].equals("so_keepalive")) {
                value = equates[i][1].toLowerCase();
                if (value.equals("true")) {
                    setKeepAlive = true;
                } else if (!value.equals("false")) {
                    throw new IllegalArgumentException(Msg.getString("K00b5", equates[i][1]));
                }
            } else if (ConnectionUtil.intParam("so_rcvbuf", equates[i], 2, result)) {
                rcvbuf = result[0];
            } else if (ConnectionUtil.intParam("so_sndbuf", equates[i], 2, result)) {
                sndbuf = result[0];
            } else {
                throw new IllegalArgumentException(Msg.getString("K00a5", key));
            }
            ++i;
        }
        if (throwTimeout && this.timeout == 0) {
            this.timeout = 8000;
        }
        this.host = spec;
        this.access = access;
        if (!this.host.startsWith("//")) {
            throw new IllegalArgumentException(Msg.getString("K01cc"));
        }
        this.host = Socket.parseURL(spec, result, true, false);
        byte[] addr = new byte[4];
        try {
            addr = Socket.resolveHost(this.host);
        }
        catch (IOException e) {
            throw new ConnectionNotFoundException(Msg.getString("K01ce", this.host, e.getMessage()));
        }
        try {
            try {
                this.connectStreamImpl(0, result[0], addr);
            }
            catch (ConnectionNotFoundException e) {
                throw new ConnectionNotFoundException(Msg.getString("K01cf", "(" + Socket.addressToString(addr) + ") " + this.host + ":" + result[0], e.getMessage()));
            }
            if (rcvbuf != 0) {
                this.setSocketOptionImpl(4098, rcvbuf);
            }
            if (sndbuf != 0) {
                this.setSocketOptionImpl(4097, sndbuf);
            }
            if (linger != -1) {
                this.setSocketOptionImpl(128, linger);
            }
            if (setNoDelay) {
                this.setSocketOptionImpl(1, 1);
                this.tcpNoDelay = 1;
            }
            if (setKeepAlive) {
                this.setSocketOptionImpl(8, 1);
            }
        }
        catch (IOException e) {
            this.socketClose();
            throw e;
        }
        this.socketOpen();
    }

    public void close() throws IOException {
        this.host = null;
        if (this.inputStatus != 1 && this.outputStatus != 1) {
            this.socketClose();
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 1 && this.access != 3) {
            throw new IOException(Msg.getString("K00a9"));
        }
        if (this.inputStatus != 0) {
            throw new IOException(Msg.getString("K0192"));
        }
        this.inputStatus = 1;
        return new InputStream(){

            public int available() throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                return Connection.this.availableStreamImpl();
            }

            public void close() throws IOException {
                if (Connection.this.inputStatus != 2) {
                    Connection.this.inputStatus = 2;
                    if (Connection.this.outputStatus == 2 || Connection.this.host == null && Connection.this.outputStatus == 0) {
                        Connection.this.socketClose();
                    }
                }
            }

            public int read(byte[] buffer, int offset, int count) throws IOException {
                if (Connection.this.inputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                if (buffer == null) {
                    throw new IOException(Msg.getString("K0047"));
                }
                if (count == 0) {
                    return 0;
                }
                if (offset < 0 || count < 0 || offset >= buffer.length || buffer.length - offset < count) {
                    throw new ArrayIndexOutOfBoundsException(Msg.getString("K002f"));
                }
                int result = Connection.this.receiveStreamImpl(buffer, offset, count, Connection.this.timeout);
                return result;
            }

            public int read() throws IOException {
                byte[] buffer = new byte[1];
                int result = this.read(buffer, 0, 1);
                return -1 == result ? result : buffer[0] & 0xFF;
            }
        };
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        if (this.access != 2 && this.access != 3) {
            throw new IOException(Msg.getString("K00aa"));
        }
        if (this.outputStatus != 0) {
            throw new IOException(Msg.getString("K0192"));
        }
        this.outputStatus = 1;
        return new OutputStream(){

            public void close() throws IOException {
                if (Connection.this.outputStatus != 2) {
                    if ((Socket.getSocketFlags() & 8) == 0 || Connection.this.getSocketOptionImpl(128) == 0) {
                        Connection.this.shutdownSideImpl(false);
                    }
                    Connection.this.outputStatus = 2;
                    if (Connection.this.inputStatus == 2 || Connection.this.inputStatus == 0 && Connection.this.host == null) {
                        Connection.this.socketClose();
                    }
                }
            }

            public void write(int oneByte) throws IOException {
                byte[] buffer = new byte[]{(byte)oneByte};
                this.write(buffer, 0, 1);
            }

            public void write(byte[] buffer, int offset, int count) throws IOException {
                if (Connection.this.outputStatus == 2) {
                    throw new IOException(Msg.getString("K0059"));
                }
                if (buffer == null) {
                    throw new NullPointerException();
                }
                if (count == 0) {
                    return;
                }
                if (offset < 0 || count < 0 || offset >= buffer.length || buffer.length - offset < count) {
                    throw new ArrayIndexOutOfBoundsException(Msg.getString("K002f"));
                }
                Connection.this.sendStreamImpl(buffer, offset, count);
            }
        };
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    native void connectStreamImpl(int var1, int var2, byte[] var3) throws IOException;

    native int receiveStreamImpl(byte[] var1, int var2, int var3, int var4) throws IOException;

    native int sendStreamImpl(byte[] var1, int var2, int var3) throws IOException;

    native int availableStreamImpl() throws IOException;

    public String getLocalAddress() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return Socket.addressToString(this.address);
    }

    public int getLocalPort() throws IOException {
        if (this.host == null) {
            throw new IOException(Msg.getString("K00ac"));
        }
        return this.localport;
    }

    private native int shutdownSideImpl(boolean var1) throws IOException;

    public int getTimeout() {
        return this.timeout;
    }
}

