/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.JxeResource;
import com.ibm.oti.vm.JxeResourceTable;
import com.ibm.oti.vm.MemInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public final class Jxe {
    private long jxePointer;
    private Hashtable resTable;
    static final int DEFLATED = 8;
    static final int STORED = 0;

    Jxe(long pointer) {
        this.jxePointer = pointer;
    }

    long getJxePointer() {
        return this.jxePointer;
    }

    public InputStream getResourceAsStream(String name) {
        this.initializeResTable();
        while (true) {
            JxeResource entry;
            if ((entry = (JxeResource)this.resTable.get(name)) != null) {
                MemInputStream stream = new MemInputStream(entry.getPointer(), entry.getSize(), this);
                if (entry.getMethod() != 0) {
                    throw new RuntimeException(Msg.getString("K01d0"));
                }
                return stream;
            }
            if (!name.startsWith("/", 0)) {
                return null;
            }
            name = name.substring(1);
        }
    }

    private void initializeResTable() {
        JxeResourceTable resources;
        if (this.resTable != null) {
            return;
        }
        try {
            resources = new JxeResourceTable(new MemInputStream(this.getJxePointer(), Integer.MAX_VALUE, null));
        }
        catch (IOException iOException) {
            this.resTable = new Hashtable(0);
            return;
        }
        this.resTable = resources.getTable();
    }
}

