/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.comm;

import com.nokia.mj.impl.comm.CommConnectionPort;
import com.nokia.mj.impl.comm.CommConnectionUrlParser;
import com.nokia.mj.impl.gcf.utils.StreamConnectionBase;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.utils.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.CommConnection;

public final class CommConnectionImpl
extends StreamConnectionBase
implements CommConnection {
    private int[] mParamterValues = new int[7];
    private boolean mConnectionIsOpen;
    private CommConnectionPort mCommPort;
    private Finalizer mFinalizer;
    private boolean mOutputStreamOpenedOnce = false;
    private boolean mDataOutputStreamOpenedOnce = false;
    private boolean iInputStreamOpenedOnce = false;
    private boolean iDataInputStreamOpenedOnce = false;
    protected static final int COMM_BAUDRATE_INDEX = 0;
    protected static final int COMM_BITSPERCHAR_INDEX = 1;
    protected static final int COMM_STOPBITS_INDEX = 2;
    protected static final int COMM_PARITY_INDEX = 3;
    protected static final int COMM_BLOCKING_INDEX = 4;
    protected static final int COMM_AUTORTS_INDEX = 5;
    protected static final int COMM_AUTOCTS_INDEX = 6;

    public CommConnectionImpl(String aUri, int mode, boolean aTimeout) throws IOException {
        super(aUri, mode, false, false);
        Logger.LOG(14, 4, "++CommConnectionImpl(), uri = " + aUri);
        Logger.LOG(14, 4, "CommConnectionImpl() :: uri = " + aUri);
        this.mCommPort = new CommConnectionPort();
        CommConnectionUrlParser.parseURI(aUri, this.mParamterValues, this.mCommPort);
        Logger.LOG(14, 4, "++CommConnectionImpl, url parsed successfully");
        Logger.LOG(14, 4, "++CommConnectionImpl,baud rate = " + this.mParamterValues[0]);
        int ret = this._openCommportConnection(this.iNativePeerHandle, this.mCommPort.mCommPortName, this.mCommPort.mCommPortNumber, this.mParamterValues);
        Logger.LOG(14, 4, "++CommConnectionImpl(), _openCommConnection returned  " + ret);
        if (ret != 0) {
            throw new IOException("Unable to open CommConnection: Symbian OS error code: " + ret);
        }
        this.mFinalizer = this.createFinalizer();
        this.mConnectionIsOpen = true;
        Logger.LOG(14, 4, "--CommConnectionImpl()");
    }

    private Finalizer createFinalizer() {
        return new Finalizer(){

            public void finalizeImpl() {
                CommConnectionImpl.this.doFinalize();
            }
        };
    }

    private void doFinalize() {
        if (this.mConnectionIsOpen) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.iNativePeerHandle != 0) {
            this._dispose(this.iNativePeerHandle);
            this.iNativePeerHandle = 0;
        }
    }

    public int getBaudRate() {
        Logger.LOG(14, 4, "CommConnectionImpl::getBaudRate()");
        return this._getBaudRate(this.iNativePeerHandle);
    }

    public int setBaudRate(int aRate) {
        Logger.LOG(14, 4, "CommConnectionImpl::setBaudRate()");
        return this._setBaudRate(this.iNativePeerHandle, aRate);
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.mOutputStreamOpenedOnce) {
            throw new IOException("OutputStream cannot be opened multiple times");
        }
        this.mOutputStreamOpenedOnce = true;
        return super.openOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        if (this.mDataOutputStreamOpenedOnce) {
            throw new IOException("DataOutputStream cannot be opened multiple times");
        }
        this.mDataOutputStreamOpenedOnce = true;
        return super.openDataOutputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        if (this.iDataInputStreamOpenedOnce) {
            throw new IOException("DataInputStream cannot be opened multiple times");
        }
        this.iDataInputStreamOpenedOnce = true;
        return super.openDataInputStream();
    }

    public InputStream openInputStream() throws IOException {
        if (this.iInputStreamOpenedOnce) {
            throw new IOException("InputStream cannot be opened multiple times");
        }
        this.iInputStreamOpenedOnce = true;
        return super.openInputStream();
    }

    public int createNativePeer(String aUri, int aMode, boolean timeout) {
        return this._createNativePeer();
    }

    public void close() throws IOException {
        Logger.LOG(14, 4, "CommConnectionImpl::close(), flag = " + this.mConnectionIsOpen);
        if (!this.mConnectionIsOpen) {
            return;
        }
        this.mConnectionIsOpen = false;
        super.close();
        if (this.isStreamsClosed()) {
            Logger.LOG(14, 4, "CommConnectionImpl::close(), doing native close");
            this._close(this.iNativePeerHandle);
        }
    }

    private native int _createNativePeer();

    private native int _openCommportConnection(int var1, String var2, int var3, int[] var4);

    private native int _setBaudRate(int var1, int var2);

    private native int _getBaudRate(int var1);

    private native void _close(int var1);

    private native void _dispose(int var1);
}

