/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.comms;

import com.nokia.mj.impl.comms.CommsListener;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.comms.exception.CommsException;
import java.io.IOException;

public abstract class CommsEndpointBase {
    protected int iHandle;

    public void registerListener(int aModuleId, CommsListener aListener) throws CommsException {
        if (aListener == null) {
            throw new IllegalArgumentException("aListener is null");
        }
        this.checkHandle();
        int rc = this._registerlistener(this.iHandle, aModuleId, aListener);
        if (rc != 0) {
            throw new CommsException("Listener already exists, moduleId=" + aModuleId);
        }
    }

    public void unregisterListener(int aModuleId) throws CommsException {
        this.checkHandle();
        int rc = this._unregisterlistener(this.iHandle, aModuleId);
        if (rc != 0) {
            throw new CommsException("Listener not found, moduleId=" + aModuleId);
        }
    }

    public void registerDefaultListener(CommsListener aListener) throws CommsException {
        if (aListener == null) {
            throw new IllegalArgumentException("aListener is null");
        }
        this.checkHandle();
        int rc = this._registerdefaultlistener(this.iHandle, aListener);
        if (rc != 0) {
            throw new CommsException("default listener already exists");
        }
    }

    public void unregisterDefaultListener() throws CommsException {
        this.checkHandle();
        int rc = this._unregisterdefaultlistener(this.iHandle);
        if (rc != 0) {
            throw new CommsException("default listener not found");
        }
    }

    public void send(CommsMessage aMessage) throws CommsException {
        if (aMessage == null) {
            throw new IllegalArgumentException("aMessage is null");
        }
        this.checkHandle();
        int rc = this._send(this.iHandle, aMessage.toByteArray());
        if (rc != 0) {
            throw new CommsException("send failed, error code=" + rc);
        }
    }

    public CommsMessage sendReceive(CommsMessage aMessage, int timeoutInSecs) throws CommsException {
        if (aMessage == null) {
            throw new IllegalArgumentException("aMessage is null");
        }
        this.checkHandle();
        try {
            byte[] msg = this._sendreceive(this.iHandle, aMessage.toByteArray(), timeoutInSecs);
            return new CommsMessage(msg);
        }
        catch (IOException io) {
            throw new CommsException("sendReceive failed", io);
        }
        catch (InterruptedException ie) {
            throw new CommsException("sendReceive timeout", ie);
        }
    }

    public abstract void destroy();

    protected void checkHandle() throws CommsException {
        if (this.iHandle == 0) {
            throw new CommsException("No native peer");
        }
    }

    private native int _registerlistener(int var1, int var2, CommsListener var3);

    private native int _unregisterlistener(int var1, int var2);

    private native int _registerdefaultlistener(int var1, CommsListener var2);

    private native int _unregisterdefaultlistener(int var1);

    private native int _send(int var1, byte[] var2);

    private native byte[] _sendreceive(int var1, byte[] var2, int var3) throws IOException, InterruptedException;

    protected native void _release(int var1);

    protected native void _detach(int var1);
}

