/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.file;

import com.nokia.mj.impl.file.FileAccessHelper;
import com.nokia.mj.impl.file.FileConnectionURL;
import com.nokia.mj.impl.file.FileInternalPermission;
import com.nokia.mj.impl.file.FileLogger;
import com.nokia.mj.impl.file.FileSystemUtils;
import com.nokia.mj.impl.file.FileUrlValidator;
import com.nokia.mj.impl.fileutils.FileUTF8Handler;
import com.nokia.mj.impl.fileutils.FileUtility;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.file.ConnectionClosedException;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.IllegalModeException;

public final class FileConnectionImpl
implements FileConnection {
    private FileUtility iFileUtility;
    private Finalizer iFinalizer;
    private boolean iIsOpen;
    private int iMode;
    private String iInitialUrl;
    private String FILE_LOCALHOST = "//localhost/";
    private String FILE_SIMPLE = "///";
    private FileConnectionURL iFileConnectionUrl;

    public FileConnectionImpl(String aName, int aMode, boolean aTimeouts) throws IOException {
        this.iInitialUrl = "file:" + aName;
        String decodedUrl = FileUTF8Handler.decode(this.iInitialUrl);
        decodedUrl = decodedUrl.replace('|', ':');
        FileConnectionURL.checkFileUrlValidity(decodedUrl);
        String actual = FileUrlValidator.validateFileUrl(decodedUrl);
        this.iFileConnectionUrl = this.iInitialUrl.startsWith("file:" + this.FILE_SIMPLE) ? new FileConnectionURL(this.iInitialUrl, "file:///" + actual, false) : new FileConnectionURL(this.iInitialUrl, "file://localhost/" + actual, false);
        FileConnectionImpl.checkAccess(actual, aMode, true);
        FileConnectionImpl.checkSecurityPermission(actual, aMode);
        FileLogger.Log("FileConnectionImpl: Creating FileUtility With: " + actual);
        if (actual.indexOf("//") != -1) {
            throw new IllegalArgumentException("Invalid Uri :" + aName);
        }
        this.iFileUtility = new FileUtility(actual);
        this.iFinalizer = this.registerFinalize();
        this.iIsOpen = true;
        this.iMode = aMode;
        FileLogger.Log("FileConnectionImpl: Connector.open succeeded");
    }

    private Finalizer registerFinalize() {
        return new Finalizer(){

            public void finalizeImpl() {
                FileConnectionImpl.this.doFinalize();
            }
        };
    }

    private static void checkSecurityPermission(String aAbsolutePath, int aMode) {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        String accessIntent = aMode == 1 ? "read" : "write";
        FileLogger.Log("FileConnectionImpl: Check Permission to " + aAbsolutePath + " in " + accessIntent + " mode");
        if (3 == aMode) {
            FileInternalPermission permission = new FileInternalPermission(aAbsolutePath, "read");
            appUtils.checkPermission(permission);
            FileInternalPermission permission1 = new FileInternalPermission(aAbsolutePath, "write");
            appUtils.checkPermission(permission1);
        } else {
            FileInternalPermission permission = new FileInternalPermission(aAbsolutePath, accessIntent);
            appUtils.checkPermission(permission);
        }
    }

    private static void checkAccess(String aAbsolutePath, int aMode) {
        FileConnectionImpl.checkAccess(aAbsolutePath, aMode, false);
    }

    private static void checkAccess(String aAbsolutePath, int aMode, boolean aIsOpening) {
        String modeString;
        FileLogger.Log("FileConnectionImpl: Check Access to " + aAbsolutePath + " in " + aMode + " mode");
        switch (aMode) {
            case 1: {
                modeString = "read";
                break;
            }
            case 2: {
                modeString = "write";
                break;
            }
            default: {
                modeString = "read,write";
            }
        }
        if (!FileAccessHelper.accessAllowed(aAbsolutePath, modeString, FileSystemUtils.getProtectionDomain(), aIsOpening)) {
            throw new SecurityException("Permission denied: " + aAbsolutePath);
        }
    }

    private synchronized void doFinalize() {
        this.iFileUtility = null;
    }

    public void close() {
        this.iIsOpen = false;
        this.iFileUtility = null;
    }

    public final void create() throws IOException {
        this.checkConnection();
        this.checkConnectionMode(1);
        String domain = FileSystemUtils.getProtectionDomain();
        if (!FileAccessHelper.isCreateAllowedWithinDir(this.iFileUtility.getPath(), domain)) {
            throw new SecurityException("Permission denied: " + this.iFileUtility.getAbsolutePath());
        }
        if (!this.iFileUtility.createNewFile()) {
            FileLogger.WLog("FileConnectionImpl: File Creation failed. Throwing IOException");
            throw new IOException("Unable to create file: " + this.iFileUtility.getAbsolutePath());
        }
    }

    public final void rename(String aName) throws IOException {
        FileLogger.Log("FileConnectionImpl: rename(): " + aName);
        this.checkConnection();
        this.checkConnectionMode(1);
        FileConnectionImpl.checkAccess(this.iFileUtility.getAbsolutePath(), 2);
        if (!this.iFileUtility.rename(aName)) {
            FileLogger.ELog("FileConnectionImpl: File rename failed. Throwing IOException");
            throw new IOException("Unable to rename file or directory: " + this.iFileUtility.getAbsolutePath());
        }
        String curUrl = this.iFileConnectionUrl.getUrl();
        if (curUrl.endsWith("/")) {
            curUrl = curUrl.substring(0, curUrl.length() - 1);
        }
        String newUrl = curUrl.substring(0, curUrl.lastIndexOf(47) + 1);
        newUrl = newUrl + this.iFileUtility.getName();
        this.iFileConnectionUrl = new FileConnectionURL(newUrl);
    }

    public final void mkdir() throws IOException {
        this.checkConnection();
        this.checkConnectionMode(1);
        FileConnectionImpl.checkAccess(this.iFileUtility.getAbsolutePath(), 2);
        FileLogger.Log("FileConnectionImpl: mkdir(): " + this.iFileUtility.getAbsolutePath());
        if (!this.iFileUtility.mkdir()) {
            FileLogger.WLog("  FileConnectionImpl: FileUtility was unable to create directory.");
            throw new IOException("Unable to create directory: " + this.iFileUtility.getAbsolutePath());
        }
    }

    public final void delete() throws IOException {
        this.checkConnection();
        this.checkConnectionMode(1);
        FileConnectionImpl.checkAccess(this.iFileUtility.getAbsolutePath(), 2);
        FileLogger.Log("FileConnectionImpl: delete(): " + this.iFileUtility.getAbsolutePath());
        try {
            if (!this.iFileUtility.delete()) {
                FileLogger.WLog("FileConnectionImpl: Unable to delete file. Throwing IOException.");
                throw new IOException("Unable to delete file or directory: " + this.iFileUtility.getAbsolutePath());
            }
        }
        catch (SecurityException ex) {
            throw new IOException("Unable to delete file or directory: " + this.iFileUtility.getAbsolutePath());
        }
    }

    public boolean exists() {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.exists();
    }

    public String getName() {
        String name = this.iFileConnectionUrl.getName();
        if (name.equals("")) {
            return "";
        }
        if (this.iFileUtility.isDirectory()) {
            name = name + "/";
        } else if (!this.iFileUtility.exists() && this.iInitialUrl.endsWith("/")) {
            name = name + "/";
        }
        return name;
    }

    public String getPath() {
        String path = this.iFileConnectionUrl.getPath();
        return path;
    }

    public String getURL() {
        String ret = this.iFileConnectionUrl.getUrl();
        if (this.iFileUtility.isDirectory()) {
            if (!ret.endsWith("/")) {
                ret = ret + "/";
            }
        } else if (this.iFileUtility.isFile() && ret.endsWith("/")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public boolean isOpen() {
        return this.iIsOpen;
    }

    public boolean canRead() {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.canRead();
    }

    public boolean canWrite() {
        this.checkConnection();
        this.checkConnectionMode(2);
        if (1 == this.iMode) {
            return false;
        }
        return this.iFileUtility.canWrite();
    }

    public long lastModified() {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.lastModified();
    }

    public boolean isDirectory() {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.isDirectory();
    }

    public void setReadable(boolean aReadable) throws IOException {
        this.checkConnection();
        FileConnectionImpl.checkAccess(this.iFileUtility.getAbsolutePath(), 2);
        this.checkConnectionMode(1);
        this.iFileUtility.setReadable(aReadable);
    }

    public void setWritable(boolean aWritable) throws IOException {
        this.checkConnection();
        FileConnectionImpl.checkAccess(this.iFileUtility.getAbsolutePath(), 2);
        this.checkConnectionMode(1);
        this.iFileUtility.setWritable(aWritable);
    }

    public void setHidden(boolean aHidden) throws IOException {
        this.checkConnection();
        FileConnectionImpl.checkAccess(this.iFileUtility.getAbsolutePath(), 2);
        this.checkConnectionMode(1);
        this.iFileUtility.setHidden(aHidden);
    }

    public Enumeration list() throws IOException {
        return this.list("*", false);
    }

    public Enumeration list(String aFilter, boolean aIncludeHidden) throws IOException {
        FileLogger.Log("+FileConnectionImpl: list()");
        this.checkConnection();
        this.checkConnectionMode(2);
        String filter = aFilter;
        filter = FileConnectionImpl.trimFilter(filter);
        FileConnectionImpl.checkFilter(aFilter);
        String[] fileList = this.iFileUtility.listFileArray(aIncludeHidden);
        Vector accessibleFileList = new Vector();
        String parent = this.iFileUtility.getAbsolutePath();
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        String domain = FileSystemUtils.getProtectionDomain();
        boolean accessCheckNeeded = FileAccessHelper.isDirRestricted(parent);
        boolean accessAllowed = true;
        for (int index = 0; index < fileList.length; ++index) {
            String fullPath = parent + fileList[index];
            if (!FileUtility.matchString(filter.toLowerCase(), fileList[index])) continue;
            if (accessCheckNeeded) {
                accessAllowed = FileAccessHelper.accessAllowed(fullPath, "read", domain, true);
            }
            if (!accessAllowed) continue;
            accessibleFileList.addElement(fileList[index]);
        }
        return accessibleFileList.elements();
    }

    public void truncate(long aByteOffset) throws IOException {
        this.checkConnection();
        this.checkConnectionMode(1);
        FileConnectionImpl.checkAccess(this.iFileUtility.getAbsolutePath(), 2);
        this.iFileUtility.truncate(aByteOffset);
    }

    public final void setFileConnection(String aName) throws IOException {
        boolean result = false;
        this.checkConnection();
        if (aName == null) {
            FileLogger.ELog("FileConnectionImpl: setFileConnection(null)");
            throw new NullPointerException("Argument passed was null");
        }
        aName = aName.trim();
        this.checkSetFileConnParam(aName);
        if (aName.equals(".")) {
            FileLogger.Log("FileConnectionImpl: Set FileConnection to current");
            return;
        }
        if (!this.iFileUtility.isDirectory() && this.iFileUtility.exists()) {
            throw new IOException("Connection is not a directory: " + this.iFileUtility.getAbsolutePath());
        }
        if (aName.equals("..") || aName.equals("../")) {
            FileUtility tempTarget;
            FileLogger.Log("FileConnectionImpl: Set FileConnection to parent");
            FileLogger.Log("     Current target: " + this.iFileUtility.getAbsolutePath());
            FileLogger.Log("     Next target   : " + this.iFileUtility.getPath());
            String parent = this.iFileUtility.getPath();
            try {
                tempTarget = new FileUtility(parent);
            }
            catch (IllegalArgumentException ex) {
                FileLogger.WLog("FileConnectionImpl: setFileConnection: Unable to create new FileUtility object. Cannot set fileconnection to new target.");
                throw new IOException("File name is invalid or not accessible: " + aName);
            }
            catch (Exception e) {
                throw new IOException("File name is invalid or not accessible: " + aName);
            }
            FileConnectionImpl.checkAccess(tempTarget.getAbsolutePath(), this.iMode, true);
            FileConnectionImpl.checkSecurityPermission(tempTarget.getAbsolutePath(), this.iMode);
            this.iFileUtility = tempTarget;
            String prevUrl = this.iFileConnectionUrl.getUrl();
            if (prevUrl.endsWith("/")) {
                prevUrl = prevUrl.substring(0, prevUrl.length() - 1);
            }
            String newUrl = prevUrl.substring(0, prevUrl.lastIndexOf(47));
            FileLogger.Log("FileConnectionImpl: setFileConnection: Creating new FileConnectionURL With: " + newUrl);
            this.iFileConnectionUrl = new FileConnectionURL(newUrl, false);
            return;
        }
        if (!this.iFileUtility.exists()) {
            throw new IOException("Current directory does not exist: " + this.iFileUtility.getAbsolutePath());
        }
        FileLogger.Log("FileConnectionImpl: setFileConnection():  Setting FileConnectionUrl to: " + aName);
        String newTarget = this.iFileUtility.getAbsolutePath() + aName;
        FileLogger.Log("FileConnectionImpl: setFileConnection():  Creating FileUtility with " + newTarget);
        FileUtility tempTarget = new FileUtility(newTarget);
        if (!tempTarget.exists()) {
            FileLogger.WLog("FileConnectionImpl: setFileConnection():  New Target does not exist: " + tempTarget.getAbsolutePath());
            throw new IllegalArgumentException("File name is invalid or not accessible: " + aName);
        }
        FileConnectionImpl.checkAccess(tempTarget.getAbsolutePath(), this.iMode, true);
        FileConnectionImpl.checkSecurityPermission(tempTarget.getAbsolutePath(), this.iMode);
        this.iFileUtility = tempTarget;
        String prevUrl = this.iFileConnectionUrl.getUrl();
        if (!prevUrl.endsWith("/")) {
            prevUrl = prevUrl + "/";
        }
        String newUrl = prevUrl + this.iFileUtility.getName();
        FileLogger.Log("FileConnectionImpl: setFileConnection: Creating new FileConnectionURL With: " + newUrl);
        this.iFileConnectionUrl = new FileConnectionURL(newUrl, false);
    }

    public boolean isHidden() {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.isHidden();
    }

    public long availableSize() {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.availableSize();
    }

    public long usedSize() {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.usedSize();
    }

    public long totalSize() {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.totalSize();
    }

    public long fileSize() throws IOException {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.fileSize();
    }

    public long directorySize(boolean aIncludeSubDirs) throws IOException {
        this.checkConnection();
        this.checkConnectionMode(2);
        return this.iFileUtility.directorySize(aIncludeSubDirs);
    }

    public InputStream openInputStream() throws IOException {
        this.checkConnectionMode(2);
        if (!this.isOpen()) {
            throw new IOException();
        }
        FileConnectionImpl.checkSecurityPermission(this.iFileUtility.getAbsolutePath(), 1);
        try {
            return this.iFileUtility.openInputStream();
        }
        catch (SecurityException ex) {
            FileLogger.ELog("FileConnectionImpl: openInputStream():  SecurityException Caught from FileUtility. Throwing IOException.");
            throw new IOException("Unable to open InputStream: " + this.iFileUtility.getAbsolutePath());
        }
    }

    public DataInputStream openDataInputStream() throws IOException {
        this.checkConnectionMode(2);
        if (!this.isOpen()) {
            throw new IOException();
        }
        FileConnectionImpl.checkSecurityPermission(this.iFileUtility.getAbsolutePath(), 1);
        try {
            return this.iFileUtility.openDataInputStream();
        }
        catch (SecurityException ex) {
            FileLogger.ELog("FileConnectionImpl: openDataInputStream():  SecurityException Caught from FileUtility. Throwing IOException.");
            throw new IOException("Unable to open DataInputStream: " + this.iFileUtility.getAbsolutePath());
        }
    }

    public OutputStream openOutputStream() throws IOException {
        this.checkConnectionMode(1);
        if (!this.isOpen()) {
            throw new IOException();
        }
        FileConnectionImpl.checkSecurityPermission(this.iFileUtility.getAbsolutePath(), 2);
        try {
            return this.iFileUtility.openOutputStream();
        }
        catch (SecurityException ex) {
            FileLogger.ELog("FileConnectionImpl: openOutputStream():  SecurityException Caught from FileUtility. Throwing IOException.");
            throw new IOException("Unable to open OutputStream: " + this.iFileUtility.getAbsolutePath());
        }
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        this.checkConnectionMode(1);
        if (!this.isOpen()) {
            throw new IOException();
        }
        FileConnectionImpl.checkSecurityPermission(this.iFileUtility.getAbsolutePath(), 2);
        try {
            return this.iFileUtility.openDataOutputStream();
        }
        catch (SecurityException ex) {
            FileLogger.ELog("FileConnectionImpl: openDataOutputStream():  SecurityException Caught from FileUtility. Throwing IOException.");
            throw new IOException("Unable to open DataOutputStream: " + this.iFileUtility.getAbsolutePath());
        }
    }

    public OutputStream openOutputStream(long aOffset) throws IOException {
        this.checkConnectionMode(1);
        if (!this.isOpen()) {
            throw new IOException();
        }
        if (aOffset < 0L) {
            throw new IllegalArgumentException();
        }
        FileConnectionImpl.checkSecurityPermission(this.iFileUtility.getAbsolutePath(), 2);
        try {
            FileConnectionImpl.checkSecurityPermission(this.iFileUtility.getAbsolutePath(), this.iMode);
            return this.iFileUtility.openOutputStream(aOffset);
        }
        catch (SecurityException ex) {
            FileLogger.ELog("FileConnectionImpl: openDataOutputStream(offset):  SecurityException Caught from FileUtility. Throwing IOException.");
            throw new IOException("Unable to open OutputStream: " + this.iFileUtility.getAbsolutePath());
        }
    }

    private static String trimFilter(String aFilter) {
        String filter = FileUTF8Handler.decode(aFilter);
        filter = filter.trim();
        return filter;
    }

    private static void checkFilter(String aFilter) {
        if (aFilter.indexOf(63) != -1 || aFilter.indexOf(":") != -1 || aFilter.indexOf("/") != -1 || aFilter.indexOf("\\") != -1 || aFilter.indexOf("//") != -1 || aFilter.indexOf("|") != -1 || aFilter.indexOf("<") != -1 || aFilter.indexOf(">") != -1) {
            throw new IllegalArgumentException();
        }
    }

    private void checkConnection() {
        if (!this.iIsOpen) {
            throw new ConnectionClosedException("Connection has been closed");
        }
    }

    private final void checkConnectionMode(int aMode) throws IllegalModeException {
        if (this.iMode == aMode) {
            throw new IllegalModeException("Illegal mode for this operation call");
        }
    }

    private void checkSetFileConnParam(String aName) throws IOException {
        String toCheck = aName;
        if (toCheck.endsWith("/")) {
            toCheck = toCheck.substring(0, toCheck.length() - 1);
        }
        if (toCheck.indexOf(63) != -1 || toCheck.indexOf(60) != -1 || toCheck.indexOf(60) != -1 || toCheck.indexOf(58) != -1 || toCheck.indexOf(124) != -1) {
            throw new IOException("Invalid file or directory name");
        }
        if (toCheck.indexOf(42) != -1 || toCheck.indexOf("/") != -1 || toCheck.indexOf("\\") != -1) {
            throw new IllegalArgumentException("Argument passed has path specification");
        }
    }

    static {
        try {
            Jvm.loadSystemLibrary("javafile");
        }
        catch (Exception e) {
            FileLogger.ELog("Unable to load javafile native library");
        }
    }
}

