/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.file;

import com.nokia.mj.impl.file.FileAccessHelper;
import com.nokia.mj.impl.file.FileConnectionTexts;
import com.nokia.mj.impl.file.FileLogger;
import com.nokia.mj.impl.fileutils.DriveInfo;
import com.nokia.mj.impl.fileutils.DriveUtilities;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Tokenizer;
import java.util.Vector;

public final class FileSystemUtils {
    private static String iDefaultRoot;
    private static String iDefaultMemoryCard;
    private static String iDefaultTemporaryDrive;
    private static String iDefaultRomDrive;
    private static String iAppDomain;
    private static ApplicationInfo iAppInfo;

    public static String getProtectionDomain() {
        return iAppDomain;
    }

    public static Vector listRoots() {
        DriveInfo[] drives = DriveUtilities.getAccessibleDrives();
        Vector roots = new Vector();
        for (int index = 0; index < drives.length; ++index) {
            String toAdd = drives[index].iRootPath.replace('\\', '/');
            if (!FileAccessHelper.accessAllowed(toAdd, "read", FileSystemUtils.getProtectionDomain(), false)) continue;
            roots.addElement(toAdd);
        }
        return roots;
    }

    public static String getDefaultRoot() {
        return iDefaultRoot;
    }

    private static String getDefaultDrive() {
        String drive = FileSystemUtils._getDefaultRootPath();
        drive = drive.replace('\\', '/');
        return drive;
    }

    public static String getTemporaryDrive() {
        String drive = FileSystemUtils._getTemporaryDrivePath();
        drive = drive.replace('\\', '/');
        return drive;
    }

    public static String getRomDrive() {
        String drive = FileSystemUtils._getRomDrivePath();
        drive = drive.replace('\\', '/');
        return drive;
    }

    public static String getMemoryCardDrive() {
        String drive = FileSystemUtils._getMemoryCardDrivePath();
        drive = drive.replace('\\', '/');
        return drive;
    }

    private static boolean isDefaultRoot(String aRoot) {
        return aRoot.equalsIgnoreCase(iDefaultRoot);
    }

    private static boolean isTemporaryRoot(String aRoot) {
        return aRoot.equalsIgnoreCase(iDefaultTemporaryDrive);
    }

    private static boolean isRom(String aRoot) {
        return aRoot.equalsIgnoreCase(iDefaultRomDrive);
    }

    private static boolean isDefaultMemoryCardDrive(String aRoot) {
        return aRoot.equalsIgnoreCase(iDefaultMemoryCard);
    }

    private static String getRemoteDriveName(DriveInfo aDrive) {
        return FileConnectionTexts.get("remote_n_drive", new String[]{"" + aDrive.iRootPath.charAt(0)});
    }

    private static String getMemoryCardDriveName(DriveInfo aDrive) {
        return FileConnectionTexts.get("memorycard_n_drive", new String[]{"" + aDrive.iRootPath.charAt(0)});
    }

    private static String getInternalDriveName(DriveInfo aDrive) {
        return FileConnectionTexts.get("internal_n_drive", new String[]{"" + aDrive.iRootPath.charAt(0)});
    }

    private static String getLocalDriveName(DriveInfo aInfo) {
        String driveName = aInfo.iRootPath.replace('\\', '/');
        if (FileSystemUtils.isDefaultRoot(driveName)) {
            return FileConnectionTexts.get("c_drive");
        }
        if (FileSystemUtils.isTemporaryRoot(driveName)) {
            return FileConnectionTexts.get("d_drive");
        }
        if (FileSystemUtils.isRom(driveName)) {
            return FileConnectionTexts.get("z_drive");
        }
        return null;
    }

    public static Vector getRootNames() {
        DriveInfo[] drives = DriveUtilities.getAccessibleDrives();
        Vector roots = new Vector();
        for (int index = 0; index < drives.length; ++index) {
            String toAdd = drives[index].iRootPath.replace('\\', '/');
            if (!FileAccessHelper.accessAllowed(toAdd, "read", FileSystemUtils.getProtectionDomain(), false)) continue;
            roots.addElement(drives[index]);
        }
        Vector rootNames = new Vector();
        for (int index = 0; index < roots.size(); ++index) {
            DriveInfo info = (DriveInfo)roots.elementAt(index);
            String driveName = info.iRootPath.replace('\\', '/');
            String localName = null;
            if (!info.iIsLocal) {
                localName = FileSystemUtils.getRemoteDriveName(info);
            } else if (info.iIsRemovable) {
                localName = FileSystemUtils.isDefaultMemoryCardDrive(driveName) ? FileConnectionTexts.get("memorycard_name") : FileSystemUtils.getMemoryCardDriveName(info);
            } else {
                localName = FileSystemUtils.getLocalDriveName(info);
                if (localName == null) {
                    localName = FileSystemUtils.getInternalDriveName(info);
                }
            }
            rootNames.addElement(localName);
        }
        return rootNames;
    }

    public static String getPathOfProperty(int aValue) {
        return "file:///" + FileSystemUtils.getPathOfProperty(aValue, true);
    }

    public static String getPathOfProperty(int aValue, boolean addRoot) {
        String retValue = null;
        int value = aValue;
        retValue = FileSystemUtils._getPathOfProperty(value, true);
        FileLogger.Log("FileSystemUtils: GetPathOfProperty returned: " + retValue);
        retValue = retValue.replace('\\', '/');
        if (!addRoot) {
            retValue = retValue.substring(2);
        }
        return retValue;
    }

    public static String getLocalizedName(int value) {
        Object retValue = null;
        String propKey = null;
        switch (value) {
            case 2: {
                propKey = "graphics_name";
                break;
            }
            case 4: {
                propKey = "music_name";
                break;
            }
            case 0: {
                propKey = "photos_name";
                break;
            }
            case 5: {
                propKey = "recordings_name";
                break;
            }
            case 3: {
                propKey = "tones_name";
                break;
            }
            case 1: {
                propKey = "videos_name";
                break;
            }
            case 6: {
                propKey = "memorycard_name";
                break;
            }
            case 8: {
                propKey = "private_name";
                break;
            }
            default: {
                retValue = null;
            }
        }
        return FileConnectionTexts.get(propKey);
    }

    public static Vector getForbiddenPaths() {
        String pathString = FileSystemUtils._getForbiddenPaths();
        String[] pathArray = Tokenizer.split(pathString, "*");
        Vector paths = new Vector();
        for (int index = 0; index < pathArray.length - 1; ++index) {
            String toAdd = pathArray[index];
            toAdd = toAdd.replace('\\', '/');
            paths.addElement(toAdd);
        }
        return paths;
    }

    public static Vector getRestrictedPaths() {
        String pathString = FileSystemUtils._getRestrictedPaths();
        String[] pathArray = Tokenizer.split(pathString, "*");
        Vector paths = new Vector();
        for (int index = 0; index < pathArray.length - 1; ++index) {
            String toAdd = pathArray[index];
            toAdd = toAdd.replace('\\', '/');
            paths.addElement(toAdd);
        }
        return paths;
    }

    public static String getAppPrivateDir() {
        String appPrivateDir = iAppInfo.getRootPath();
        appPrivateDir = appPrivateDir.replace('\\', '/');
        appPrivateDir = appPrivateDir + "scratch/";
        return appPrivateDir;
    }

    private static native String _getMemoryCardDrivePath();

    private static native String _getTemporaryDrivePath();

    private static native String _getRomDrivePath();

    private static native String _getDefaultRootPath();

    private static native String _getPathOfProperty(int var0, boolean var1);

    private static native String _getForbiddenPaths();

    private static native String _getRestrictedPaths();

    static {
        try {
            Jvm.loadSystemLibrary("javafile");
        }
        catch (Exception e) {
            FileLogger.ELog("Unable to load javafile native library");
        }
        iDefaultRoot = FileSystemUtils.getDefaultDrive();
        iDefaultTemporaryDrive = FileSystemUtils.getTemporaryDrive();
        iDefaultRomDrive = FileSystemUtils.getRomDrive();
        iDefaultMemoryCard = FileSystemUtils.getMemoryCardDrive();
        iAppInfo = ApplicationInfo.getInstance();
        iAppDomain = iAppInfo.getProtectionDomain();
    }
}

