/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.fileutils.FileStreamHandler;
import java.io.IOException;
import java.io.OutputStream;

class FileOutputStream
extends OutputStream {
    private FileStreamHandler iDataSink;
    private final Object iCloseLock;
    private boolean iIsClosed;
    private byte[] iSingleByte;

    private FileOutputStream() {
        this.iCloseLock = null;
    }

    public FileOutputStream(FileStreamHandler aDataSink) {
        this.iDataSink = aDataSink;
        this.iCloseLock = new Object();
        this.iIsClosed = false;
        this.iSingleByte = new byte[1];
    }

    public void write(int aByte) throws IOException {
        this.iSingleByte[0] = (byte)(aByte & 0xFF);
        this.write(this.iSingleByte, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(byte[] aBytes, int aOffset, int aLength) throws IOException {
        Object object = this.iCloseLock;
        synchronized (object) {
            if (this.iIsClosed) {
                throw new IOException("OutputStream closed");
            }
            FileStreamHandler.checkIOParams(aBytes, aOffset, aLength);
            this.iDataSink.writeBytes(aBytes, aOffset, aLength);
        }
    }

    public synchronized void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.flush();
        Object object = this.iCloseLock;
        synchronized (object) {
            if (!this.iIsClosed) {
                this.iIsClosed = true;
                this.iDataSink.stopWrite();
                this.iDataSink = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isClosed() {
        Object object = this.iCloseLock;
        synchronized (object) {
            return this.iIsClosed;
        }
    }
}

