/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.fileutils;

import com.nokia.mj.impl.fileutils.FileInputStream;
import com.nokia.mj.impl.fileutils.FileOutputStream;
import com.nokia.mj.impl.rt.support.Finalizer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class FileStreamHandler {
    protected int iNativeHandle;
    protected FileInputStream iInputStream;
    protected FileOutputStream iOutputStream;
    protected DataInputStream iDataInputStream;
    protected DataOutputStream iDataOutputStream;
    protected final Object iCloseOperation;
    protected boolean iIsClosed;
    private Finalizer iFinalizer;

    private FileStreamHandler() {
        this.iCloseOperation = new Object();
    }

    protected FileStreamHandler(String aFileName) {
        this.iNativeHandle = this.createNativePeer(aFileName);
        this.iCloseOperation = new Object();
        this.iIsClosed = false;
        this.iFinalizer = this.registerFinalize();
    }

    protected int createNativePeer(String aFileName) {
        return this._createNativePeer(aFileName);
    }

    private Finalizer registerFinalize() {
        return new Finalizer(){

            public void finalizeImpl() {
                FileStreamHandler.this.doFinalize();
            }
        };
    }

    private synchronized void doFinalize() {
        this._dispose(this.iNativeHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopRead() {
        Object object = this.iCloseOperation;
        synchronized (object) {
            this._stopReading(this.iNativeHandle);
            this.closeInputStreams();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopWrite() {
        Object object = this.iCloseOperation;
        synchronized (object) {
            this.closeOutputStreams();
            this._stopWriting(this.iNativeHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream openInputStream() throws IOException {
        Object object = this.iCloseOperation;
        synchronized (object) {
            if (null != this.iInputStream) {
                throw new IOException("InputStream already open");
            }
            this.iInputStream = new FileInputStream(this);
        }
        return this.iInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataInputStream openDataInputStream() throws IOException {
        Object object = this.iCloseOperation;
        synchronized (object) {
            if (null != this.iDataInputStream) {
                throw new IOException("InputStream already open");
            }
            this.iDataInputStream = new DataInputStream(this.openInputStream());
        }
        return this.iDataInputStream;
    }

    protected synchronized int readBytes(byte[] aBuffer, int aOffset, int aLength) throws InterruptedIOException, IOException {
        return this._readData(this.iNativeHandle, aBuffer, aOffset, aLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeInputStreams() {
        Object object = this.iCloseOperation;
        synchronized (object) {
            try {
                if (this.iInputStream != null) {
                    this.iInputStream.close();
                    this.iInputStream = null;
                }
                if (this.iDataInputStream != null) {
                    this.iDataInputStream.close();
                    this.iDataInputStream = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream openOutputStream() throws IOException {
        Object object = this.iCloseOperation;
        synchronized (object) {
            if (null != this.iOutputStream) {
                throw new IOException("OutputStream already open");
            }
            this.iOutputStream = new FileOutputStream(this);
        }
        return this.iOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataOutputStream openDataOutputStream() throws IOException {
        Object object = this.iCloseOperation;
        synchronized (object) {
            if (null != this.iDataOutputStream) {
                throw new IOException("OutputStream already open");
            }
            this.iDataOutputStream = new DataOutputStream(this.openOutputStream());
        }
        return this.iDataOutputStream;
    }

    protected synchronized void writeBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        this._writeData(this.iNativeHandle, aBytes, aOffset, aLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOutputStreams() {
        Object object = this.iCloseOperation;
        synchronized (object) {
            try {
                if (this.iOutputStream != null) {
                    this.iOutputStream.close();
                    this.iOutputStream = null;
                }
                if (this.iDataOutputStream != null) {
                    this.iDataOutputStream.close();
                    this.iDataOutputStream = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void checkIOParams(byte[] aBytes, int aOffset, int aLength) {
        if (aOffset < 0 || aLength < 0 || aOffset + aLength > aBytes.length) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void closeFileStream() {
        this._closeFileStream(this.iNativeHandle);
    }

    protected void openFileForReading() {
        this._openFileForReading(this.iNativeHandle);
    }

    protected void openFileForWriting(long aOffset) {
        this._openFileForWriting(this.iNativeHandle, aOffset);
    }

    protected long skip(long aOffset) {
        return this._skip(this.iNativeHandle, aOffset);
    }

    protected long available() {
        return this._available(this.iNativeHandle);
    }

    private native long _available(int var1);

    private native long _skip(int var1, long var2);

    private native int _readData(int var1, byte[] var2, int var3, int var4);

    private native void _writeData(int var1, byte[] var2, int var3, int var4);

    private native void _closeFileStream(int var1);

    private native void _openFileForReading(int var1);

    private native void _openFileForWriting(int var1, long var2);

    private native void _dispose(int var1);

    private native void _stopReading(int var1);

    private native void _stopWriting(int var1);

    private native int _createNativePeer(String var1);
}

