/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf;

import com.nokia.mj.impl.security.common.PermissionBase;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import java.security.Permission;

public final class PushRegistryPermissionImpl
extends PermissionBase {
    public String mAction;
    public String mBtDeviceName = null;

    public PushRegistryPermissionImpl(String aName) {
        super(aName);
        this.mAction = "";
        this.mBtDeviceName = null;
    }

    public PushRegistryPermissionImpl(String aName, String action) {
        super(aName);
        this.mAction = action;
        this.mBtDeviceName = null;
    }

    public String getSecurityPromptQuestion() {
        if (this.mAction.equals("staticregistration")) {
            return SecurityPromptMessage.getInstance().getText("push_registration_static", null);
        }
        if (this.mAction.equals("dynamicregistration")) {
            return SecurityPromptMessage.getInstance().getText("push_registration_dynamic", null);
        }
        if (this.mAction.equals("autoinvocation")) {
            if (null == this.mBtDeviceName) {
                return SecurityPromptMessage.getInstance().getText("auto_invocation", null);
            }
            if (this.mBtDeviceName.equals("")) {
                return SecurityPromptMessage.getInstance().getText("auto_invocation", null);
            }
            return SecurityPromptMessage.getInstance().getText("bluetooth_usage", new String[]{this.mBtDeviceName});
        }
        return null;
    }

    public String getSecurityPromptAnswerOption(int aAnswerOption) {
        switch (aAnswerOption) {
            case 1: 
            case 2: 
            case 3: {
                return SecurityPromptMessage.getInstance().getText("prompt_allow", null);
            }
        }
        return null;
    }

    public boolean isSecurityPromptNeeed(int aInteractionMode) {
        return aInteractionMode != 2 || !this.mAction.equals("autoinvocation");
    }

    public String toString() {
        return "javax.microedition.io.PushRegistryPermission";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PushRegistryPermissionImpl)) {
            return false;
        }
        PushRegistryPermissionImpl tmpObj = (PushRegistryPermissionImpl)obj;
        return this.getName().equals(tmpObj.getName()) && PushRegistryPermissionImpl.matchActions(this.mAction, tmpObj.mAction);
    }

    public int hashCode() {
        return 0;
    }

    public String getActions() {
        return "";
    }

    public boolean implies(Permission p) {
        return p instanceof PushRegistryPermissionImpl;
    }
}

