/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.protocol.ssl;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.gcf.protocol.ssl.SSLPermissionImpl;
import com.nokia.mj.impl.gcf.utils.ConnectionBaseInterface;
import com.nokia.mj.impl.gcf.utils.UrlParser;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.ssl.SecureConnectionImpl;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;
import javax.microedition.io.Connection;

public class Protocol
implements ConnectionBaseInterface {
    public Connection openConnection(String aUri, int aMode, boolean aTimeouts) throws IOException {
        String temp;
        int equalindex;
        String apnstring = null;
        String urls = null;
        int apnid = -1;
        int index = -1;
        ConnectionManager cminstance = null;
        AccessPoint apn = null;
        String fullurl = "ssl:" + aUri;
        index = aUri.indexOf(";nokia_netid=");
        if (index != -1) {
            apnstring = aUri.substring(index);
            equalindex = apnstring.indexOf(61);
            if (equalindex != -1) {
                temp = apnstring.substring(equalindex + 1);
                try {
                    apnid = Integer.parseInt(temp);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid URL:  " + fullurl);
                }
            } else {
                throw new IllegalArgumentException("Invalid URL: " + fullurl);
            }
            urls = aUri.substring(0, index);
        } else {
            index = aUri.indexOf(";nokia_apnid=");
            if (index != -1) {
                apnstring = aUri.substring(index);
                equalindex = apnstring.indexOf(61);
                if (equalindex != -1) {
                    temp = apnstring.substring(equalindex + 1);
                    try {
                        apnid = Integer.parseInt(temp);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid URL: " + fullurl);
                    }
                } else {
                    throw new IllegalArgumentException("Invalid URL: " + fullurl);
                }
                urls = aUri.substring(0, index);
            } else {
                urls = aUri;
            }
        }
        Logger.LOG(14, 4, "http +openConnection -after removing nokia_apnid : " + urls);
        UrlParser sslUrl = new UrlParser("ssl", urls);
        Logger.LOG(14, 4, "secureconnection - protocol class : port = " + sslUrl.port);
        if (sslUrl.getPort() == 443 && ApplicationInfo.getInstance().getRuntimeType().equals("MIDP") && ApplicationInfo.getInstance().getProtectionDomain().equals("UTPD")) {
            Logger.LOG(14, 4, "Throwing security exception for restricted port");
            throw new SecurityException("Unable to open secure connection: port " + sslUrl.getPort() + " is restricted");
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        SSLPermissionImpl per = new SSLPermissionImpl("ssl://*");
        Logger.LOG(14, 4, "calling check permissions from protocol");
        appUtils.checkPermission(per);
        cminstance = ConnectionManager.getInstance();
        Logger.LOG(14, 4, "after getting ConnectionManager instance");
        try {
            Uid appSuite = ApplicationInfo.getInstance().getSuiteUid();
            try {
                apn = cminstance.getNetworkAccessPoint(appSuite, aUri);
            }
            catch (Exception e) {
                Logger.LOG(14, 4, "+secureconnection Protocol getNetworkAccessPoint threw Exception");
            }
            Logger.LOG(14, 4, "apn.getType = " + apn.getType() + " apn.getNapId= " + apn.getNapId());
        }
        catch (Exception e) {
            Logger.LOG(14, 4, "getSuiteUid exception ");
        }
        Logger.LOG(14, 4, "secure connection protocol.java");
        if (sslUrl.port == -1) {
            throw new IllegalArgumentException("Invalid URL: " + fullurl);
        }
        return new SecureConnectionImpl(sslUrl, aMode, -1, cminstance, apn);
    }

    public Connection openPrim(String aName, int aMode, boolean aTimeouts) throws IOException {
        return this.openConnection(aName, aMode, aTimeouts);
    }

    static {
        try {
            Jvm.loadSystemLibrary("javassl");
        }
        catch (Exception e) {
            Logger.LOG(14, 1, e.toString());
        }
    }
}

