/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.utils;

import com.nokia.mj.impl.gcf.utils.StreamConnectionBase;
import com.nokia.mj.impl.gcf.utils.StreamsLogger;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamBase
extends InputStream {
    protected boolean iIsClosed;
    protected StreamConnectionBase iStreamBase;
    protected final Object iCloseLock;
    protected final byte[] iSingleByte;
    protected final byte[] iBuffer;
    protected int iBufferLength;
    protected int iBufferOffset;
    private boolean iSupportMarkAndReset;
    private boolean iMarkSet;
    private int iMarkBufferTotal;
    private int iMarkBufferOffset;
    private byte[] iMarkBuffer = null;
    private boolean iDataPresentInMark;
    private final int iMarkNotSet = -2;

    InputStreamBase(StreamConnectionBase aEndPoint, Object aCloseLock) {
        this(aEndPoint, aCloseLock, false);
    }

    protected InputStreamBase(StreamConnectionBase aEndPoint, Object aCloseLock, boolean aSupportMarkAndReset) {
        StreamsLogger.Log(2, " +   InputStreamBase: Constructor:");
        this.iStreamBase = aEndPoint;
        this.iCloseLock = aCloseLock;
        this.iIsClosed = false;
        this.iSingleByte = new byte[1];
        this.iBuffer = new byte[this.iStreamBase.iBufferSize];
        this.iSupportMarkAndReset = aSupportMarkAndReset;
        this.iMarkBuffer = null;
        this.iMarkBufferOffset = -2;
        this.iMarkBufferTotal = -2;
        StreamsLogger.Log(2, " -   InputStreamBase: Constructor:");
    }

    public synchronized int available() throws IOException {
        StreamsLogger.Log(2, " +   InputStreamBase: available():");
        this.throwIfClosed();
        int retVal = 0;
        retVal = this.iBufferOffset < this.iBufferLength ? this.iBufferLength - this.iBufferOffset : this.iStreamBase.available();
        StreamsLogger.Log(2, " -   InputStreamBase: available(): Return: " + retVal);
        return retVal;
    }

    public synchronized int read() throws IOException {
        if (this.read(this.iSingleByte, 0, 1) == -1) {
            return -1;
        }
        return this.iSingleByte[0] & 0xFF;
    }

    public synchronized int read(byte[] aBytes, int aOffset, int aLength) throws IOException {
        StreamsLogger.Log(2, " +   InputStreamBase: read():  aOffset: " + aOffset + " aLength: " + aLength);
        this.throwIfClosed();
        StreamConnectionBase.checkIOParams(aBytes, aOffset, aLength);
        if (aLength == 0) {
            StreamsLogger.Log(2, " -   InputStreamBase: read()");
            return 0;
        }
        int retValue = this.checkMarkAndResetCase(aBytes, aOffset, aLength);
        if (-1 == retValue || -2 != retValue) {
            StreamsLogger.Log(2, " -   InputStreamBase: read(): return: " + retValue);
            return retValue;
        }
        StreamsLogger.Log(2, " -   InputStreamBase: read(): calling fillBytes");
        return this.fillBytes(aBytes, aOffset, aLength);
    }

    protected synchronized int fillBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        int bytesRead = 0;
        while (aLength > 0) {
            int numRead = this.readFromStreamBase(aBytes, aOffset, aLength);
            if (numRead <= 0) {
                if (bytesRead != 0) break;
                return -1;
            }
            bytesRead += numRead;
            aOffset += numRead;
            aLength -= numRead;
        }
        return bytesRead;
    }

    protected synchronized int readFromStreamBase(byte[] aBytes, int aOffset, int aLength) throws IOException {
        if (aLength == 0) {
            return 0;
        }
        if (this.iBufferLength == this.iBufferOffset) {
            StreamsLogger.Log(2, "     InputStreamBase: readFromStreamBase(): Calling readBytes");
            this.iBufferLength = this.iStreamBase.readBytes(this.iBuffer);
            this.iBufferOffset = 0;
        }
        if (this.iBufferLength == -1) {
            return -1;
        }
        int nBytes = this.iBufferOffset + aLength <= this.iBufferLength ? aLength : this.iBufferLength - this.iBufferOffset;
        System.arraycopy((Object)this.iBuffer, this.iBufferOffset, (Object)aBytes, aOffset, nBytes);
        this.iBufferOffset += nBytes;
        return nBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        StreamsLogger.Log(2, " +   InputStreamBase: Close()");
        Object object = this.iCloseLock;
        synchronized (object) {
            if (!this.iIsClosed) {
                this.iIsClosed = true;
                this.iStreamBase.cancelRead();
                this.iStreamBase = null;
            }
        }
        StreamsLogger.Log(2, " -   InputStreamBase: Close()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClosed() {
        Object object = this.iCloseLock;
        synchronized (object) {
            return this.iIsClosed;
        }
    }

    protected synchronized void throwIfClosed() throws IOException {
        if (this.iIsClosed) {
            throw new IOException("InputStream closed");
        }
    }

    public boolean markSupported() {
        return this.iSupportMarkAndReset;
    }

    public synchronized void mark(int aReadLimit) {
        StreamsLogger.Log(2, " +   InputStreamBase: mark( " + aReadLimit + " )");
        if (!this.iSupportMarkAndReset || aReadLimit <= 0) {
            StreamsLogger.Log(2, " -   InputStreamBase: mark()");
            return;
        }
        if (this.iDataPresentInMark || this.iMarkSet) {
            StreamsLogger.Log(3, "     InputStreamBase: mark(): Mark Recalled");
            byte[] tempArray = null;
            if (aReadLimit >= this.iMarkBuffer.length) {
                StreamsLogger.Log(3, "     InputStreamBase: mark(): New mark limit > previous one. Creating fresh buffer.");
                tempArray = new byte[aReadLimit];
            } else {
                StreamsLogger.Log(3, "     InputStreamBase: mark(): New mark limit < previous one.");
                StreamsLogger.Log(3, "     InputStreamBase: mark(): Total Present: " + this.iMarkBufferTotal + " Buffer Offset: " + this.iMarkBufferOffset);
                int unreadBytes = this.iMarkBufferTotal - this.iMarkBufferOffset;
                int bufferSize = Math.max(unreadBytes, aReadLimit);
                tempArray = new byte[bufferSize];
                StreamsLogger.Log(3, "     InputStreamBase: mark(): Created buffer of " + bufferSize + " bytes");
            }
            System.arraycopy((Object)this.iMarkBuffer, this.iMarkBufferOffset, (Object)tempArray, 0, this.iMarkBufferTotal - this.iMarkBufferOffset);
            this.iDataPresentInMark = false;
            StreamsLogger.Log(3, "     InputStreamBase: mark(): From Offset: " + this.iMarkBufferOffset + " to " + this.iMarkBufferTotal);
            this.iMarkSet = true;
            this.iMarkBuffer = tempArray;
            this.iMarkBufferTotal -= this.iMarkBufferOffset;
            this.iMarkBufferOffset = 0;
        } else {
            StreamsLogger.Log(3, "     InputStreamBase: mark(): Mark called first time");
            this.iMarkBuffer = new byte[aReadLimit];
            this.iMarkBufferTotal = 0;
            this.iMarkBufferOffset = 0;
            this.iMarkSet = true;
            this.iDataPresentInMark = false;
        }
        StreamsLogger.Log(2, " -    InputStreamBase: mark(): Values:  Buffer Length: " + this.iMarkBuffer.length + " Buffer Offset: " + this.iMarkBufferOffset + " Total Present: " + this.iMarkBufferTotal + " Data Present?: " + this.iDataPresentInMark);
    }

    public synchronized void reset() throws IOException {
        StreamsLogger.Log(2, " +    InputStreamBase: reset(): Mark Set? " + this.iMarkSet);
        if (!this.iMarkSet) {
            throw new IOException("Point of the mark operation is invalid");
        }
        StreamsLogger.Log(2, " -    InputStreamBase: reset()");
        this.iMarkBufferOffset = 0;
    }

    private int checkMarkAndResetCase(byte[] aBytes, int aOffset, int aLength) throws IOException {
        StreamsLogger.Log(3, " +   InputStreamBase: checkMarkAndResetCase()");
        if (!this.iMarkSet) {
            StreamsLogger.Log(3, " -   InputStreamBase: checkMarkAndResetCase(): Mark not valid");
            return -2;
        }
        StreamsLogger.Log(3, "     InputStreamBase: checkMarkAndResetCase(): Values:  iMarkSet: " + this.iMarkSet + " iDataPresentInMark: " + this.iDataPresentInMark + " iMarkBufferOffset: " + this.iMarkBufferOffset + " iMarkBufferTotal: " + this.iMarkBufferTotal + " iMarkBufferLength: " + this.iMarkBuffer.length);
        if (!this.iDataPresentInMark) {
            StreamsLogger.Log(3, "     InputStreamBase: checkMarkAndResetCase(): Less data present");
            int retVal = this.fillBytes(this.iMarkBuffer, this.iMarkBufferTotal, this.iMarkBuffer.length - this.iMarkBufferTotal);
            if (retVal == -1) {
                return -1;
            }
            this.iMarkBufferTotal += retVal;
            this.iDataPresentInMark = true;
        }
        if (this.iMarkBufferOffset == this.iMarkBufferTotal) {
            StreamsLogger.Log(3, "     InputStreamBase: checkMarkAndResetCase(): reached end of buffer");
            return -2;
        }
        if (this.iMarkBufferOffset + aLength > this.iMarkBufferTotal) {
            StreamsLogger.Log(3, "     InputStreamBase: checkMarkAndResetCase(): Data asked is more than data present");
            int dataToCopy = this.iMarkBufferTotal - this.iMarkBufferOffset;
            System.arraycopy((Object)this.iMarkBuffer, this.iMarkBufferOffset, (Object)aBytes, aOffset, dataToCopy);
            this.iMarkBufferOffset += dataToCopy;
            int retVal = this.fillBytes(aBytes, aOffset + dataToCopy, aLength - dataToCopy);
            if (retVal == -1) {
                retVal = 0;
            }
            StreamsLogger.Log(3, "     InputStreamBase: checkMarkAndResetCase(): Fillbytes return: " + retVal + " MarkBufferOffset: " + this.iMarkBufferOffset + " iMarkBufferTotal: " + this.iMarkBufferTotal);
            if (retVal + this.iMarkBufferOffset > this.iMarkBuffer.length) {
                StreamsLogger.Log(3, "     InputStreamBase: checkMarkAndResetCase(): mark now invalid");
                this.iMarkBufferTotal = 0;
                this.iMarkBufferOffset = 0;
                this.iMarkSet = false;
                this.iMarkBuffer = null;
                this.iDataPresentInMark = false;
            }
            StreamsLogger.Log(2, " -   InputStreamBase: checkMarkAndResetCase(): Values:  iMarkSet: " + this.iMarkSet + " iDataPresentInMark: " + this.iDataPresentInMark + " iMarkBufferOffset: " + this.iMarkBufferOffset + " iMarkBufferTotal: " + this.iMarkBufferTotal);
            return retVal + dataToCopy;
        }
        if (this.iMarkBufferOffset + aLength <= this.iMarkBufferTotal) {
            StreamsLogger.Log(3, "     InputStreamBase: checkMarkAndResetCase(): Requested > total");
            System.arraycopy((Object)this.iMarkBuffer, this.iMarkBufferOffset, (Object)aBytes, aOffset, aLength);
            this.iMarkBufferOffset += aLength;
            StreamsLogger.Log(3, " -   InputStreamBase: checkMarkAndResetCase(): Values: iMarkSet: " + this.iMarkSet + " iDataPresentInMark: " + this.iDataPresentInMark + " iMarkBufferOffset: " + this.iMarkBufferOffset + " iMarkBufferTotal: " + this.iMarkBufferTotal);
            return aLength;
        }
        StreamsLogger.Log(3, " -   InputStreamBase: checkMarkAndResetCase()");
        return 0;
    }
}

