/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.http;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.gcf.utils.DateUtil;
import com.nokia.mj.impl.gcf.utils.NativeError;
import com.nokia.mj.impl.gcf.utils.URI;
import com.nokia.mj.impl.http.BlockingOperation;
import com.nokia.mj.impl.http.NativeHttpByteSource;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import com.nokia.mj.impl.utils.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.HttpConnection;

public class HttpConnectionNative
implements HttpConnection,
NativeHttpByteSource {
    protected int iMode;
    protected int iState;
    protected boolean iClosed;
    protected URI iUri;
    protected String iRef;
    protected String iRequestMethod;
    protected Hashtable iRequestProperties;
    protected int iResponseCode;
    protected String iResponseMessage;
    protected Hashtable iReplyHeaders;
    protected Vector iReplyHeaderKeys;
    protected long iLength;
    protected DataInputStream iInputStream;
    protected boolean iInputStreamOpened = false;
    protected NativeHttpInputStream iNativeHttpInputStream;
    protected ByteArrayOutputStream iPostedDataStream;
    protected DataOutputStream iOutputStream;
    protected boolean iOutputStreamOpened = false;
    protected char[] iLineBuffer;
    protected int iLineBufferLength;
    protected int iLineLength;
    protected static final int INVALID_STATE = 0;
    protected static final int SETUP = 1;
    protected static final int CONNECTED = 2;
    protected static final int REQUEST_HEADERS_SENT = 3;
    protected static final int REQUEST_SENT = 4;
    protected static final int REPLY_RECEIVED = 5;
    protected static final char HASH = '#';
    protected static final int QUESTION_MARK = 63;
    protected static final int CR = 13;
    protected static final int LF = 10;
    protected static final int SP = 32;
    protected static final int EOF = -1;
    protected static final byte[] CRLF = new byte[]{13, 10};
    protected static final int DEFAULT_LINE_BUFFER_SIZE = 128;
    protected static final String VERSION_1_1 = "1.1";
    protected static final String VERSION_1_0 = "1.0";
    protected static final String NATIVESEPERATOR = ";;";
    protected static final String DEFAULT_PATH = "/";
    protected static final int DEFAULT_PORT = 80;
    protected static final String PROTOCOL_SUFFIX = "://";
    protected static final String CONNECTION = "Connection";
    protected static final String CONTENT_ENCODING = "Content-Encoding";
    protected static final String CONTENT_LENGTH = "Content-Length";
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String DATE = "Date";
    protected static final String HOST = "Host";
    protected static final String LAST_MODIFIED = "Last-Modified";
    protected static final String EXPIRES = "Expires";
    protected static final String TRANSFER_ENCODING = "Transfer-Encoding";
    protected static final String USER_AGENT = "User-Agent";
    protected static final String UNTRUSTED_1_0 = "UNTRUSTED/1.0";
    protected static final String CLOSE = "close";
    private static int iNativeHttpSessionHandle = 0;
    protected int iNativeTransactionHande = 0;
    final BlockingOperation iTransactionBlock;
    protected final BlockingOperation iNativeDataReadyForRead;
    private Finalizer iFinalizer;
    protected ConnectionManager iCmInstance = null;
    protected AccessPoint iApn = null;
    private static boolean iIsSessionDeleted = false;
    private boolean iTrustedSuite = true;

    public HttpConnectionNative(int aNativeHttpSessionHandle, String aName, int aMode, boolean aTimeouts, ConnectionManager cm, AccessPoint apnInfo) throws IOException {
        String agent;
        Logger.LOG(14, 4, "+++++ HttpConnectionNative new, aName = " + aName + "this =" + this);
        this.iCmInstance = cm;
        this.iApn = apnInfo;
        int index = aName.indexOf(35);
        if (iNativeHttpSessionHandle == 0) {
            this.creatHttpSession();
        }
        if (index != -1) {
            this.iRef = aName.substring(index + 1);
            aName = aName.substring(0, index);
        }
        this.iUri = new URI(aName);
        String host = this.iUri.getHost();
        if (host == null || host.equals("")) {
            throw new IllegalArgumentException("Invalid url: " + aName);
        }
        this.iMode = aMode;
        this.iState = 1;
        this.iRequestMethod = "GET";
        this.iRequestProperties = new Hashtable();
        this.iReplyHeaders = new Hashtable();
        this.iReplyHeaderKeys = new Vector();
        this.iLength = -1L;
        this.iTransactionBlock = new BlockingOperation();
        this.iNativeDataReadyForRead = new BlockingOperation();
        this.iNativeDataReadyForRead.setResult(Integer.MAX_VALUE);
        this.iFinalizer = this.registerForFinalization();
        this.setShutdownListener();
        Logger.LOG(14, 4, "- HttpConnectionNative new ");
        if (ApplicationInfo.getInstance().getProtectionDomain().equals("UTPD")) {
            this.iTrustedSuite = false;
            this.iRequestProperties.put(USER_AGENT, UNTRUSTED_1_0);
        }
        if ((agent = this._getUserAgentHeaderValue()) != null) {
            if (!this.iTrustedSuite) {
                String result = agent + ' ' + UNTRUSTED_1_0;
                this.iRequestProperties.put(USER_AGENT, result);
            } else {
                this.iRequestProperties.put(USER_AGENT, agent);
            }
        }
    }

    Finalizer registerForFinalization() {
        Logger.LOG(14, 4, "++HttpConnectionNative::registerForFinalization ");
        return new Finalizer(){

            public void finalizeImpl() {
                HttpConnectionNative.this.doFinalize();
            }
        };
    }

    private void setShutdownListener() {
        if (iIsSessionDeleted) {
            return;
        }
        iIsSessionDeleted = true;
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                Logger.LOG(14, 4, "++HttpConnectionNative::shuttingDown ,this = " + this);
                try {
                    HttpConnectionNative.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (iNativeHttpSessionHandle != 0) {
                    HttpConnectionNative.this._dispose(iNativeHttpSessionHandle);
                    iNativeHttpSessionHandle = 0;
                }
            }
        });
    }

    public void doFinalize() {
        Logger.LOG(14, 4, "++HttpConnectionNative::doFinalize ");
        if (iIsSessionDeleted) {
            return;
        }
        iIsSessionDeleted = true;
        if (iNativeHttpSessionHandle != 0) {
            this._dispose(iNativeHttpSessionHandle);
            iNativeHttpSessionHandle = 0;
        }
        Logger.LOG(14, 4, "--HttpConnectionNative::doFinalize ");
    }

    public void creatHttpSession() throws IOException {
        Logger.LOG(14, 4, "++HttpConnectionNative::creatHttpSession()");
        int[] retval = new int[2];
        int handle = this.iApn != null ? this._createHttpSession(0, this.iApn.getType(), this.iApn.getNapId(), retval) : this._createHttpSession(0, -1, -1, retval);
        iNativeHttpSessionHandle = NativeError.check(handle);
        if (retval[0] < 0) {
            throw new IOException("Unable to open http connection.Creation of Native peer failed.");
        }
        if (retval[1] < 0) {
            this.iCmInstance.reset();
        }
        Logger.LOG(14, 4, "--HttpConnectionNative::creatHttpSession()");
    }

    public synchronized void close() throws IOException {
        Logger.LOG(14, 4, "++++++++++ close()");
        if (this.iClosed) {
            return;
        }
        this.iClosed = true;
        if (this.iInputStream == null && this.iOutputStream == null && this.iState != 1) {
            if (this.iNativeHttpInputStream != null) {
                this.iNativeHttpInputStream.close();
                this.iNativeHttpInputStream = null;
            }
            this.closeConnection();
        }
        Logger.LOG(14, 4, "------- close()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DataInputStream openDataInputStream() throws IOException {
        Logger.LOG(14, 4, "+ openDataInputStream()");
        Object object = this.iNativeDataReadyForRead.getLock();
        synchronized (object) {
            this.ensureOpen("openDataInputStream");
            if (this.iInputStreamOpened) {
                this.throwIOException("Input stream is already opened");
            }
            this.ensureResponse();
            this.iInputStream = this.makeDataInputStream();
            this.iInputStreamOpened = true;
            return this.iInputStream;
        }
    }

    public synchronized InputStream openInputStream() throws IOException {
        DataInputStream result = this.openDataInputStream();
        return result;
    }

    public synchronized DataOutputStream openDataOutputStream() throws IOException {
        this.ensureOpen("openDataOutputStream");
        if (this.iOutputStreamOpened) {
            this.throwIOException("Output stream is already opened");
        }
        this.makeDataOutputStream();
        this.iOutputStreamOpened = true;
        return this.iOutputStream;
    }

    public synchronized OutputStream openOutputStream() throws IOException {
        DataOutputStream result = this.openDataOutputStream();
        return result;
    }

    public synchronized String getEncoding() {
        String result = null;
        try {
            result = this.getHeaderField(CONTENT_ENCODING);
        }
        catch (IOException ex) {
            return null;
        }
        return result;
    }

    public synchronized long getLength() {
        Logger.LOG(14, 4, "+ getLength()");
        try {
            this.ensureOpen("getLength");
            this.ensureResponse();
            return this.iLength;
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public synchronized String getType() {
        String result = null;
        try {
            result = this.getHeaderField(CONTENT_TYPE);
        }
        catch (IOException ex) {
            return null;
        }
        return result;
    }

    public synchronized long getDate() throws IOException {
        long result = this.getHeaderFieldDate(DATE, 0L);
        return result;
    }

    public synchronized long getExpiration() throws IOException {
        long result = this.getHeaderFieldDate(EXPIRES, 0L);
        return result;
    }

    public String getFile() {
        String result = this.iUri.getPath();
        result = result.length() == 0 ? null : DEFAULT_PATH + result;
        return result;
    }

    public synchronized String getHeaderField(int aIndex) throws IOException {
        this.ensureOpen("getHeaderField");
        this.ensureResponse();
        if (aIndex >= this.iReplyHeaderKeys.size() || aIndex < 0) {
            return null;
        }
        String result = (String)this.iReplyHeaders.get(this.iReplyHeaderKeys.elementAt(aIndex));
        if (result != null) {
            int length = result.length();
            String keys = (String)this.iReplyHeaderKeys.elementAt(aIndex);
            if (keys.equalsIgnoreCase("Set-Cookie")) {
                if (result.charAt(0) == ',') {
                    throw new IOException("cookie size too large - hence discarded");
                }
                if (result.charAt(length - 2) == ',') {
                    throw new IOException("cookie size too large - hence discarded");
                }
                int index = result.indexOf(", ,", 0);
                if (index != -1) {
                    throw new IOException("cookie size too large - hence discarded");
                }
            }
        }
        return result;
    }

    public synchronized String getHeaderField(String aName) throws IOException {
        this.ensureOpen("getHeaderField");
        this.ensureResponse();
        if (aName == null) {
            return null;
        }
        String result = (String)this.iReplyHeaders.get(aName.toLowerCase());
        Logger.LOG(14, 4, "+ getHeaderField(String): " + result);
        if (result != null) {
            int length = result.length();
            if (aName.equalsIgnoreCase("Set-Cookie")) {
                if (result.charAt(0) == ',') {
                    throw new IOException("cookie size too large - hence discarded");
                }
                if (result.charAt(length - 2) == ',') {
                    throw new IOException("cookie size too large - hence discarded");
                }
                int index = result.indexOf(", ,", 0);
                if (index != -1) {
                    throw new IOException("cookie size too large - hence discarded");
                }
            }
        }
        return result;
    }

    public synchronized long getHeaderFieldDate(String aName, long aDfault) throws IOException {
        Logger.LOG(14, 4, "+ getHeaderFieldDate(String, long)");
        String value = this.getHeaderField(aName);
        if (value != null) {
            long result = this.parseDate(value);
            Logger.LOG(14, 4, "- getHeaderFieldDate(String, long)");
            return result;
        }
        Logger.LOG(14, 4, "- getHeaderFieldDate(String, long) return aDfault");
        return aDfault;
    }

    public synchronized int getHeaderFieldInt(String aName, int aDfault) throws IOException {
        Logger.LOG(14, 4, "+ getHeaderFieldInt(String, int) , name = " + aName + "default = " + aDfault);
        String value = this.getHeaderField(aName);
        if (value == null) {
            Logger.LOG(14, 4, "- getHeaderFieldInt(String, int) returns aDfault");
            return aDfault;
        }
        try {
            int result = Integer.parseInt(value);
            return result;
        }
        catch (NumberFormatException nfe) {
            return aDfault;
        }
    }

    public synchronized String getHeaderFieldKey(int aIndex) throws IOException {
        this.ensureOpen("getHeaderFieldKey");
        this.ensureResponse();
        if (aIndex >= this.iReplyHeaderKeys.size() || aIndex < 0) {
            return null;
        }
        String result = (String)this.iReplyHeaderKeys.elementAt(aIndex);
        return result;
    }

    public String getHost() {
        String result = this.iUri.getHost();
        return result;
    }

    public synchronized long getLastModified() throws IOException {
        long result = this.getHeaderFieldDate(LAST_MODIFIED, 0L);
        return result;
    }

    public int getPort() {
        String temp = this.iUri.getPort();
        if (temp.length() != 0) {
            try {
                int result = Integer.parseInt(temp);
                return result;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 80;
    }

    public String getProtocol() {
        String result = this.iUri.getProtocol();
        return result;
    }

    public String getQuery() {
        String result = this.iUri.getQuery();
        if (result.length() == 0) {
            result = null;
        }
        return result;
    }

    public String getRef() {
        return this.iRef;
    }

    public final String getRequestMethod() {
        return this.iRequestMethod;
    }

    public final String getRequestProperty(String aKey) {
        String result = (String)this.iRequestProperties.get(aKey);
        return result;
    }

    public final synchronized int getResponseCode() throws IOException {
        Logger.LOG(14, 4, "+ getResponseCode()");
        this.ensureOpen("getResponseCode");
        this.ensureResponse();
        Logger.LOG(14, 4, "- getResponseCode() : " + this.iResponseCode);
        return this.iResponseCode;
    }

    public synchronized String getResponseMessage() throws IOException {
        this.ensureOpen("getResponseMessage");
        this.ensureResponse();
        return this.iResponseMessage;
    }

    public String getURL() {
        String result = this.iUri.toString();
        return result;
    }

    public synchronized void setRequestMethod(String aMethod) throws IOException {
        try {
            if (aMethod == null) {
                throw new NullPointerException("Request method is null");
            }
            this.ensureOpen("setRequestMethod");
            if (this.iState != 1) {
                this.throwIOException("setRequestMethod method failed.Connection state is already connected");
            }
            if (!("GET".equals(aMethod) || "HEAD".equals(aMethod) || "POST".equals(aMethod))) {
                this.throwIOException("Invalid or Unsupported request method: " + aMethod);
            }
            if (this.iPostedDataStream == null) {
                this.iRequestMethod = aMethod;
            }
        }
        catch (IOException ex) {
            Logger.LOG(14, 2, "- setRequestMethod(String): Throwing exception" + ex);
            throw ex;
        }
    }

    public synchronized void setRequestProperty(String aKey, String aValue) throws IOException {
        this.ensureOpen("setRequestProperty");
        if (this.iState != 1) {
            this.throwIOException("setRequestProperty method failed.Connection state is already connected");
        }
        if (this.iPostedDataStream == null) {
            if (aKey.equals(USER_AGENT) && !this.iTrustedSuite) {
                String val = aValue + ' ' + UNTRUSTED_1_0;
                this.iRequestProperties.put(aKey, val);
            } else {
                this.iRequestProperties.put(aKey, aValue);
            }
        }
    }

    protected void closeConnection() throws IOException {
        Logger.LOG(14, 4, "++++++++++++++ Java closeConnection()");
        if (this.iNativeTransactionHande != 0) {
            Logger.LOG(14, 4, "########## Valid handle");
            this._closeTransaction(this.iNativeTransactionHande);
            this.iNativeTransactionHande = 0;
        }
        Logger.LOG(14, 4, "-------------- Java closeConnection()");
    }

    protected void addHeader(String aKey, String aValue) {
        aKey = aKey.toLowerCase();
        this.iReplyHeaders.put(aKey, aValue);
        this.iReplyHeaderKeys.addElement(aKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void inputStreamClosed() throws IOException {
        Logger.LOG(14, 4, "++++++ inputStreamClosed()");
        Object object = this.iNativeDataReadyForRead.getLock();
        synchronized (object) {
            this.iInputStream = null;
            this.iNativeHttpInputStream = null;
            if (this.iClosed && this.iOutputStream == null) {
                this.closeConnection();
            }
        }
        Logger.LOG(14, 4, "-------- inputStreamClosed()");
    }

    protected synchronized void outputStreamFlushed() throws IOException {
        switch (this.iState) {
            case 1: 
            case 2: 
            case 3: {
                this.ensureResponse();
            }
        }
    }

    protected synchronized void outputStreamClosed() throws IOException {
        Logger.LOG(14, 4, "++++++++ outputStreamClosed()");
        this.iOutputStream = null;
        this.iPostedDataStream = null;
        if (this.iClosed && this.iInputStream == null) {
            this.closeConnection();
        }
        Logger.LOG(14, 4, "-------- outputStreamClosed()");
    }

    private synchronized void connect() throws IOException {
        Logger.LOG(14, 4, "+++++++ Java connect()");
        if (this.iNativeTransactionHande <= 0) {
            int handle = this._createNativeTransaction(iNativeHttpSessionHandle, this.iUri.toString(), this.iRequestMethod);
            this.iNativeTransactionHande = NativeError.check(handle);
        }
        Logger.LOG(14, 4, "-------- connect()");
    }

    protected void ensureConnected() throws IOException {
        switch (this.iState) {
            case 1: {
                this.connect();
                this.iState = 2;
                break;
            }
        }
    }

    protected void ensureOpen(String aMethodName) throws IOException {
        if (this.iClosed) {
            this.throwIOException(aMethodName + " method failed.Connection state is already closed");
        }
    }

    protected void ensureResponse() throws IOException {
        this.ensureConnected();
        switch (this.iState) {
            case 2: {
                this.sendRequest();
            }
            case 3: 
            case 4: {
                this.getResponse();
                this.iState = 5;
                break;
            }
        }
    }

    protected synchronized void getResponse() throws IOException {
        Logger.LOG(14, 4, "+ getResponse()");
        boolean flag = true;
        String[] rawHeaders = this._getResponse(this.iNativeTransactionHande);
        if (rawHeaders == null || rawHeaders.length == 0) {
            this.throwIOException("Invalid http response");
        }
        this.readStatusLine(rawHeaders[0]);
        this.readHeaders(rawHeaders);
        this.processReplyHeaders();
        rawHeaders = null;
    }

    protected void readStatusLine(String aStatusLine) throws IOException {
        String parse;
        Logger.LOG(14, 4, "+ readStatusLine: " + aStatusLine);
        int fisrtSepIndex = aStatusLine.indexOf(NATIVESEPERATOR);
        if (fisrtSepIndex <= 0) {
            this.throwIOException("Invalid http response");
        }
        if ((parse = aStatusLine.substring(0, fisrtSepIndex)).compareTo(VERSION_1_1) != 0 && parse.compareTo(VERSION_1_0) != 0) {
            this.throwIOException("Invalid http response.Http-version mismatch");
        }
        int nextSepIndex = 0;
        nextSepIndex = aStatusLine.indexOf(NATIVESEPERATOR, fisrtSepIndex + 2);
        if (nextSepIndex <= 0) {
            this.throwIOException("Invalid http response");
        }
        parse = null;
        parse = aStatusLine.substring(fisrtSepIndex + 2, nextSepIndex);
        this.iResponseCode = Integer.parseInt(parse);
        this.iResponseMessage = aStatusLine.substring(nextSepIndex + 2, aStatusLine.length());
        if (this.iResponseMessage.length() <= 0) {
            this.throwIOException("Invalid http response");
        }
    }

    protected long parseDate(String aDateString) {
        long result = DateUtil.epocDifference(aDateString);
        return result;
    }

    protected void processReplyHeaders() {
        String value = (String)this.iReplyHeaders.get(CONTENT_LENGTH.toLowerCase());
        if (value != null) {
            this.iLength = Long.parseLong(value);
        }
    }

    protected void readHeaders(String[] aHeaders) throws IOException {
        String rawHeader = null;
        int headersCount = aHeaders.length;
        int sepIndex = -1;
        for (int ii = 1; ii < headersCount; ++ii) {
            rawHeader = aHeaders[ii];
            sepIndex = rawHeader.indexOf(NATIVESEPERATOR);
            String key = rawHeader.substring(0, sepIndex);
            String value = rawHeader.substring(sepIndex + 2, rawHeader.length());
            this.addHeader(key, value);
            rawHeader = null;
            key = null;
            value = null;
            sepIndex = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sendRequest() throws IOException {
        int count;
        this.ensureConnected();
        int headerCount = count = this.iRequestProperties.size();
        Enumeration keyEnum = this.iRequestProperties.keys();
        String[] headers = null;
        if (headerCount > 0) {
            headers = new String[headerCount];
        }
        String valueKey = null;
        String property = null;
        String concat = null;
        boolean untrustedAdded = false;
        for (int ii = 0; ii < count; ++ii) {
            valueKey = (String)keyEnum.nextElement();
            property = this.getRequestProperty(valueKey);
            headers[ii] = concat = valueKey + NATIVESEPERATOR + property;
        }
        byte[] postData = null;
        int postDataLength = 0;
        if (this.iPostedDataStream != null) {
            postData = this.iPostedDataStream.toByteArray();
            postDataLength = postData.length;
        }
        Object object = this.iTransactionBlock.getLock();
        synchronized (object) {
            BlockingOperation blockingOperation = this.iTransactionBlock;
            synchronized (blockingOperation) {
                Logger.LOG(14, 4, "before _submitTransaction ");
                int err = this._submitTransaction(this.iNativeTransactionHande, headers, postData, postDataLength);
                Logger.LOG(14, 4, "-_submitTransaction +err " + err);
                postData = null;
                headers = null;
                if (err != 0) {
                    this.throwIOException("Unable to connect to server.Symbian os error code: " + err);
                }
                this.iState = 4;
                this.waitForTransaction();
                Logger.LOG(14, 4, "- sendRequest _submitTransaction");
            }
        }
    }

    protected void throwIOException(String aMessage) throws IOException {
        throw new IOException(aMessage);
    }

    protected void waitForTransaction() throws IOException {
        Logger.LOG(14, 4, "+waitForTransaction");
        this.iTransactionBlock.waitForCompletion();
        int result = this.iTransactionBlock.getResult();
        Logger.LOG(14, 4, "waitForTransaction result :" + result);
        if (result < 0) {
            Integer error = new Integer(result);
            this.throwIOException(error.toString());
        }
        Logger.LOG(14, 4, "-waitForTransaction");
    }

    protected DataInputStream makeDataInputStream() throws IOException {
        Logger.LOG(14, 4, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> makeDataInputStream()<<<<<<<<<<<<<<<<<<<<<<<");
        PlainDataInputStream result = null;
        int bytesTotal = (int)this.getLength();
        Logger.LOG(14, 4, "++++++ makeDataInputStream()  getLength():" + bytesTotal);
        if (this.iNativeHttpInputStream == null) {
            this.iNativeHttpInputStream = new NativeHttpInputStream(this);
        }
        result = new PlainDataInputStream(this.iNativeHttpInputStream);
        Logger.LOG(14, 4, " makeDataInputStream()");
        return result;
    }

    protected void makeDataOutputStream() throws IOException {
        this.iPostedDataStream = new ByteArrayOutputStream();
        this.iOutputStream = new PlainDataOutputStream(this.iPostedDataStream);
    }

    public void closeByteSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getBytes(byte[] aBytes, int aLength) throws IOException {
        Logger.LOG(14, 4, "+getBytes()");
        int result = -1;
        Object object = this.iNativeDataReadyForRead.getLock();
        synchronized (object) {
            BlockingOperation blockingOperation = this.iNativeDataReadyForRead;
            synchronized (blockingOperation) {
                if (this.iNativeDataReadyForRead.getResult() == Integer.MAX_VALUE) {
                    Logger.LOG(14, 4, "+ getBytes()- ReadOperation.waitForCompletion()");
                    this.iNativeDataReadyForRead.waitForCompletion();
                    Logger.LOG(14, 4, "- getBytes()- ReadOperation.waitForCompletion()");
                }
            }
            int callBackResult = this.iNativeDataReadyForRead.getResult();
            if (callBackResult == -1) {
                return 0;
            }
            if (callBackResult < 0) {
                this.throwIOException("Unable to read http response.Symbian os error code: " + result);
            }
            this.iNativeDataReadyForRead.setResult(Integer.MAX_VALUE);
            result = this._getBytes(this.iNativeTransactionHande, aBytes, aLength);
            Logger.LOG(14, 4, "+ 2 getBytes()- result " + result);
        }
        Logger.LOG(14, 4, "-getBytes() + result " + result);
        return result;
    }

    public int available() throws IOException {
        if (this.iClosed && this.iInputStream == null && this.iOutputStream == null) {
            throw new IOException("Available method failed.Connection is already closed");
        }
        return this._available(this.iNativeTransactionHande);
    }

    protected void transactionSubmitCallback(int aStatus) {
        Logger.LOG(14, 4, "+ transactionSubmitCallback Callback");
        this.iTransactionBlock.notifyCompleted(aStatus);
        Logger.LOG(14, 4, "- transactionSubmitCallback Callback");
    }

    protected void dataReadyForReadCallBack(int aStatus) {
        Logger.LOG(14, 4, "+ dataReadyForReadCallBack  " + aStatus);
        this.iNativeDataReadyForRead.notifyCompleted(aStatus);
        Logger.LOG(14, 4, "- dataReadyForReadCallBack");
    }

    private native int _createHttpSession(int var1, int var2, int var3, int[] var4);

    private native int _createNativeTransaction(int var1, String var2, String var3);

    private native int _submitTransaction(int var1, String[] var2, byte[] var3, int var4);

    private native String[] _getResponse(int var1);

    private native int _getBytes(int var1, byte[] var2, int var3);

    private native void _dispose(int var1);

    private native void _closeTransaction(int var1);

    private native int _available(int var1);

    private native String _getUserAgentHeaderValue();

    static {
        try {
            Logger.LOG(14, 4, "loading   http from HttpConnectionNative.java");
            Jvm.loadSystemLibrary("javahttp");
            Logger.LOG(14, 4, "after loading http dll");
        }
        catch (Exception e) {
            Logger.LOG(14, 1, e.toString());
        }
    }

    class NativeHttpInputStream
    extends InputStream {
        private NativeHttpByteSource iByteSource;
        private byte[] iBuffer;
        private int iOffset;
        private int iLength;
        private static final int BUFFER_SIZE = 6144;
        private boolean iIsClosed;

        NativeHttpInputStream(NativeHttpByteSource aByteSource) {
            this.iByteSource = aByteSource;
            this.iBuffer = new byte[6144];
            this.iIsClosed = false;
        }

        public synchronized void close() throws IOException {
            this.iIsClosed = true;
            this.iByteSource.closeByteSource();
        }

        public synchronized int read() throws IOException {
            int BYTEPADDER = 255;
            this.throwIfClosed();
            if (this.iOffset == this.iLength) {
                this.getBytes();
            }
            if (this.iLength > 0) {
                return this.iBuffer[this.iOffset++] & 0xFF;
            }
            Logger.LOG(14, 4, "NativeInputStream.read(): return -1 ");
            return -1;
        }

        public synchronized int read(byte[] aBytes, int aOffset, int aLength) throws IOException {
            int nBytes;
            int count;
            this.throwIfClosed();
            for (nBytes = 0; nBytes < aLength; nBytes += count) {
                count = this.readInner(aBytes, aOffset + nBytes, aLength - nBytes);
                if (count >= 0) continue;
                nBytes = nBytes == 0 ? -1 : nBytes;
                break;
            }
            Logger.LOG(14, 4, "- NativeInputStream.read(,,,) return nBytes, " + nBytes);
            return nBytes;
        }

        private int readInner(byte[] aBytes, int aOffset, int aLength) throws IOException {
            if (this.iOffset == this.iLength) {
                this.getBytes();
            }
            if (this.iLength == 0) {
                return -1;
            }
            int nBytesLeft = this.iLength - this.iOffset;
            int nBytesToCopy = aLength > nBytesLeft ? nBytesLeft : aLength;
            System.arraycopy((Object)this.iBuffer, this.iOffset, (Object)aBytes, aOffset, nBytesToCopy);
            this.iOffset += nBytesToCopy;
            return nBytesToCopy;
        }

        private void getBytes() throws IOException {
            int nBytes = this.iByteSource.getBytes(this.iBuffer, this.iBuffer.length);
            if (nBytes == -1) {
                throw new IOException();
            }
            this.iLength = nBytes;
            this.iOffset = 0;
        }

        public int available() throws IOException {
            this.throwIfClosed();
            return this.iByteSource.available();
        }

        private void throwIfClosed() throws IOException {
            if (this.iIsClosed) {
                throw new IOException("Connection is already closed");
            }
        }
    }

    protected class PlainDataOutputStream
    extends DataOutputStream {
        private boolean iFlushed = false;

        public void close() throws IOException {
            if (!this.iFlushed) {
                this.flush();
            }
            super.close();
            HttpConnectionNative.this.outputStreamClosed();
        }

        public void flush() throws IOException {
            super.flush();
            HttpConnectionNative.this.outputStreamFlushed();
            this.iFlushed = true;
        }

        PlainDataOutputStream(OutputStream aOs) {
            super(aOs);
        }
    }

    protected class PlainDataInputStream
    extends DataInputStream {
        public void close() throws IOException {
            super.close();
            HttpConnectionNative.this.inputStreamClosed();
        }

        PlainDataInputStream(InputStream aIs) {
            super(aIs);
        }
    }
}

