/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.https;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.http.HttpConnectionNative;
import com.nokia.mj.impl.https.SecurityInfoImpl;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import javax.microedition.io.HttpsConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.pki.Certificate;
import javax.microedition.pki.CertificateException;

public class HttpsConnectionNative
extends HttpConnectionNative
implements HttpsConnection {
    private static final int SSL_ERROR_BASE = -7400;
    private static final int SSL_ALERT_BASE = 100;
    private static final int KErrSSLAlertCertificateExpired = -7545;
    private static final int KErrSSLAlertCertificateUnknown = -7546;
    private static final int KErrSSLAlertUnknownCA = -7548;
    private static final int SSL_ERROR_RANGE_START = -7500;
    private static final int SSL_ERROR_RANGE_END = -7600;
    protected static final int HTTPS_DEFAULT_PORT = 443;
    SecurityInfoImpl iSecurityInfo = null;
    int iMNativeSecureConnectionHandle = 0;

    public HttpsConnectionNative(int aNativeHttpSessionHandle, String aUri, int aMode, boolean aTimeouts, ConnectionManager cm, AccessPoint apnInfo) throws IOException {
        super(aNativeHttpSessionHandle, aUri, aMode, aTimeouts, cm, apnInfo);
    }

    public int getPort() {
        Logger.LOG(14, 4, "+ getPort()");
        String temp = this.iUri.getPort();
        if (temp.length() != 0) {
            try {
                int result = Integer.parseInt(temp);
                Logger.LOG(14, 4, "- getPort() " + result);
                return result;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Logger.LOG(14, 4, "- getPort() returns default port443");
        return 443;
    }

    public SecurityInfo getSecurityInfo() throws IOException {
        Logger.LOG(14, 4, "+ getSecurityInfo()");
        this.ensureOpen("getSecurityInfo");
        this.ensureConnected();
        this.ensureResponse();
        if (this.iMNativeSecureConnectionHandle == 0) {
            int handle = this._getMSecureConnectionInfo(this.iNativeTransactionHande);
            if (handle != 0) {
                this.iMNativeSecureConnectionHandle = handle;
            } else {
                throw new IOException("Unable to open https connection, getting security info failed");
            }
        }
        if (this.iSecurityInfo == null) {
            Logger.LOG(14, 4, "new SecurityInfoImpl(iMNativeSecureConnectionHandle) " + this.iMNativeSecureConnectionHandle + " iNativeTransactionHande " + this.iNativeTransactionHande);
            this.iSecurityInfo = new SecurityInfoImpl(this.iMNativeSecureConnectionHandle);
        }
        Logger.LOG(14, 4, "- getSecurityInfo()");
        return this.iSecurityInfo;
    }

    protected void throwIOException(String message) throws IOException {
        int error = 0;
        try {
            error = Integer.parseInt(message);
        }
        catch (NumberFormatException n) {
            throw new IOException(message);
        }
        this.checkError(error);
    }

    public int checkError(int aError) throws IOException {
        Logger.LOG(14, 4, ">>>>>>>> getSecurityInfo() checkError: " + aError);
        if (aError <= -7500 && aError >= -7600) {
            Certificate cert = null;
            byte certError = 0;
            switch (aError) {
                case -7545: {
                    certError = 3;
                    break;
                }
                case -7548: 
                case -7546: {
                    certError = 8;
                    break;
                }
                default: {
                    certError = 14;
                }
            }
            throw new CertificateException("Invalid server certificate.Symbian os error code: " + aError, cert, certError);
        }
        throw new IOException("Symbian OS error code :" + aError);
    }

    private native int _getMSecureConnectionInfo(int var1);

    static {
        try {
            Logger.LOG(14, 4, "loading   https from HttpsConnectionNative.java");
            Jvm.loadSystemLibrary("javahttps");
            Logger.LOG(14, 4, "after loading https dll");
        }
        catch (Exception e) {
            Logger.LOG(14, 1, e.toString());
        }
    }
}

