/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.InstallInfo;
import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.eswt.ConfirmationViewBase;
import com.nokia.mj.impl.installer.ui.eswt.InstallDetailsView;
import com.nokia.mj.impl.installer.ui.eswt.InstallerUiEswt;
import java.io.InputStream;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class InstallConfirmationView
extends ConfirmationViewBase {
    private InstallDetailsView iInstallDetailsView = null;
    private InstallInfo iInstallInfo = null;
    private Image iSuiteIcon = null;

    protected InstallConfirmationView() {
    }

    protected InstallConfirmationView(Composite aParent) {
        super(aParent, 8);
        this.setTitle(InstallerUiTexts.get("progress"));
        this.setCommands(InstallerUiTexts.get("ok"), InstallerUiTexts.get("cancel"));
    }

    public boolean confirm(InstallInfo aInstallInfo) {
        this.iInstallInfo = aInstallInfo;
        boolean result = this.confirm();
        if (result) {
            this.log("installConfirmationView confirmed");
        } else {
            this.log("installConfirmationView cancelled");
        }
        return result;
    }

    protected void createView() {
        GridData gridData = null;
        int horizontalSpan = this.getColumns() - 1;
        int labelStyle = 64;
        InputStream iconInputStream = this.iInstallInfo.getIconInputStream();
        if (iconInputStream != null) {
            this.iSuiteIcon = InstallerUiEswt.loadImage(this.getComposite().getDisplay(), iconInputStream, this.iInstallInfo.getIconPath());
            if (this.iSuiteIcon != null) {
                Label iconLabel = this.createLabel(this.iSuiteIcon, 2, 0);
                horizontalSpan = this.getColumns() - 3;
            } else {
                horizontalSpan = this.getColumns() - 1;
            }
        }
        String title = InstallerUiTexts.get("query", new String[]{this.iInstallInfo.getName()});
        if (this.iInstallInfo.getOldVersion() != null) {
            title = InstallerUiTexts.get("update_query", new String[]{this.iInstallInfo.getName(), this.iInstallInfo.getOldVersion(), this.iInstallInfo.getVersion()});
        }
        Label titleLabel = this.createLabel(title, horizontalSpan, labelStyle);
        titleLabel.setFont(this.getBoldFont());
        boolean identified = this.iInstallInfo.getCertificates() != null;
        Label securityIconLabel = this.createSecurityLabel(identified);
        horizontalSpan = this.getColumns();
        Link detailsLink = new Link(this.getComposite(), 0);
        detailsLink.setText("<a>" + InstallerUiTexts.get("view_app_details") + "</a>");
        detailsLink.addListener(13, new Listener(){

            public void handleEvent(Event aEvent) {
                InstallConfirmationView.this.openDetailsView();
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        detailsLink.setLayoutData((Object)gridData);
    }

    protected void getDataFromView() {
    }

    protected boolean forceFocusToShell() {
        return true;
    }

    protected int getStyle() {
        return 512;
    }

    protected void screenOrientationChanged() {
        super.screenOrientationChanged();
        if (this.iInstallDetailsView != null) {
            this.iInstallDetailsView.screenOrientationChanged();
        }
    }

    private void openDetailsView() {
        if (this.iInstallDetailsView != null) {
            return;
        }
        this.iInstallDetailsView = new InstallDetailsView((Composite)new Shell(this.getShell(), this.getShell().getStyle()), this.getTitle(), this.iInstallInfo, this.iSuiteIcon);
        this.iInstallDetailsView.setInstallerUi(this.getInstallerUi());
        this.setVisible(false);
        new Thread(new Runnable(){

            public void run() {
                if (InstallConfirmationView.this.iInstallDetailsView.confirm()) {
                    InstallConfirmationView.this.log("installDetailsView confirmed");
                    InstallConfirmationView.this.confirmOk();
                } else {
                    InstallConfirmationView.this.log("installDetailsView cancelled");
                    InstallConfirmationView.this.confirmCancel();
                }
                InstallConfirmationView.this.iInstallDetailsView.dispose();
                InstallConfirmationView.this.iInstallDetailsView = null;
            }
        }, "InstallerUiDetailsViewThread").start();
    }
}

