/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.mms;

import com.nokia.mj.impl.mms.MMSPermissionImpl;
import com.nokia.mj.impl.mms.MmsPropertyRetriever;
import com.nokia.mj.impl.mms.MultipartMessageImpl;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.SizeExceededException;

public final class MMSConnectionImpl
implements MessageConnection {
    private static final int INITIAL = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private int iState;
    private int iSendError = 0;
    private int iMessagesOnQueue;
    private int iNotificationsToMake;
    private int iNativeHandle;
    private boolean iMessageWaiting;
    private boolean iMissedMessage;
    private boolean iServerConnection;
    private final Object iReadLock;
    private final Object iSendLock;
    private final Object iWriteLock;
    private final Object iCloseLock;
    private final Object iMessageLock;
    private String iUri;
    private String iAppID = null;
    private MessageListener iMessageListener;

    public MMSConnectionImpl(String aUri, boolean aServerConnection) throws IOException {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::MMSConnectionImpl()");
        this.iUri = aUri;
        this.iState = 0;
        this.iServerConnection = aServerConnection;
        this.iNativeHandle = this._createPeer(this.iServerConnection, this.iUri);
        this.iReadLock = new Object();
        this.iWriteLock = new Object();
        this.iCloseLock = new Object();
        this.iMessageLock = new Object();
        this.iSendLock = new Object();
        this.setShutdownListener();
        if (this.iServerConnection) {
            this.iAppID = aUri.substring("mms://:".length());
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::MMSConnectionImpl()");
    }

    private void setShutdownListener() {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::setShutdownListener()");
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                try {
                    MMSConnectionImpl.this.close();
                }
                catch (IOException e) {
                    Logger.LOG(15, 4, e.toString());
                }
            }
        });
        Logger.LOG(15, 4, "- MMSConnectionImpl::setShutdownListener()");
    }

    public void open() {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::open()");
        if (this.iState == 0) {
            this.iState = 1;
            if (this.iServerConnection) {
                new Thread(new Runnable(){

                    public void run() {
                        MMSConnectionImpl.this._openConnection(MMSConnectionImpl.this.iNativeHandle);
                    }
                }).start();
            }
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::open()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::close()");
        Object object = this.iCloseLock;
        synchronized (object) {
            if (this.iState != 2) {
                this.iState = 2;
                this._closeConnection(this.iNativeHandle);
                Object object2 = this.iMessageLock;
                synchronized (object2) {
                    this.iMessageLock.notify();
                }
                object2 = this.iReadLock;
                synchronized (object2) {
                    this.iReadLock.notify();
                }
                this._dispose(this.iNativeHandle);
            }
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::close()");
    }

    public int numberOfSegments(Message aMessage) {
        return 1;
    }

    private int getMMSMaxSize() {
        return MmsPropertyRetriever.getMMSMaxSize();
    }

    public Message newMessage(String aType) {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::newMessage()");
        if ("multipart".equals(aType)) {
            if (this.iServerConnection) {
                Logger.LOG(15, 4, "- MMSConnectionImpl::newMessage()");
                return new MultipartMessageImpl(null, 0L, this.getMMSMaxSize());
            }
            Logger.LOG(15, 4, "- MMSConnectionImpl::newMessage()");
            return new MultipartMessageImpl(this.iUri, 0L, this.getMMSMaxSize());
        }
        throw new IllegalArgumentException("Unrecognized message type: " + aType);
    }

    public Message newMessage(String aType, String aAddress) {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::newMessage()");
        if ("multipart".equals(aType)) {
            Logger.LOG(15, 4, "- MMSConnectionImpl::newMessage()");
            return new MultipartMessageImpl(aAddress, 0L, this.getMMSMaxSize());
        }
        throw new IllegalArgumentException("Unrecognized message type " + aType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message aMsg) throws IOException, InterruptedIOException {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::send()");
        MultipartMessageImpl mMsg = this.validateMessage(aMsg);
        if (this.iServerConnection) {
            mMsg.setReplyToAppID(this.iAppID);
        } else {
            this.validateClientMessage(mMsg);
        }
        byte[] bMsg = mMsg.serialize();
        Object object = this.iWriteLock;
        synchronized (object) {
            Object object2 = this.iSendLock;
            synchronized (object2) {
                Object object3 = this.iCloseLock;
                synchronized (object3) {
                    if (this.iState == 2) {
                        throw new IOException("Sending message failed: connection is already closed");
                    }
                    ApplicationUtils appUtils = ApplicationUtils.getInstance();
                    MMSPermissionImpl permission = new MMSPermissionImpl("mms://*", "send", this.getRecipientsCount(mMsg));
                    appUtils.checkPermission(permission);
                    int status = this._send(bMsg, 0, bMsg.length, mMsg.getAddress(), this.iNativeHandle);
                    if (status < 0) {
                        this._checkError(status);
                    }
                    try {
                        this.iSendLock.wait();
                    }
                    catch (InterruptedException e) {
                        Logger.LOG(15, 1, e.toString());
                    }
                    if (this.iSendError < 0) {
                        this._checkError(this.iSendError);
                    }
                }
            }
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::send()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageSentCallback(int aResult) {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::messageSentCallback()");
        Object object = this.iSendLock;
        synchronized (object) {
            this.iSendError = aResult;
            this.iSendLock.notify();
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::messageSentCallback()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Message receive() throws IOException, InterruptedIOException {
        MultipartMessageImpl rMsg;
        Logger.LOG(15, 4, "+ MMSConnectionImpl::receive()");
        if (!this.iServerConnection) {
            throw new IOException("Message connection must be a server connection");
        }
        Object object = this.iReadLock;
        synchronized (object) {
            Object object2;
            if (this.iState == 2) {
                throw new IOException("Receiving message failed: connection is already closed");
            }
            if (this.iMessagesOnQueue == 0) {
                this.iMessageWaiting = true;
                object2 = this.iMessageLock;
                synchronized (object2) {
                    this.iMessageLock.notify();
                }
                try {
                    this.iReadLock.wait();
                }
                catch (InterruptedException e) {
                    Logger.LOG(15, 1, e.toString());
                    throw new InterruptedIOException("");
                }
            }
            object2 = this.iCloseLock;
            synchronized (object2) {
                if (this.iState == 2) {
                    throw new InterruptedIOException("Connection closed while receiving message");
                }
                ApplicationUtils appUtils = ApplicationUtils.getInstance();
                MMSPermissionImpl permission = new MMSPermissionImpl("mms://*", "receive");
                appUtils.checkPermission(permission);
                byte[] msg = this._retrieveMessage(this.iNativeHandle);
                rMsg = MultipartMessageImpl.deserialize(msg, this.getMMSMaxSize());
                --this.iMessagesOnQueue;
            }
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::receive()");
        return rMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener aListener) throws IOException {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::setMessageListener()");
        if (!this.iServerConnection) {
            throw new IOException("Message connection must be a server connection");
        }
        if (this.iState == 2) {
            throw new IOException("Setting message listener failed: connection is already closed");
        }
        this.iMessageListener = aListener;
        if (this.iMessageListener != null) {
            Object object = this.iMessageLock;
            synchronized (object) {
                this.iMessageLock.notify();
            }
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::setMessageListener()");
    }

    private MultipartMessageImpl validateMessage(Message aMsg) throws IOException {
        MultipartMessageImpl mMsg;
        Logger.LOG(15, 4, "+ MMSConnectionImpl::validateMessage()");
        if (null == aMsg) {
            throw new NullPointerException("Message to be sent is null");
        }
        try {
            mMsg = (MultipartMessageImpl)aMsg;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Sent message must be MultipartMessage");
        }
        if (!mMsg.iValidationDone) {
            MultipartMessageImpl cloneMsg = new MultipartMessageImpl(mMsg.getDestinationAddress(), mMsg.getTimestamp() == null ? 0L : mMsg.getTimestamp().getTime(), MmsPropertyRetriever.getMMSMaxSize());
            this.cloneAddresses("to", cloneMsg, mMsg);
            this.cloneAddresses("bcc", cloneMsg, mMsg);
            this.cloneAddresses("cc", cloneMsg, mMsg);
            cloneMsg.setHeader("x-mms-delivery-time", mMsg.getHeader("x-mms-delivery-time"));
            cloneMsg.setHeader("x-mms-priority", mMsg.getHeader("x-mms-priority"));
            this.cloneMessageParts(cloneMsg, mMsg);
            cloneMsg.setStartContentId(mMsg.getStartContentId());
            cloneMsg.setSubject(mMsg.getSubject());
        }
        if (this.isEmpty(mMsg.getAddresses("to")) && this.isEmpty(mMsg.getAddresses("bcc")) && this.isEmpty(mMsg.getAddresses("cc"))) {
            throw new IllegalArgumentException("The message is incomplete or contains invalid information");
        }
        if (mMsg.iReply) {
            mMsg.setHeader("x-mms-delivery-time", null);
            if (mMsg.getReplyToAppID() == null || mMsg.getReplyToAppID() != null && (mMsg.getReplyToAppID().length() == 0 || mMsg.getReplyToAppID().equals("$"))) {
                throw new IllegalArgumentException("This is a message to which a reply can not be made");
            }
            String dest = mMsg.getAddress();
            mMsg.removeAddresses();
            mMsg.setAddress(dest);
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::validateMessage()");
        return mMsg;
    }

    private void cloneAddresses(String aAddressType, MultipartMessageImpl aDestMsg, MultipartMessageImpl aSourceMsg) {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::cloneAddresses()");
        String[] addresses = aSourceMsg.getAddresses(aAddressType);
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                aDestMsg.addAddress(aAddressType, addresses[i]);
            }
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::cloneAddresses()");
    }

    private void cloneMessageParts(MultipartMessageImpl aDestMsg, MultipartMessageImpl aSourceMsg) throws SizeExceededException {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::cloneMessageParts()");
        MessagePart[] parts = aSourceMsg.getMessageParts();
        if (parts != null) {
            for (int i = 0; i < parts.length; ++i) {
                MessagePart part = parts[i];
                aDestMsg.addMessagePart(new MessagePart(part.getContent(), part.getMIMEType(), part.getContentID(), part.getContentLocation(), part.getEncoding()));
            }
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::cloneMessageParts()");
    }

    private void validateClientMessage(MultipartMessageImpl aMsg) {
        aMsg.setReplyToAppID("$");
    }

    private boolean isEmpty(String[] aArray) {
        return aArray == null || aArray != null && aArray.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpen() throws IOException {
        Object object = this.iCloseLock;
        synchronized (object) {
            if (this.iState == 2) {
                throw new IOException("connection is already closed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int messageReceiveCallback(int aReceivedMesgs) {
        Logger.LOG(15, 4, "+ MMSConnectionImpl::messageReceiveCallback()");
        Object object = this.iMessageLock;
        synchronized (object) {
            if (!this.iMessageWaiting && null == this.iMessageListener) {
                try {
                    this.iMessageLock.wait();
                }
                catch (InterruptedException e) {
                    Logger.LOG(15, 1, e.toString());
                }
            }
        }
        object = this.iReadLock;
        synchronized (object) {
            if (aReceivedMesgs >= 0) {
                this.iMessagesOnQueue += aReceivedMesgs;
                this.iNotificationsToMake += aReceivedMesgs;
            }
            if (this.iMessageWaiting) {
                this.iMessageWaiting = false;
                this.iReadLock.notify();
            } else if (this.iMessageListener != null) {
                while (this.iNotificationsToMake > 0) {
                    this.iMessageListener.notifyIncomingMessage(this);
                    --this.iNotificationsToMake;
                }
            }
        }
        Logger.LOG(15, 4, "- MMSConnectionImpl::messageReceiveCallback()");
        return this.iState == 2 ? -1 : 0;
    }

    private int getRecipientsCount(MultipartMessageImpl mMsg) {
        int cnt = 0;
        String[] tmp = mMsg.getAddresses("to");
        if (tmp != null) {
            cnt += tmp.length;
        }
        if ((tmp = mMsg.getAddresses("cc")) != null) {
            cnt += tmp.length;
        }
        if ((tmp = mMsg.getAddresses("bcc")) != null) {
            cnt += tmp.length;
        }
        return cnt;
    }

    private native int _createPeer(boolean var1, String var2);

    private native void _openConnection(int var1);

    private native int _send(byte[] var1, int var2, int var3, String var4, int var5);

    private native byte[] _retrieveMessage(int var1);

    private native void _closeConnection(int var1);

    private native void _dispose(int var1);

    private native void _checkError(int var1);
}

