/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.mms;

import com.nokia.mj.impl.security.common.PermissionBase;
import com.nokia.mj.impl.security.utils.SecurityPromptMessage;
import java.security.Permission;
import java.security.PermissionCollection;

public class MMSPermissionImpl
extends PermissionBase {
    public String iAction = null;
    private int iRecipientsCount = 0;

    public MMSPermissionImpl(String aUri, String aAction) {
        super(aUri);
        this.iAction = aAction;
    }

    public MMSPermissionImpl(String aUri, String aAction, int aRecipientsCount) {
        super(aUri);
        this.iAction = aAction;
        this.iRecipientsCount = aRecipientsCount;
    }

    public String getSecurityPromptQuestion() {
        if (this.iAction.compareTo("receive") == 0) {
            return SecurityPromptMessage.getInstance().getText("mms_receiving", null);
        }
        if (this.iAction.compareTo("open") == 0) {
            return SecurityPromptMessage.getInstance().getText("mms_opening_conn", null);
        }
        if (this.iAction.compareTo("send") == 0) {
            if (this.iRecipientsCount == 1) {
                return SecurityPromptMessage.getInstance().getText("mms_single_sending", null);
            }
            return SecurityPromptMessage.getInstance().getText("mms_single_sending_multiple_destinations", new Object[]{new Integer(this.iRecipientsCount)});
        }
        return null;
    }

    public String toString() {
        if (this.iAction.compareTo("open") == 0) {
            return "javax.microedition.io.Connector.mms";
        }
        if (this.iAction.compareTo("send") == 0) {
            return "javax.wireless.messaging.mms.send";
        }
        if (this.iAction.compareTo("receive") == 0) {
            return "javax.wireless.messaging.mms.receive";
        }
        return null;
    }

    public boolean implies(Permission permission) {
        if (permission instanceof MMSPermissionImpl) {
            MMSPermissionImpl perm = (MMSPermissionImpl)permission;
            if (MMSPermissionImpl.matchActions(this.iAction, perm.iAction)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return true;
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return null;
    }
}

