/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.pim.utils;

import com.nokia.mj.impl.pim.GenericException;
import javax.microedition.pim.FieldEmptyException;
import javax.microedition.pim.FieldFullException;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.UnsupportedFieldException;

public final class NativeError {
    public static void handleFieldHandlingError(int aNativeErrorCode, int aField, int aIndex) {
        if (aNativeErrorCode == 0) {
            return;
        }
        switch (aNativeErrorCode) {
            case -6: {
                throw new IllegalArgumentException("Invalid field: " + aField);
            }
            case -5: {
                throw new UnsupportedFieldException("Unsupported field: " + aField, aField);
            }
            case -1: {
                throw new IndexOutOfBoundsException("Invalid index: " + aIndex);
            }
            case -40: {
                throw new IllegalArgumentException("Invalid value");
            }
            case -9: {
                throw new FieldFullException("Field is full");
            }
            case -22: {
                throw new IllegalArgumentException("Field is read only");
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    public static void handleFieldHandlingError(int aNativeErrorCode, int aField) {
        NativeError.handleFieldHandlingError(aNativeErrorCode, aField, 0);
    }

    public static void handleCategoryHandlingError(int aNativeErrorCode, String aCategory) throws PIMException {
        if (aNativeErrorCode == 0) {
            return;
        }
        switch (aNativeErrorCode) {
            case -45: {
                throw new PIMException("List is closed", 2);
            }
            case -6: {
                String msg = null;
                msg = aCategory != null ? "Invalid category: " + aCategory : "Invalid category";
                throw new PIMException(msg, 1);
            }
            case -1: {
                throw new PIMException("No such category:" + aCategory, 1);
            }
            case -5: {
                throw new PIMException("Categories are not supported", 0);
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new PIMException("General error", 1);
    }

    public static void handleCategoryHandlingError(int aNativeErrorCode) throws PIMException {
        NativeError.handleCategoryHandlingError(aNativeErrorCode, null);
    }

    public static void handleSerializationError(int aNativeErrorCode) throws PIMException {
        if (aNativeErrorCode == 0) {
            return;
        }
        switch (aNativeErrorCode) {
            case -40: 
            case -25: 
            case -20: 
            case -5: 
            case -1: {
                throw new PIMException("Data serialization failed", 1);
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    public static boolean checkSuccess(int aNativeErrorCode) {
        return aNativeErrorCode == 0;
    }

    public static boolean checkArgumentError(int aNativeErrorCode) {
        return aNativeErrorCode == -6;
    }

    public static void handleRepeatRuleFieldsError(int aNativeErrorCode, int aFrequency) {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -6: {
                throw new IllegalArgumentException("Invalid repeatrule value: " + aFrequency);
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    public static void handleItemCommitError(int aNativeErrorCode) throws PIMException {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -39: {
                throw new PIMException("Commit operation failed:The item has insufficient data", 1);
            }
            case -1: {
                throw new PIMException("Commit operation failed:Item is removed", 1);
            }
            case -14: {
                throw new PIMException("Commit operation failed:The item is in use", 6);
            }
            case -36: {
                throw new PIMException("Commit operation failed:List is closed", 2);
            }
            case -24: {
                throw new PIMException("Item does not belong to a list", 1);
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new PIMException("General error", 1);
    }

    public static void handleRemoveItemError(int aNativeErrorCode) throws PIMException {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -45: {
                throw new PIMException("Removal failed:List is closed", 2);
            }
            case -6: {
                throw new PIMException("Removal failed:Item is not in the List", 1);
            }
            case -1: {
                throw new PIMException("Removal failed:Item exists no more in the database.", 1);
            }
            case -14: {
                throw new PIMException("The item is in use", 1);
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    public static void handlePIMListCloseError(int aNativeErrorCode) throws PIMException {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -45: {
                throw new PIMException("List is already closed", 2);
            }
        }
        throw new PIMException("General error", 1);
    }

    public static void handleArrayElementLabelError(int aNativeErrorCode) {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -6: {
                throw new IllegalArgumentException("Cannot obtain label:Invalid field or array element");
            }
            case -5: {
                throw new UnsupportedFieldException("Cannot obtain label:Unsupported field or array element");
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    public static void handlegetAttributeLabelError(int aNativeErrorCode, int aAttribute) {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -6: {
                throw new IllegalArgumentException("Cannot obtain label:Invalid attribute: " + aAttribute);
            }
            case -5: {
                throw new UnsupportedFieldException("Cannot obtain label:Unsupported attribute: " + aAttribute, aAttribute);
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    public static void handleUpdateListError(int aNativeErrorCode) throws PIMException {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -45: {
                throw new PIMException("Updating failedList is closed", 2);
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    public static void handleProcessItemResultsError(int aNativeErrorCode) throws PIMException {
        switch (aNativeErrorCode) {
            case 0: {
                break;
            }
            case -45: {
                throw new PIMException("List is closed", 2);
            }
            case -6: {
                throw new IllegalArgumentException("Invalid argument");
            }
            case -4: {
                throw new OutOfMemoryError();
            }
            default: {
                throw new PIMException("General error", 1);
            }
        }
    }

    public static void handleListPIMListError(int aNativeErrorCode) {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -6: {
                throw new IllegalArgumentException("Invalid argument");
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    public static void handleOpenPIMListError(int aNativeErrorCode, int aPimListType, String aName) throws PIMException {
        switch (aNativeErrorCode) {
            case 0: {
                return;
            }
            case -6: {
                throw new IllegalArgumentException("Invalid argument");
            }
            case -5: {
                throw new PIMException("List type " + aPimListType + " is not supported.", 0);
            }
            case -1: {
                throw new PIMException("Invalid list name: " + aName, 1);
            }
            case -11: {
                throw new PIMException("List is already open", 1);
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new PIMException("General error", 1);
    }

    public static void handleToSerialFormatError(int aNativeErrorCode) throws PIMException {
        if (aNativeErrorCode == -4) {
            throw new OutOfMemoryError();
        }
        if (aNativeErrorCode != 0) {
            throw new PIMException("Data serialization failed:The item has invalid data content", 1);
        }
    }

    public static void handleRRFieldHandlingError(int aNativeErrorCode, int aField) {
        if (aNativeErrorCode == 0) {
            return;
        }
        switch (aNativeErrorCode) {
            case -6: {
                throw new IllegalArgumentException("Invalid field: " + aField);
            }
            case -1: {
                throw new FieldEmptyException("Field not found: " + aField);
            }
            case -40: {
                throw new IllegalArgumentException("Invalid value");
            }
            case -4: {
                throw new OutOfMemoryError();
            }
        }
        throw new GenericException("General error:" + aNativeErrorCode);
    }

    private NativeError() {
    }
}

