/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.push;

import com.nokia.mj.impl.installer.pushregistrator.PushInfo;
import com.nokia.mj.impl.push.PushMidletData;
import com.nokia.mj.impl.storage.StorageAttribute;
import com.nokia.mj.impl.storage.StorageEntry;
import com.nokia.mj.impl.storage.StorageFactory;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;

final class PushDbHandler {
    PushDbHandler() {
    }

    public static void storePushRegs(StorageSession aSession, PushInfo[] aPushInfos) {
        Logger.LOG(12, 4, "PushDbHandler.storePushRegs()");
        if (null == aPushInfos) {
            return;
        }
        for (int i = 0; i < aPushInfos.length; ++i) {
            StorageEntry entry = new StorageEntry();
            entry.addAttribute(new StorageAttribute("ID", aPushInfos[i].getUid().getStringValue()));
            entry.addAttribute(new StorageAttribute("URL", aPushInfos[i].getConnectionUrl()));
            entry.addAttribute(new StorageAttribute("NAME", aPushInfos[i].getClassName()));
            entry.addAttribute(new StorageAttribute("FILTER", aPushInfos[i].getFilter()));
            entry.addAttribute(new StorageAttribute("REGISTRATION_TYPE", Integer.toString(aPushInfos[i].getRegType()), 1));
            aSession.write("PUSH_REGISTRATIONS", entry);
        }
    }

    public static void deletePushRegs(StorageSession aSession, Uid aUid) {
        Logger.LOG(12, 4, "PushDbHandler.deletePushRegs()");
        aSession.remove("PUSH_REGISTRATIONS", aUid);
    }

    public static void deleteAlarm(StorageSession aSession, Uid aUid) {
        Logger.LOG(12, 4, "PushDbHandler.deleteAlarm()");
        aSession.remove("ALARM_REGISTRATIONS", aUid);
    }

    public static PushInfo[] getPushRegs(StorageSession aSession, Uid aUid) {
        Logger.LOG(12, 4, "PushDbHandler.getPushRegs()");
        StorageEntry query = new StorageEntry();
        query.addAttribute(new StorageAttribute("ID", aUid.getStringValue()));
        StorageEntry[] entries = aSession.search("PUSH_REGISTRATIONS", query);
        return PushDbHandler.mapStorageEntryToPushInfo(entries);
    }

    public static PushMidletData[] getClassNamesAndUidsOfMidletsInSuite(Uid aSuiteUid, StorageSession aSession) throws IOException {
        Logger.LOG(8, 4, "PushDbHandler.getClassNamesOfMidletsInSuite()");
        boolean sessionCreatedByUser = false;
        if (null != aSession) {
            sessionCreatedByUser = true;
        }
        StorageSession sessionObj = aSession;
        try {
            if (!sessionCreatedByUser) {
                sessionObj = StorageFactory.createSession();
                sessionObj.open();
            }
            StorageEntry query = new StorageEntry();
            query.addAttribute(new StorageAttribute("PACKAGE_ID", aSuiteUid.getStringValue()));
            query.addAttribute(new StorageAttribute("MAIN_CLASS", ""));
            query.addAttribute(new StorageAttribute("ID", ""));
            query.addAttribute(new StorageAttribute("NAME", ""));
            StorageEntry[] entries = sessionObj.search("APPLICATION", query);
            if (null == entries) {
                PushMidletData[] pushMidletDataArray = null;
                return pushMidletDataArray;
            }
            if (0 == entries.length) {
                PushMidletData[] pushMidletDataArray = null;
                return pushMidletDataArray;
            }
            PushMidletData[] midletData = new PushMidletData[entries.length];
            for (int i = 0; i < entries.length; ++i) {
                PushMidletData tmpObj;
                StorageAttribute attr = entries[i].getAttribute("ID");
                Uid newUid = Uid.createUid(attr.getValue());
                attr = entries[i].getAttribute("MAIN_CLASS");
                String mainClassName = attr.getValue();
                attr = entries[i].getAttribute("NAME");
                String midletName = attr.getValue();
                midletData[i] = tmpObj = new PushMidletData(newUid, mainClassName, midletName);
            }
            PushMidletData[] pushMidletDataArray = midletData;
            return pushMidletDataArray;
        }
        catch (Throwable ex) {
            throw new IOException("Getting name of MIDlets failed: " + ex);
        }
        finally {
            if (!sessionCreatedByUser && null != sessionObj) {
                sessionObj.close();
                sessionObj.destroySession();
            }
        }
    }

    public static PushInfo getPushRegByConnection(String aUri, StorageSession aSession) {
        Logger.LOG(8, 4, "PushDbHandler.getUidAndRegTypeOfPushReg()");
        StorageEntry query = new StorageEntry();
        query.addAttribute(new StorageAttribute("URL", aUri));
        StorageEntry[] entries = aSession.search("PUSH_REGISTRATIONS", query);
        PushInfo[] pushInfoTable = PushDbHandler.mapStorageEntryToPushInfo(entries);
        if (null == pushInfoTable) {
            return null;
        }
        return pushInfoTable[0];
    }

    public static PushInfo[] mapStorageEntryToPushInfo(StorageEntry[] aEntries) {
        Logger.LOG(12, 4, "PushDbHandler.mapStorageEntryToPushInfo() +");
        if (null == aEntries) {
            return null;
        }
        Logger.LOG(12, 4, "PushDbHandler.mapStorageEntryToPushInfo() #2");
        if (0 == aEntries.length) {
            return null;
        }
        Logger.LOG(12, 4, "PushDbHandler.mapStorageEntryToPushInfo() #3");
        PushInfo[] pushInfoTable = new PushInfo[aEntries.length];
        for (int i = 0; i < aEntries.length; ++i) {
            PushInfo infoObj;
            StorageAttribute attr = aEntries[i].getAttribute("ID");
            Uid newUid = Uid.createUid(attr.getValue());
            attr = aEntries[i].getAttribute("URL");
            String uri = attr.getValue();
            attr = aEntries[i].getAttribute("NAME");
            String className = attr.getValue();
            attr = aEntries[i].getAttribute("FILTER");
            String filter = attr.getValue();
            attr = aEntries[i].getAttribute("REGISTRATION_TYPE");
            int regType = Integer.parseInt(attr.getValue());
            pushInfoTable[i] = infoObj = new PushInfo(newUid, uri, className, filter, regType);
        }
        Logger.LOG(12, 4, "PushDbHandler.mapStorageEntryToPushInfo() -");
        return pushInfoTable;
    }
}

