/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt;

import com.nokia.mj.impl.rt.support.NativeMemoryBlock;
import com.nokia.mj.impl.rt.support.ThreadEventListener;
import com.nokia.mj.impl.utils.Logger;
import java.util.Hashtable;

public abstract class JvmPort {
    private static final String PORTCLASS_PROPERTY_NAME = "com.nokia.jvm.port";
    private static final String PORTCLASS_PACKAGE = "com.nokia.mj.impl.rt.";
    private static JvmPort sInstance = null;
    private static Hashtable mPropertiesContainer;

    protected JvmPort() {
    }

    public static JvmPort getInstance() {
        return sInstance;
    }

    public static void setPropertiesContainer(Hashtable propertiesContainer) {
        mPropertiesContainer = propertiesContainer;
    }

    public abstract void loadSystemLibrary(String var1);

    public abstract Class loadApplicationClass(String var1) throws ClassNotFoundException;

    public abstract boolean runYoungGenerationGc();

    public abstract void setThreadAsDaemon(Thread var1, boolean var2) throws IllegalThreadStateException, SecurityException;

    public abstract NativeMemoryBlock getResourceAsNativeMemory(String var1, String var2);

    public abstract void disableRuntimeExit();

    public abstract void enableRuntimeExit();

    public abstract void exitVm(int var1);

    public abstract void runFinalization();

    public abstract void enableFinalization(Class var1);

    public abstract void setThreadEventListener(ThreadEventListener var1);

    public abstract void addRestrictedPackagePrefixes(String[] var1) throws SecurityException;

    public abstract void addProtectedPackagePrefixes(String[] var1) throws SecurityException;

    public abstract void appendToClassPath(String var1);

    public void setSystemProperty(Object key, Object value) {
        mPropertiesContainer.put(key, value);
    }

    static {
        String vmPortClass = System.getProperty(PORTCLASS_PROPERTY_NAME);
        if (vmPortClass == null) {
            throw new RuntimeException("Not able to load VM port class since com.nokia.jvm.port is undefined");
        }
        vmPortClass = PORTCLASS_PACKAGE + vmPortClass;
        try {
            Class clazz = Class.forName(vmPortClass);
            sInstance = (JvmPort)clazz.newInstance();
        }
        catch (Exception e) {
            String errTxt = "Not able to instantiate class " + vmPortClass + ".";
            Logger.ELOG(6, errTxt, e);
            throw new RuntimeException(errTxt);
        }
    }
}

