/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.fileutils.FileUtility;
import com.nokia.mj.impl.rt.midp.Log;
import com.nokia.mj.impl.rt.support.JvmInternal;
import com.nokia.mj.impl.utils.LineReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;

final class ExtensionUtil {
    private static final String ODC_EXTENSIONS = ".odc";
    private static final String PROTECTED_PACKAGE_PROPERTY = "com.nokia.mj.addon.protected.";
    private static final String RESTRICTED_PACKAGE_PROPERTY = "com.nokia.mj.addon.restricted.";

    ExtensionUtil() {
    }

    static void handleExtensions() {
        String odcList = System.getProperty("com.nokia.mj.addon.list");
        if (odcList != null) {
            Vector result = ExtensionUtil.split(odcList, ';');
            Enumeration odcFiles = result.elements();
            while (odcFiles.hasMoreElements()) {
                String odcFile = (String)odcFiles.nextElement();
                if (!odcFile.endsWith(ODC_EXTENSIONS)) continue;
                ExtensionUtil.setAddOnSystemProperties(odcFile);
                ExtensionUtil.setAddOnJsrPackageProtections(odcFile);
            }
        }
    }

    private static void setAddOnSystemProperties(String odcFile) {
        InputStream fis = null;
        try {
            String line;
            fis = new FileUtility(odcFile).openInputStream();
            LineReader lr = new LineReader(new InputStreamReader(fis));
            while ((line = lr.readLine()) != null && !line.startsWith("[properties]")) {
            }
            while ((line = lr.readLine()) != null) {
                if (!line.startsWith("-D")) continue;
                int ind = line.indexOf(61);
                String propertyKey = null;
                String propertyValue = null;
                if (ind == -1) {
                    propertyKey = line.substring(2);
                } else {
                    propertyKey = line.substring(2, ind);
                    propertyValue = line.substring(ind + 1);
                }
                JvmInternal.setSystemProperty(propertyKey, propertyValue);
            }
        }
        catch (IOException ioe) {
            Log.logE("Error in opening file: " + odcFile, ioe);
        }
        try {
            if (fis != null) {
                fis.close();
                fis = null;
            }
        }
        catch (IOException ioe) {
            Log.logE("setAddOnSystemProperties: error while closing file " + odcFile, ioe);
        }
    }

    private static void setAddOnJsrPackageProtections(String odcFile) {
        char pathSeparator = System.getProperty("file.separator").charAt(0);
        int lastFileSeparator = odcFile.lastIndexOf(pathSeparator);
        if (lastFileSeparator >= 0 && odcFile.endsWith(ODC_EXTENSIONS)) {
            String propertyName = odcFile.substring(lastFileSeparator + 1, odcFile.length() - ODC_EXTENSIONS.length());
            StringBuffer stringBuffProt = new StringBuffer(PROTECTED_PACKAGE_PROPERTY);
            stringBuffProt.append(odcFile);
            String property = System.getProperty(stringBuffProt.toString());
            Vector protectedPackages = ExtensionUtil.split(property, ',');
            if (protectedPackages != null) {
                Object[] protectedPkgsArr = new String[protectedPackages.size()];
                protectedPackages.copyInto(protectedPkgsArr);
                JvmInternal.addProtectedPackagePrefixes((String[])protectedPkgsArr);
                JvmInternal.addRestrictedPackagePrefixes((String[])protectedPkgsArr);
            }
            StringBuffer stringBuffRestr = new StringBuffer(RESTRICTED_PACKAGE_PROPERTY);
            stringBuffRestr.append(odcFile);
            property = System.getProperty(stringBuffRestr.toString());
            Vector restrictedPackages = ExtensionUtil.split(property, ',');
            if (restrictedPackages != null) {
                Object[] restrictedPackagesArr = new String[restrictedPackages.size()];
                restrictedPackages.copyInto(restrictedPackagesArr);
                JvmInternal.addRestrictedPackagePrefixes((String[])restrictedPackagesArr);
            }
        }
    }

    private static Vector split(String text, char delimiter) {
        if (text == null || text.equals("")) {
            return null;
        }
        int startIndex = 0;
        boolean loop = true;
        Vector result = new Vector(10);
        while (loop) {
            String splitString = null;
            int endIndex = text.indexOf(delimiter, startIndex);
            if (endIndex == -1) {
                splitString = text.substring(startIndex);
                loop = false;
            } else {
                splitString = text.substring(startIndex, endIndex);
                startIndex = endIndex + 1;
            }
            result.addElement(splitString.trim());
        }
        return result;
    }
}

