/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.support;

import com.nokia.mj.impl.rt.support.JvmInternal;
import com.nokia.mj.impl.utils.Logger;

class MemoryManager {
    private static final String WINDOW_SIZE_PROPERTY_NAME = "com.nokia.mj.memorymanager.windowsize";
    private static final String TRACE_PROPERTY_NAME = "com.nokia.mj.memorymanager.trace";
    private int windowSize = MemoryManager.getInt("com.nokia.mj.memorymanager.windowsize", this.windowSize);
    private int lowBorder;
    private int highBorder;
    private int size = 0;
    private boolean collectionOngoing = false;
    private boolean trace = System.getProperty("com.nokia.mj.memorymanager.trace") != null;

    MemoryManager() {
        this.setWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeSize(int oldSize, int newSize) {
        int change = newSize - oldSize;
        MemoryManager memoryManager = this;
        synchronized (memoryManager) {
            this.size += change;
            if (this.collectionOngoing) {
                return;
            }
            if (this.size > this.highBorder) {
                this.collectionOngoing = true;
                if (this.trace) {
                    this.traceString("collection requested, low, high, size = " + this.lowBorder + ", " + this.highBorder + ", " + this.size);
                }
            } else if (this.size < this.lowBorder) {
                this.setWindow();
                return;
            }
        }
        this.runCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCollection() {
        JvmInternal.runYoungGenerationGc();
        JvmInternal.runFinalization();
        MemoryManager memoryManager = this;
        synchronized (memoryManager) {
            if (this.size < this.highBorder) {
                this.collectionOngoing = false;
                if (this.size < this.lowBorder) {
                    this.setWindow();
                }
                return;
            }
        }
        System.gc();
        JvmInternal.runFinalization();
        memoryManager = this;
        synchronized (memoryManager) {
            this.setWindow();
            this.collectionOngoing = false;
        }
    }

    private static int getInt(String propertyName, int defaultValue) {
        int value = defaultValue;
        String string = System.getProperty(propertyName);
        if (string != null) {
            try {
                value = Integer.parseInt(string);
            }
            catch (NumberFormatException ex) {
                Logger.ELOG(6, "MemoryManager: property \"" + propertyName + "\" value \"" + string + "\" is not integer", ex);
            }
        }
        return value;
    }

    private synchronized void setWindow() {
        this.lowBorder = this.size;
        this.highBorder = this.lowBorder + this.windowSize * 1024;
        if (this.trace) {
            this.traceString("window set to low, high = " + this.lowBorder + ", " + this.highBorder);
        }
    }

    private void traceString(String s) {
        Logger.LOG(6, 4, "MemoryManager: " + s);
    }
}

