/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.satsa;

import com.nokia.mj.impl.utils.OsErrorMessage;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.ConnectionNotFoundException;

public final class APDUError {
    public static final int ERR_ILLEGAL_ARGUMENT = -3100;
    public static final int ERR_INTERRUPTED_IO = -3200;
    public static final int ERR_CONNECTION_NOT_FOUND = -3300;
    public static final int ERR_SECURITY = -3400;
    public static final int ERR_IO = -3500;
    public static final int ERR_CANCEL = -3600;
    public static final String ERR_TXT_NO_SPECIFIC_TXT = "General error";
    public static final String TXT_IA_PARAM_NULL = "Parameter is null";
    public static final int ERR_IA_SELECT_APP = -12;
    public static final String TXT_IA_SELECT_APP = "Card application selection APDU not allowed";
    public static final int ERR_IA_MANAGE_CHANNEL = -13;
    public static final String TXT_IA_MANAGE_CHANNEL = "MANAGE CHANNEL APDU not allowed";
    public static final int ERR_IA_OTHER_CLA = -14;
    public static final String TXT_IA_OTHER_CLA = "CLA byte must be 0x0X, 0x8X, 0x9X or 0xAX if Channel is non-zero";
    public static final int ERR_IA_MALFORMED_APDU = -15;
    public static final String TXT_IA_MALFORMED_APDU = "Parameter contains a malformed APDU";
    public static final int ERR_IA_INVALID_PARAMETER = -16;
    public static final String TXT_IA_INVALID_PARAMETER = "Parameter is invalid";
    public static final int ERR_IA_NOT_AN_ENVELOPE = -17;
    public static final String TXT_IA_NOT_AN_ENVELOPE = "Not an ENVELOPE APDU";
    public static final int ERR_II_CON_CLOSED_DURING = -21;
    public static final String TXT_II_CON_CLOSED_DURING = "Connection closed during exchange operation";
    public static final int ERR_II_CARD_REMOVED = -22;
    public static final String TXT_II_CARD_REMOVED = "Card was removed";
    public static final int ERR_II_BT_SAP_IN_USE = -23;
    public static final String TXT_II_BT_SAP_IN_USE = "BT SAP is in use";
    public static final int ERR_CNT_NO_SLOT = -31;
    public static final String TXT_CNT_NO_SLOT = "Card slot does not exist";
    public static final int ERR_CNT_NO_CARD = -32;
    public static final String TXT_CNT_NO_CARD = "Card is not inserted or powered on";
    public static final int ERR_CNT_NO_APPLICATION = -33;
    public static final String TXT_CNT_NO_APPLICATION = "Card application does not exist or refused selection";
    public static final int ERR_CNT_BT_SAP_IN_USE = -34;
    public static final String TXT_CNT_BT_SAP_IN_USE = "BT Sap is in use";
    public static final int ERR_SEC_NO_RIGHTS_PIN = -41;
    public static final String TXT_SEC_NO_RIGHTS_PIN = "No rights to use PIN method";
    public static final int ERR_SEC_ILLEGAL_APDU = -42;
    public static final String TXT_SEC_ILLEGAL_APDU = "Sending to the card application not allowed";
    public static final int ERR_SEC_ACCESS_NOT_ALLOWED = -43;
    public static final String TXT_SEC_ACCESS_NOT_ALLOWED = "Accessing the application not allowed";
    public static final int ERR_SEC_ILLEGAL_FILE_ID = -44;
    public static final String TXT_SEC_ILLEGAL_FILE_ID = "Illegal AID";
    public static final int ERR_IO_CON_CLOSED_BEFORE = -51;
    public static final String TXT_IO_CON_CLOSED_BEFORE = "Connection was closed before this method was called";
    public static final int ERR_IO_COMM_PROBLEMS = -52;
    public static final String TXT_IO_COMM_PROBLEMS = "General communication error";
    public static final int ERR_IO_ERROR_IO = -53;
    public static final String TXT_IO_ERROR_IO = "I/O error";
    public static final int ERR_IO_NO_FREE_CHANNELS = -54;
    public static final String TXT_IO_NO_FREE_CHANNELS = "No free channels or other I/O error";
    public static String[] iIllegalArgumentTexts = new String[]{"Parameter is null", "Card application selection APDU not allowed", "MANAGE CHANNEL APDU not allowed", "CLA byte must be 0x0X, 0x8X, 0x9X or 0xAX if Channel is non-zero", "Parameter contains a malformed APDU", "Parameter is invalid", "Not an ENVELOPE APDU"};
    public static String[] iInterruptedIOTexts = new String[]{"Connection closed during exchange operation", "Card was removed", "BT SAP is in use"};
    public static String[] iConnectionNotFoundTexts = new String[]{"Card slot does not exist", "Card is not inserted or powered on", "Card application does not exist or refused selection", "BT Sap is in use"};
    public static String[] iSecurityTexts = new String[]{"No rights to use PIN method", "Sending to the card application not allowed", "Accessing the application not allowed", "Illegal AID"};
    public static String[] iIOTexts = new String[]{"Connection was closed before this method was called", "General communication error", "I/O error", "No free channels or other I/O error"};

    private APDUError() {
    }

    public static int check(int aError, boolean aCheckIllegalArg, boolean aCheckSecurity, boolean aCheckConnNotFound, boolean aCheckInterruptedIO, boolean aIOasADefault) throws IOException {
        if (aError < 0) {
            if (aError == -4) {
                throw new OutOfMemoryError();
            }
            if (aCheckIllegalArg && APDUError.belongsToErrorCategory(aError, -3100)) {
                throw new IllegalArgumentException(APDUError.getExceptionText(aError, -3100, iIllegalArgumentTexts));
            }
            if (aCheckSecurity && APDUError.belongsToErrorCategory(aError, -3400)) {
                throw new SecurityException(APDUError.getExceptionText(aError, -3400, iSecurityTexts));
            }
            if (aCheckConnNotFound && APDUError.belongsToErrorCategory(aError, -3300)) {
                throw new ConnectionNotFoundException(APDUError.getExceptionText(aError, -3300, iConnectionNotFoundTexts));
            }
            if (aCheckInterruptedIO && APDUError.belongsToErrorCategory(aError, -3200)) {
                throw new InterruptedIOException(APDUError.getExceptionText(aError, -3200, iInterruptedIOTexts));
            }
            if (aIOasADefault) {
                String errorTxt = OsErrorMessage.getErrorMessage(aError);
                if (APDUError.belongsToErrorCategory(aError, -3500)) {
                    errorTxt = APDUError.getExceptionText(aError, -3500, iIOTexts);
                }
                throw new IOException(errorTxt);
            }
        }
        return aError;
    }

    private static boolean belongsToErrorCategory(int aError, int aErrorCategory) {
        return aError / 100 == aErrorCategory / 100;
    }

    private static String getExceptionText(int aError, int aErrorCategory, String[] aErrTxtArray) {
        int decas;
        int decasFull;
        String exceptionText = ERR_TXT_NO_SPECIFIC_TXT;
        int detailedErrorValue = Math.abs(aError - aErrorCategory);
        int index = detailedErrorValue - (decasFull = (decas = detailedErrorValue / 10) * 10);
        if (index != 0 && aErrTxtArray.length >= index) {
            exceptionText = aErrTxtArray[index - 1];
        }
        return exceptionText;
    }
}

