/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.common;

import com.nokia.mj.impl.security.midp.common.AuthorizationRestriction;
import com.nokia.mj.impl.utils.Base64;
import com.nokia.mj.impl.utils.Tokenizer;
import com.nokia.mj.impl.utils.exception.InvalidAttributeException;

public class AuthorizationRestrictionAttribute
extends AuthorizationRestriction {
    public static final String MAIN_ATTRIBUTE_PREFIX = "MIDlet-Access-Auth-Type-";
    public static final String SECOND_ATTRIBUTE_PREFIX = "MIDlet-Access-Auth-Cert-";
    public static final String ANY = "ANY";
    public static final String SELF = "SELF";
    private String mainAttrName = null;
    private String secondAttrName = null;

    public AuthorizationRestrictionAttribute(String mainAttrName, String mainAttrValue, String secondAttrName, String secondAttrValue) {
        if (mainAttrValue == null) {
            if (secondAttrValue == null) {
                return;
            }
            String[] aliasTokens = Tokenizer.split(secondAttrValue, " ");
            if (aliasTokens == null || aliasTokens.length != 2 || Base64.decode(aliasTokens[1]) == null) {
                throw new InvalidAttributeException(3, null, 7, new String[]{secondAttrName}, 907);
            }
            throw new InvalidAttributeException(3, null, 4, new String[]{mainAttrName}, 907);
        }
        String[] tokens = Tokenizer.split(mainAttrValue, ";");
        if (tokens == null || tokens.length != 3) {
            throw new InvalidAttributeException(3, null, 7, new String[]{mainAttrName}, 907);
        }
        String[] domainTokens = Tokenizer.split(tokens[0], "=");
        String[] vendorTokens = Tokenizer.split(tokens[1], "=");
        String[] signerTokens = Tokenizer.split(tokens[2], "=");
        if (domainTokens == null || domainTokens.length != 2 || vendorTokens == null || vendorTokens.length != 2 || signerTokens == null || signerTokens.length != 2) {
            throw new InvalidAttributeException(3, null, 7, new String[]{mainAttrName}, 907);
        }
        domainTokens[0] = domainTokens[0].trim();
        domainTokens[1] = domainTokens[1].trim();
        vendorTokens[0] = vendorTokens[0].trim();
        vendorTokens[1] = vendorTokens[1].trim();
        signerTokens[0] = signerTokens[0].trim();
        if (!(domainTokens[0].equalsIgnoreCase("domain") && (domainTokens[1].equalsIgnoreCase(SELF) || domainTokens[1].equalsIgnoreCase(ANY)) && vendorTokens[0].equalsIgnoreCase("vendor") && signerTokens[0].equalsIgnoreCase("signer"))) {
            throw new InvalidAttributeException(3, null, 7, new String[]{mainAttrName}, 907);
        }
        this.domain = domainTokens[1];
        this.vendor = vendorTokens[1];
        this.signer = signerTokens[1];
        if (!signerTokens[1].equalsIgnoreCase(ANY)) {
            for (int i = 0; i < signerTokens[1].length(); ++i) {
                boolean isAlpha;
                char c = signerTokens[1].charAt(i);
                boolean bl = isAlpha = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
                if (isAlpha && c != ' ') continue;
                throw new InvalidAttributeException(3, null, 7, new String[]{mainAttrName}, 907);
            }
            if (secondAttrValue == null) {
                throw new InvalidAttributeException(3, null, 4, new String[]{secondAttrName}, 907);
            }
            String[] aliasTokens = Tokenizer.split(secondAttrValue, " ");
            if (aliasTokens == null || aliasTokens.length != 2 || !aliasTokens[0].equalsIgnoreCase(signerTokens[1]) || Base64.decode(aliasTokens[1]) == null) {
                throw new InvalidAttributeException(3, null, 7, new String[]{secondAttrName}, 907);
            }
            this.signer = aliasTokens[1];
        }
        this.mainAttrName = mainAttrName;
        this.secondAttrName = secondAttrName;
    }

    public String getMainAttributeName() {
        return this.mainAttrName;
    }

    public String getSecondAttributeName() {
        return this.secondAttrName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nDOMAIN: " + this.domain);
        sb.append("\nVENDOR: " + this.vendor);
        sb.append("\nSIGNER: " + this.signer);
        return sb.toString();
    }
}

