/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.sensor;

import com.nokia.mj.impl.sensor.ConditionWrapper;
import com.nokia.mj.impl.sensor.DataImpl;
import com.nokia.mj.impl.sensor.SensorConnectionImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.sensor.Channel;
import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Condition;
import javax.microedition.sensor.ConditionListener;
import javax.microedition.sensor.Data;
import javax.microedition.sensor.LimitCondition;
import javax.microedition.sensor.ObjectCondition;
import javax.microedition.sensor.RangeCondition;
import javax.microedition.sensor.SensorConnection;

class ChannelImpl
implements Channel {
    private final ChannelInfo iChannelInfo;
    private final SensorConnectionImpl iSensor;
    private ConditionContainer iConditionContainer;
    private int iConnectionNativeHandle = 0;
    private int iChannelId;
    private static final Condition[] NO_CONDITIONS = new Condition[0];
    private static final String SCHEME_CHANNEL = "channel=";
    private static final String SCHEME_SEP2 = "&";
    private static final String SCHEME_LIMIT = "limit=";
    private static final String SCHEME_OP = "op=";
    private static final String SCHEME_LOWER = "lowerLimit=";
    private static final String SCHEME_LOWER_OP = "lowerOp=";
    private static final String SCHEME_UPPER = "upperLimit=";
    private static final String SCHEME_UPPER_OP = "upperOp=";
    private static final int OP_EQUALS = 0;
    private static final int OP_GREATER_THAN = 1;
    private static final int OP_GREATER_THAN_OR_EQUALS = 2;
    private static final int OP_LESS_THAN = 3;
    private static final int OP_LESS_THAN_OR_EQUALS = 4;
    private static final int OP_DISABLED = -1;

    public ChannelImpl(SensorConnectionImpl aConnection, ChannelInfo aInfo, int aNativeConnectionHandle, int aChannelId) {
        this.iChannelInfo = aInfo;
        this.iSensor = aConnection;
        this.iConnectionNativeHandle = aNativeConnectionHandle;
        this.iChannelId = aChannelId;
        this.iConditionContainer = new ConditionContainer();
    }

    public synchronized void addCondition(ConditionListener aListener, Condition aCondition) {
        this.closeCheck("Adding condition ");
        if (aListener == null) {
            throw new NullPointerException("Adding condition failed: listener is null");
        }
        if (aCondition == null) {
            throw new NullPointerException("Adding condition failed: condtion is null");
        }
        int dataType = this.iChannelInfo.getDataType();
        if (dataType == 4) {
            if (aCondition instanceof LimitCondition || aCondition instanceof RangeCondition) {
                throw new IllegalArgumentException("Adding condition failed: numeric condition is not accepted for object type channel");
            }
        } else if (aCondition instanceof ObjectCondition) {
            throw new IllegalArgumentException("Adding condition failed: ObjectCondition is not accepted for numeric value channel");
        }
        ConditionWrapper wrapper = new ConditionWrapper(aCondition);
        int nativeId = 0;
        if (this.iConditionContainer.addCondition(aListener, wrapper)) {
            if (aCondition instanceof LimitCondition) {
                LimitCondition lc = (LimitCondition)aCondition;
                nativeId = this._addCondition(this.iConnectionNativeHandle, this.iChannelId, lc.getLimit(), -1.0, ChannelImpl.getIntOp(lc.getOperator()), -1);
            } else if (aCondition instanceof RangeCondition) {
                RangeCondition rc = (RangeCondition)aCondition;
                nativeId = this._addCondition(this.iConnectionNativeHandle, this.iChannelId, rc.getLowerLimit(), rc.getUpperLimit(), ChannelImpl.getIntOp(rc.getLowerOp()), ChannelImpl.getIntOp(rc.getUpperOp()));
            }
            if (nativeId < 0) {
                throw new Error("Adding condition failed: Symbian OS error " + nativeId);
            }
            wrapper.setNativeId(nativeId);
            this.iConditionContainer.updateCustomConditionCount(nativeId);
            this.iSensor.startConditionListening(this.iConditionContainer.hasCustomConditions() ? 1 : 0);
        }
    }

    public ChannelInfo getChannelInfo() {
        return this.iChannelInfo;
    }

    public synchronized Condition[] getConditions(ConditionListener aListener) {
        if (aListener == null) {
            throw new NullPointerException("Getting conditons failed: listener is null");
        }
        return this.iConditionContainer.getConditions(aListener);
    }

    public synchronized String getChannelUrl() {
        StringBuffer urlBuf = new StringBuffer();
        Enumeration e = this.iConditionContainer.getAllConditions(true);
        if (e.hasMoreElements()) {
            urlBuf.append(SCHEME_CHANNEL + this.iChannelInfo.getName() + SCHEME_SEP2);
        }
        while (e.hasMoreElements()) {
            urlBuf.append(ChannelImpl.getUrl(((ConditionWrapper)e.nextElement()).unwrap()));
            if (!e.hasMoreElements()) continue;
            urlBuf.append(SCHEME_SEP2);
        }
        return urlBuf.toString();
    }

    public synchronized void removeAllConditions() {
        this.closeCheck("Removing all conditons ");
        Enumeration conditions = this.iConditionContainer.getAllConditions(false);
        while (conditions.hasMoreElements()) {
            this.removeCondition((ConditionWrapper)conditions.nextElement(), true);
        }
        this.iConditionContainer.clear();
        this.iSensor.stopConditionListening();
    }

    public synchronized void removeCondition(ConditionListener listener, Condition condition) {
        this.closeCheck("Removing Conditon ");
        if (listener == null) {
            throw new NullPointerException("Removing condition failed: listener is null");
        }
        if (condition == null) {
            throw new NullPointerException("Removing condition failed: condition is null");
        }
        ConditionWrapper wrapped = this.iConditionContainer.removeCondition(listener, condition);
        if (wrapped != null) {
            this.removeCondition(wrapped, true);
        }
    }

    private void removeCondition(ConditionWrapper aCondition, boolean aNativeRemove) {
        if (aCondition.getNativeId() > 0 && aNativeRemove) {
            this._removeCondition(this.iConnectionNativeHandle, aCondition.getNativeId());
        } else if (!this.iConditionContainer.hasCustomConditions() && aCondition.getNativeId() <= 0) {
            this.iSensor.startConditionListening(0);
        }
        if (this.iConditionContainer.iConditionCount == 0) {
            this.iSensor.stopConditionListening();
        }
    }

    public synchronized void removeConditionListener(ConditionListener listener) {
        this.closeCheck("Removing ConditionListener ");
        if (listener == null) {
            throw new NullPointerException("Removing ConditionListener failed: listener is null");
        }
        Condition[] conditions = this.iConditionContainer.getConditions(listener);
        for (int i = 0; i < conditions.length; ++i) {
            this.removeCondition(listener, conditions[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void conditionMet(int aNativeId, double aValue, long aTimeStamp) {
        Object[] values;
        DataImpl data = null;
        long[] timeStamps = new long[]{aTimeStamp};
        boolean[] validities = new boolean[]{true};
        if (this.iChannelInfo.getDataType() == 2) {
            values = new int[]{(int)aValue};
            data = new DataImpl(this.iChannelInfo, (int[])values, timeStamps, validities);
        } else if (this.iChannelInfo.getDataType() == 1) {
            values = new double[]{aValue};
            data = new DataImpl(this.iChannelInfo, (double[])values, timeStamps, validities);
        } else {
            return;
        }
        Vector metConditions = new Vector();
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            Hashtable listenerTable = this.iConditionContainer.getListeners();
            Enumeration listeners = listenerTable.keys();
            while (listeners.hasMoreElements()) {
                ConditionListener listener = (ConditionListener)listeners.nextElement();
                Vector conditionV = (Vector)listenerTable.get(listener);
                Enumeration e = conditionV.elements();
                while (e.hasMoreElements()) {
                    ConditionWrapper wrapper = (ConditionWrapper)e.nextElement();
                    if (aNativeId <= 0) {
                        if (!wrapper.isMet(aValue)) continue;
                        metConditions.addElement(new ConditionCallback(listener, wrapper.unwrap()));
                        this.iConditionContainer.removeCondition(listener, wrapper.unwrap());
                        this.removeCondition(wrapper, false);
                        continue;
                    }
                    if (wrapper.getNativeId() != aNativeId) continue;
                    ConditionCallback cb = new ConditionCallback(listener, wrapper.unwrap());
                    metConditions.addElement(cb);
                    this.iConditionContainer.removeCondition(listener, wrapper.unwrap());
                    this.removeCondition(wrapper, false);
                }
            }
        }
        Enumeration e = metConditions.elements();
        while (e.hasMoreElements()) {
            ConditionCallback cb = (ConditionCallback)e.nextElement();
            cb.call(this.iSensor, data);
        }
    }

    protected boolean hasConditions() {
        return this.iConditionContainer.iConditionCount > 0;
    }

    private void closeCheck(String aReason) {
        if (this.iSensor.getState() == 4) {
            throw new IllegalStateException(aReason + "failed: SensorConnection is closed");
        }
    }

    private static String getUrl(Condition aCondition) {
        if (aCondition instanceof LimitCondition) {
            LimitCondition c = (LimitCondition)aCondition;
            return SCHEME_LIMIT + c.getLimit() + SCHEME_SEP2 + SCHEME_OP + c.getOperator();
        }
        if (aCondition instanceof RangeCondition) {
            RangeCondition c = (RangeCondition)aCondition;
            return SCHEME_LOWER + c.getLowerLimit() + SCHEME_SEP2 + SCHEME_LOWER_OP + c.getLowerOp() + SCHEME_SEP2 + SCHEME_UPPER + c.getUpperLimit() + SCHEME_SEP2 + SCHEME_UPPER_OP + c.getUpperOp();
        }
        return "";
    }

    private static int getIntOp(String aOp) {
        if ("eq".equals(aOp)) {
            return 0;
        }
        if ("gt".equals(aOp)) {
            return 1;
        }
        if ("ge".equals(aOp)) {
            return 2;
        }
        if ("lt".equals(aOp)) {
            return 3;
        }
        if ("le".equals(aOp)) {
            return 4;
        }
        return -1;
    }

    private native int _addCondition(int var1, int var2, double var3, double var5, int var7, int var8);

    private native int _removeCondition(int var1, int var2);

    class ConditionContainer {
        private Hashtable iConditionListeners = new Hashtable();
        private int iCustomConditionCount = 0;
        int iConditionCount = 0;

        ConditionContainer() {
        }

        public boolean addCondition(ConditionListener aListener, ConditionWrapper aCondition) {
            Vector conditions = null;
            if (this.iConditionListeners.containsKey(aListener)) {
                conditions = (Vector)this.iConditionListeners.get(aListener);
            } else {
                conditions = new Vector();
                this.iConditionListeners.put(aListener, conditions);
            }
            if (!conditions.contains(aCondition)) {
                conditions.addElement(aCondition);
                ++this.iConditionCount;
                return true;
            }
            return false;
        }

        public void updateCustomConditionCount(int aNativeId) {
            if (aNativeId <= 0) {
                ++this.iCustomConditionCount;
            }
        }

        public void clear() {
            this.iCustomConditionCount = 0;
            this.iConditionCount = 0;
            this.iConditionListeners.clear();
        }

        public Condition[] getConditions(ConditionListener aListener) {
            Condition[] retVal = null;
            if (this.iConditionListeners.containsKey(aListener)) {
                Vector conditions = (Vector)this.iConditionListeners.get(aListener);
                retVal = new Condition[conditions.size()];
                for (int i = 0; i < retVal.length; ++i) {
                    retVal[i] = ((ConditionWrapper)conditions.elementAt(i)).unwrap();
                }
            } else {
                retVal = NO_CONDITIONS;
            }
            return retVal;
        }

        public Hashtable getListeners() {
            return this.iConditionListeners;
        }

        public Enumeration getAllConditions(boolean aUnique) {
            Vector retVal = new Vector();
            Enumeration conditionVectors = this.iConditionListeners.elements();
            while (conditionVectors.hasMoreElements()) {
                Vector conditionVector = (Vector)conditionVectors.nextElement();
                Enumeration conditions = conditionVector.elements();
                while (conditions.hasMoreElements()) {
                    Condition condition = (Condition)conditions.nextElement();
                    if (aUnique && retVal.contains(condition)) continue;
                    retVal.addElement(condition);
                }
            }
            return retVal.elements();
        }

        public ConditionWrapper removeCondition(ConditionListener aListener, Condition aCondition) {
            ConditionWrapper condition = null;
            if (this.iConditionListeners.containsKey(aListener)) {
                Vector conditions = (Vector)this.iConditionListeners.get(aListener);
                Enumeration e = conditions.elements();
                while (e.hasMoreElements()) {
                    condition = (ConditionWrapper)e.nextElement();
                    if (!condition.equals(aCondition)) continue;
                    conditions.removeElement(condition);
                    if (condition.getNativeId() <= 0) {
                        --this.iCustomConditionCount;
                    }
                    --this.iConditionCount;
                    break;
                }
            }
            return condition;
        }

        public boolean hasCustomConditions() {
            return this.iCustomConditionCount > 0;
        }
    }

    class ConditionCallback {
        private Condition iCondition;
        private ConditionListener iListener;

        public ConditionCallback(ConditionListener aListener, Condition aCondition) {
            this.iCondition = aCondition;
            this.iListener = aListener;
        }

        public void call(SensorConnection aSensor, Data aData) {
            this.iListener.conditionMet(aSensor, aData, this.iCondition);
        }
    }
}

