/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.sensor;

import javax.microedition.sensor.ChannelInfo;
import javax.microedition.sensor.Data;

final class DataImpl
implements Data {
    private final ChannelInfo iChannel;
    private double[] iDoubleValues = null;
    private int[] iIntValues = null;
    private Object[] iObjectValues = null;
    private long[] iTimestamps = null;
    private boolean[] iValidities = null;
    private boolean iIsUncertainties = true;

    DataImpl(ChannelInfo aChannel) {
        this.iChannel = aChannel;
    }

    DataImpl(ChannelInfo aChannel, double[] aValues, long[] aTimeStamps, boolean[] aValidities) {
        this.iChannel = aChannel;
        this.iDoubleValues = aValues;
        this.iTimestamps = aTimeStamps;
        this.iValidities = aValidities;
    }

    DataImpl(ChannelInfo aChannel, int[] aValues, long[] aTimeStamps, boolean[] aValidities) {
        this.iChannel = aChannel;
        this.iIntValues = aValues;
        this.iTimestamps = aTimeStamps;
        this.iValidities = aValidities;
    }

    void prepareData(boolean aIsUncertainties) {
        this.iIsUncertainties = aIsUncertainties;
    }

    public ChannelInfo getChannelInfo() {
        return this.iChannel;
    }

    public double[] getDoubleValues() {
        if (this.iChannel.getDataType() != 1) {
            throw new IllegalStateException("Data type 'double' is invalid for this channel. Call " + this.getRightMethod() + " instead");
        }
        return this.iDoubleValues;
    }

    public int[] getIntValues() {
        if (this.getChannelInfo().getDataType() != 2) {
            throw new IllegalStateException("Data type 'int' is invalid for this channel. Call " + this.getRightMethod() + " instead");
        }
        return this.iIntValues;
    }

    public long getTimestamp(int index) {
        if (this.iTimestamps == null) {
            throw new IllegalStateException("Timestamp information not available");
        }
        return this.iTimestamps[index];
    }

    public float getUncertainty(int index) {
        int length;
        if (!this.iIsUncertainties) {
            throw new IllegalStateException("Uncertainty information not available");
        }
        int n = length = this.iIntValues != null ? this.iIntValues.length : this.iDoubleValues.length;
        if (index >= length || index < 0) {
            throw new IndexOutOfBoundsException("Index of data value is out of range: " + index);
        }
        if (this.iChannel.getAccuracy() < 0.0f) {
            return 0.0f;
        }
        float value = 0.0f;
        value = this.iIntValues != null ? (float)this.iIntValues[index] * this.iChannel.getAccuracy() : (float)(this.iDoubleValues[index] * (double)this.iChannel.getAccuracy());
        return Math.abs(value);
    }

    public Object[] getObjectValues() {
        if (this.iChannel.getDataType() != 4) {
            throw new IllegalStateException("Data type 'object' is invalid for this channel. Call " + this.getRightMethod() + " instead.");
        }
        return this.iObjectValues;
    }

    public boolean isValid(int index) {
        if (this.iValidities == null) {
            throw new IllegalStateException("Validity information not available");
        }
        return this.iValidities[index];
    }

    private String getRightMethod() {
        switch (this.iChannel.getDataType()) {
            case 2: {
                return "getIntValues()";
            }
            case 1: {
                return "getDoubleValues()";
            }
            case 4: {
                return "getObjectValues()";
            }
        }
        return "";
    }
}

