/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.smscbs.utils;

public final class WmaUrl {
    public static final boolean SERVER_CONNECTION = true;
    public static final boolean CLIENT_CONNECTION = false;
    private static final String SMS_PROTOCOL = "sms";
    private static final String CBS_PROTOCOL = "cbs";
    private static final String INVALID_URL = "Invalid URL: ";
    private static final int MAX_PORT = 65535;
    private static final int[] RESTRICTED_PORTS = new int[]{2805, 2923, 2948, 2949, 5502, 5503, 5508, 5511, 5512, 9200, 9201, 9202, 9203, 9207, 49996, 49999};
    private int iPortVal;
    private String iHost;
    private String iPort;
    private String iAbsoluteUri;
    private String iProtocol;

    public WmaUrl(String aUri) {
        this.iAbsoluteUri = aUri;
    }

    public WmaUrl(String aUri, String aProtocol) {
        this.iAbsoluteUri = aProtocol + aUri;
    }

    public String getProtocol() {
        return this.iProtocol;
    }

    public void validateUri() throws IllegalArgumentException {
        int index = this.iAbsoluteUri.indexOf("://");
        int nameLength = this.iAbsoluteUri.length();
        if (index == -1 || index != this.iAbsoluteUri.indexOf(58) || index + 3 > nameLength) {
            throw new IllegalArgumentException(INVALID_URL.concat(this.iAbsoluteUri));
        }
        this.iProtocol = this.iAbsoluteUri.substring(0, index);
        if (this.iProtocol.compareTo(SMS_PROTOCOL) != 0 && this.iProtocol.compareTo(CBS_PROTOCOL) != 0) {
            throw new IllegalArgumentException(INVALID_URL.concat(this.iAbsoluteUri));
        }
        String subUri = this.iAbsoluteUri.substring(index + 3, nameLength);
        nameLength = subUri.length();
        index = subUri.indexOf(58);
        if (index >= 0) {
            this.iHost = subUri.substring(0, index);
            this.iPort = subUri.substring(index + 1, nameLength);
        } else if (index < 0) {
            this.iHost = subUri;
        }
        if (0 != this.iHost.length()) {
            if (0 == this.iProtocol.compareTo(CBS_PROTOCOL)) {
                throw new IllegalArgumentException(INVALID_URL.concat(this.iAbsoluteUri));
            }
            nameLength = this.iHost.length();
            this.validateHost(this.iHost, nameLength);
        }
        if ("".equals(this.iPort)) {
            throw new IllegalArgumentException(INVALID_URL.concat(this.iAbsoluteUri));
        }
        if (this.iPort != null) {
            this.validatePort(this.iPort);
        }
    }

    public String getHost() {
        return this.iHost;
    }

    public String getPort() {
        return this.iPort;
    }

    public int getPortVal() {
        return this.iPortVal;
    }

    public String getAbsoluteUri() {
        return this.iAbsoluteUri;
    }

    public boolean isServerModeConnection() {
        return this.iHost.length() == 0;
    }

    private void validatePort(String aPort) {
        for (int p = 0; p < aPort.length(); ++p) {
            if (Character.isDigit(aPort.charAt(p))) continue;
            throw new IllegalArgumentException(INVALID_URL.concat(this.iAbsoluteUri));
        }
        this.iPortVal = Integer.parseInt(aPort);
        if (this.iPortVal > 65535 || this.iPortVal < 0) {
            throw new IllegalArgumentException("Invalid Port: ".concat(aPort));
        }
    }

    public boolean isRestrictedPort() {
        int aLength = RESTRICTED_PORTS.length;
        if (this.iProtocol != CBS_PROTOCOL) {
            for (int p = 0; p < aLength && this.iPortVal >= RESTRICTED_PORTS[p]; ++p) {
                if (this.iPortVal != RESTRICTED_PORTS[p]) continue;
                return true;
            }
        }
        return false;
    }

    private void validateHost(String aHost, int aLength) {
        for (int p = 0; p < aLength; ++p) {
            char ch = aHost.charAt(p);
            if (p == 0 && ch == '+' || Character.isDigit(ch)) continue;
            throw new IllegalArgumentException(INVALID_URL.concat(this.iAbsoluteUri));
        }
    }
}

