/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.tckrunner;

import com.nokia.mj.impl.rt.support.JvmInternal;
import com.nokia.mj.impl.rt.support.ThreadEventListener;
import com.nokia.mj.impl.tckrunner.TckRunner;
import com.nokia.mj.impl.tckrunner.TckRunnerUi;
import com.nokia.mj.impl.utils.Logger;

public class TckRunnerMain {
    public static void main(String[] aArgs) {
        Logger.LOG(18, 4, "TckRunnerMain.main starts");
        int exitCode = 0;
        try {
            JvmInternal.setThreadEventListener(new ThreadEventListener(){

                public void threadStarting(Thread newThread, Thread parentThread) {
                }

                public void threadDied(Thread thread) {
                }

                public void uncaughtException(Thread thread, Throwable throwable) {
                    String threadName = null;
                    if (thread != null) {
                        threadName = thread.getName();
                    }
                    Logger.ELOG(18, "Unhandled exception in " + threadName, throwable);
                }
            });
            exitCode = TckRunnerMain.mainWithResult(aArgs);
        }
        catch (Throwable t) {
            Logger.ELOG(18, "Unhandled exception in main", t);
            exitCode = -1;
        }
        Logger.LOG(18, 4, "TckRunnerMain.main exits with code " + exitCode);
        System.exit(exitCode);
    }

    public static int mainWithResult(String[] aArgs) {
        int rc = 0;
        TckRunnerMain.logArgs(aArgs);
        if (aArgs.length == 0) {
            TckRunnerUi ui = new TckRunnerUi();
            ui.show();
        } else if (aArgs.length > 0 && aArgs[0].startsWith("-url=")) {
            try {
                String url = aArgs[0].substring(5);
                String[] installerArgs = new String[aArgs.length - 1];
                System.arraycopy((Object)aArgs, 1, (Object)installerArgs, 0, installerArgs.length);
                TckRunner runner = new TckRunner();
                rc = runner.start(url, installerArgs);
            }
            catch (Exception e) {
                TckRunnerMain.usage(aArgs);
                rc = -1;
            }
        } else if (aArgs.length == 2 && aArgs[0].equals("unittest")) {
            TckRunner runner = new TckRunner();
            rc = runner.startInTestMode(aArgs[1]);
        } else {
            TckRunnerMain.usage(aArgs);
        }
        return rc;
    }

    private static void usage(String[] aArgs) {
        String cmd = "tckrunner";
        String usageMsg = "\n\nUsage: " + cmd + " <command> [installer options]\n" + "\n" + "where command is one of:\n" + "  -help                    Prints help on " + cmd + " usage.\n" + "  -url=<url to JAD>        JavaTest Harness URL. For example:\n" + "                           tckrunner -url=http://server:8080/test/getNextApp.jad\n" + "  <no command>             tckrunner starts in UI mode\n" + "where installer options is one of:\n" + "  -iap=<iap_id>            Internet access point to be used in\n" + "                           downloads during TCK run\n" + "  -snap=<snap_id>          Service network access point to be used in\n" + "                           downloads during TCK run\n" + "\n" + "For a full list of available installer options use:\n" + "  javainstaller help install\n";
        Logger.LOG(18, 1, usageMsg);
    }

    private static void logArgs(String[] aArgs) {
        StringBuffer buf = new StringBuffer("tckrunner args:");
        for (int i = 0; i < aArgs.length; ++i) {
            buf.append(" ");
            buf.append(aArgs[i]);
        }
        Logger.LOG(18, 4, buf.toString());
    }
}

