/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.utils;

import com.nokia.mj.impl.utils.Formatter;
import com.nokia.mj.impl.utils.LineReader;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class ResourceLoader {
    private static final String LOC_RESOURCE_BASE = "/resources/com/nokia/mj/impl/";
    private static Hashtable resourceLoaders = new Hashtable();
    private Hashtable resourceMap = new Hashtable();
    private String prefix;

    public static ResourceLoader getInstance(String resourceName, String prefix) {
        String key = resourceName + ":" + prefix;
        ResourceLoader result = (ResourceLoader)resourceLoaders.get(key);
        if (result == null) {
            result = new ResourceLoader(resourceName, prefix);
            resourceLoaders.put(key, result);
        }
        return result;
    }

    public ResourceLoader(String resourceName, String aPrefix) {
        this.prefix = aPrefix;
        this.loadFile(resourceName);
    }

    public Formatter format(String id) {
        return new Formatter(this.string(id));
    }

    public String format(String id, Object[] textParameters) {
        return new Formatter(this.string(id)).format(textParameters);
    }

    public String string(String id) {
        String str = (String)this.resourceMap.get(id);
        if (str == null) {
            str = (String)this.resourceMap.get(this.prefix + id);
            if (str == null) {
                str = !id.startsWith(this.prefix) ? this.prefix + id : id;
                Logger.WLOG(6, "Cannot find resource: " + id);
            }
            this.resourceMap.put(id, str);
        }
        str = this.decode(str);
        str = this.replaceCharacterCodes(str);
        return str;
    }

    public String getLocaleId() {
        int localeId = this._getLocaleId();
        if (localeId > 0) {
            if (localeId < 10) {
                return "0" + Integer.toString(localeId);
            }
            return Integer.toString(localeId);
        }
        return "sc";
    }

    private void loadFile(String resourceName) {
        InputStream is = null;
        is = this.getClass().getResourceAsStream(LOC_RESOURCE_BASE + resourceName + "_" + this.getLocaleId() + ".loc");
        if (is == null) {
            is = this.getClass().getResourceAsStream(LOC_RESOURCE_BASE + resourceName + "_sc" + ".loc");
        }
        if (is == null) {
            is = this.getClass().getResourceAsStream(LOC_RESOURCE_BASE + resourceName + ".loc");
        }
        if (is == null) {
            Logger.WLOG(6, "Cannot load resource file: " + resourceName);
            return;
        }
        try {
            String line;
            LineReader lr = new LineReader(new InputStreamReader(is, "UTF-8"));
            while ((line = lr.readLine()) != null) {
                if (!line.startsWith("#define ")) continue;
                try {
                    line = line.substring(line.indexOf(32)).trim();
                    int idEnd = line.indexOf(32);
                    String id = line.substring(0, idEnd);
                    int strStart = line.indexOf(34, idEnd);
                    int strEnd = line.lastIndexOf(34);
                    String str = line.substring(strStart + 1, strEnd);
                    this.resourceMap.put(id, str);
                }
                catch (IndexOutOfBoundsException ex) {
                    String error = "Incorrect line " + lr.getLineNumber() + "\"" + line + "\"";
                    Logger.WLOG(6, error);
                }
            }
            is.close();
        }
        catch (IOException ex) {
            Logger.WLOG(6, "Resource file " + resourceName + " handling failed: " + ex.getMessage());
        }
    }

    private String decode(String str) {
        str = this.replacePattern(str, "\\n", '\n');
        str = this.replacePattern(str, "\\\\", '\\');
        str = this.replacePattern(str, "\\\"", '\"');
        str = this.replacePattern(str, "\\t", '\t');
        str = this.replacePattern(str, "\\'", '\'');
        return str;
    }

    private String replacePattern(String resource, String pattern, char replacement) {
        StringBuffer sb = new StringBuffer();
        int startIndex = resource.indexOf(pattern);
        if (startIndex != -1) {
            sb.append(resource.substring(0, startIndex)).append(replacement);
            startIndex += pattern.length();
            int endIndex = 0;
            while ((endIndex = resource.indexOf(pattern, startIndex)) != -1) {
                sb.append(resource.substring(startIndex, endIndex)).append(replacement);
                startIndex = endIndex + pattern.length();
            }
            if (startIndex < resource.length()) {
                sb.append(resource.substring(startIndex, resource.length()));
            }
            return sb.toString();
        }
        return resource;
    }

    private String replaceCharacterCodes(String str) {
        StringBuffer sb = new StringBuffer();
        int startIndex = str.indexOf("<0x");
        if (startIndex != -1 && str.charAt(startIndex + 7) == '>') {
            sb.append(str.substring(0, startIndex));
            try {
                int charint = Integer.parseInt(str.substring(startIndex + 3, startIndex + 7), 16);
                sb.append((char)charint);
                int endIndex = 0;
                startIndex += 7;
                while ((endIndex = str.indexOf("<0x", startIndex)) != -1 && str.charAt(endIndex + 7) == '>') {
                    sb.append(str.substring(startIndex + 1, endIndex));
                    charint = Integer.parseInt(str.substring(endIndex + 3, endIndex + 7), 16);
                    sb.append((char)charint);
                    startIndex = endIndex + 7;
                }
            }
            catch (NumberFormatException nfe) {
                Logger.ELOG(6, "Cannot replace character from string: " + str);
                return str;
            }
            if (startIndex < str.length()) {
                sb.append(str.substring(startIndex + 1, str.length()));
            }
            return sb.toString();
        }
        return str;
    }

    private native int _getLocaleId();
}

