/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Writer {
    protected Object lock;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object lock) {
        if (lock == null) {
            throw new NullPointerException();
        }
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char[] oneCharArray = new char[]{(char)oneChar};
            this.write(oneCharArray);
        }
    }

    public void write(String str) throws IOException {
        char[] buf = new char[str.length()];
        str.getChars(0, buf.length, buf, 0);
        this.write(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) throws IOException {
        if (count >= 0) {
            char[] buf = new char[count];
            str.getChars(offset, offset + count, buf, 0);
            Object object = this.lock;
            synchronized (object) {
                this.write(buf);
            }
        } else {
            throw new StringIndexOutOfBoundsException();
        }
    }
}

