/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.ibm.oti.util.BinarySearch;

public final class Character {
    final char value;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    private static final byte UNASSIGNED = 0;
    private static final byte UPPERCASE_LETTER = 1;
    private static final byte LOWERCASE_LETTER = 2;
    private static final byte DECIMAL_DIGIT_NUMBER = 9;
    private static final String typeKeys = "0Aa\u00aa\u00b5\u00ba\u00c0\u00d8\u00df\u00f8\u0100\u0138\u0149\u0179\u017f\u0181\u0183\u0187\u018a\u018c\u018e\u0192\u0194\u0197\u0199\u019c\u019e\u01a0\u01a7\u01ab\u01af\u01b2\u01b4\u01b8\u01ba\u01bc\u01be\u01c4\u01c6\u01c9\u01cc\u01dd\u01f0\u01f3\u01f7\u01f9\u0222\u0250\u0386\u0389\u038c\u038e\u0390\u0392\u03a3\u03ac\u03d0\u03d2\u03d5\u03da\u03f0\u0400\u0430\u0460\u048c\u04c1\u04c7\u04cb\u04d0\u04f8\u0531\u0561\u0660\u06f0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be7\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u10a0\u1369\u17e0\u1810\u1e00\u1e96\u1ea0\u1f00\u1f08\u1f10\u1f18\u1f20\u1f28\u1f30\u1f38\u1f40\u1f48\u1f50\u1f59\u1f5b\u1f5d\u1f5f\u1f61\u1f68\u1f70\u1f80\u1f90\u1fa0\u1fb0\u1fb6\u1fb8\u1fbe\u1fc2\u1fc6\u1fc8\u1fd0\u1fd6\u1fd8\u1fe0\u1fe8\u1ff2\u1ff6\u1ff8\u207f\u2102\u2107\u210a\u210c\u210e\u2110\u2113\u2115\u2119\u2124\u212b\u212f\u2131\u2134\u2139\ufb00\ufb13\uff10\uff21\uff41";
    private static final char[] typeValues = "9\tZ\u0001z\u0002\u00ab\u1502\u00b6\u021c\u00bb\u1602\u00d6\u0001\u00de\u0001\u00f6\u0002\u00ff\u0002\u0137\u0201\u0148\u0102\u0178\u0201\u017e\u0102\u0180\u0002\u0182\u0001\u0186\u0201\u0189\u0102\u018b\u0001\u018d\u0002\u0191\u0001\u0193\u0102\u0196\u0201\u0198\u0001\u019b\u0002\u019d\u0001\u019f\u0102\u01a6\u0201\u01aa\u0102\u01ae\u0201\u01b1\u0102\u01b3\u0001\u01b7\u0102\u01b9\u0201\u01bb\u0502\u01bd\u0201\u01bf\u0002\u01c5\u0301\u01c7\u0102\u01ca\u0201\u01dc\u0102\u01ef\u0201\u01f1\u0102\u01f6\u0201\u01f8\u0001\u021f\u0201\u0233\u0201\u02ad\u0002\u0388\u1801\u038a\u0001\u038c\u0001\u038f\u0001\u0391\u0102\u03a1\u0001\u03ab\u0001\u03ce\u0002\u03d1\u0002\u03d4\u0001\u03d7\u0002\u03ef\u0201\u03f3\u0002\u042f\u0001\u045f\u0002\u0481\u0201\u04c0\u0201\u04c4\u0102\u04c8\u0102\u04cc\u0102\u04f5\u0201\u04f9\u0201\u0556\u0001\u0587\u0002\u0669\t\u06f9\t\u096f\t\u09ef\t\u0a6f\t\u0aef\t\u0b6f\t\u0bef\t\u0c6f\t\u0cef\t\u0d6f\t\u0e59\t\u0ed9\t\u0f29\t\u1049\t\u10c5\u0001\u1371\t\u17e9\t\u1819\t\u1e95\u0201\u1e9b\u0002\u1ef9\u0201\u1f07\u0002\u1f0f\u0001\u1f15\u0002\u1f1d\u0001\u1f27\u0002\u1f2f\u0001\u1f37\u0002\u1f3f\u0001\u1f45\u0002\u1f4d\u0001\u1f57\u0002\u1f59\u0100\u1f5b\u0100\u1f5d\u0100\u1f60\u0102\u1f67\u0002\u1f6f\u0001\u1f7d\u0002\u1f87\u0002\u1f97\u0002\u1fa7\u0002\u1fb4\u0002\u1fb7\u0002\u1fbb\u0001\u1fbf\u1b02\u1fc4\u0002\u1fc7\u0002\u1fcb\u0001\u1fd3\u0002\u1fd7\u0002\u1fdb\u0001\u1fe7\u0002\u1fec\u0001\u1ff4\u0002\u1ff7\u0002\u1ffb\u0001\u2080\u020b\u2103\u1c01\u2108\u011c\u210b\u0102\u210d\u0001\u210f\u0002\u2112\u0001\u2114\u021c\u2116\u011c\u211d\u0001\u212a\u1c01\u212d\u0001\u2130\u0201\u2133\u011c\u2135\u0502\u213a\u021c\ufb06\u0002\ufb17\u0002\uff19\t\uff3a\u0001\uff5a\u0002".getValue();
    private static final String uppercaseKeys = "a\u00b5\u00e0\u00f8\u00ff\u0101\u0131\u0133\u013a\u014b\u017a\u017f\u0183\u0188\u018c\u0192\u0195\u0199\u01a1\u01a8\u01ad\u01b0\u01b4\u01b9\u01bd\u01bf\u01c5\u01c6\u01c8\u01c9\u01cb\u01cc\u01ce\u01dd\u01df\u01f2\u01f3\u01f5\u01f9\u0223\u0253\u0254\u0256\u0259\u025b\u0260\u0263\u0268\u0269\u026f\u0272\u0275\u0280\u0283\u0288\u028a\u0292\u0345\u03ac\u03ad\u03b1\u03c2\u03c3\u03cc\u03cd\u03d0\u03d1\u03d5\u03d6\u03db\u03f0\u03f1\u03f2\u0430\u0450\u0461\u048d\u04c2\u04c8\u04cc\u04d1\u04f9\u0561\u1e01\u1e9b\u1ea1\u1f00\u1f10\u1f20\u1f30\u1f40\u1f51\u1f60\u1f70\u1f72\u1f76\u1f78\u1f7a\u1f7c\u1f80\u1f90\u1fa0\u1fb0\u1fb3\u1fbe\u1fc3\u1fd0\u1fe0\u1fe5\u1ff3\u2170\u24d0\uff41";
    private static final char[] uppercaseValues = "z\uffe0\u00b5\u02e7\u00f6\uffe0\u00fe\uffe0\u00ffy\u812f\uffff\u0131\uff18\u8137\uffff\u8148\uffff\u8177\uffff\u817e\uffff\u017f\ufed4\u8185\uffff\u0188\uffff\u018c\uffff\u0192\uffff\u0195a\u0199\uffff\u81a5\uffff\u01a8\uffff\u01ad\uffff\u01b0\uffff\u81b6\uffff\u01b9\uffff\u01bd\uffff\u01bf8\u01c5\uffff\u01c6\ufffe\u01c8\uffff\u01c9\ufffe\u01cb\uffff\u01cc\ufffe\u81dc\uffff\u01dd\uffb1\u81ef\uffff\u01f2\uffff\u01f3\ufffe\u01f5\uffff\u821f\uffff\u8233\uffff\u0253\uff2e\u0254\uff32\u0257\uff33\u0259\uff36\u025b\uff35\u0260\uff33\u0263\uff31\u0268\uff2f\u0269\uff2d\u026f\uff2d\u0272\uff2b\u0275\uff2a\u0280\uff26\u0283\uff26\u0288\uff26\u028b\uff27\u0292\uff25\u0345T\u03ac\uffda\u03af\uffdb\u03c1\uffe0\u03c2\uffe1\u03cb\uffe0\u03cc\uffc0\u03ce\uffc1\u03d0\uffc2\u03d1\uffc7\u03d5\uffd1\u03d6\uffca\u83ef\uffff\u03f0\uffaa\u03f1\uffb0\u03f2\uffb1\u044f\uffe0\u045f\uffb0\u8481\uffff\u84bf\uffff\u84c4\uffff\u04c8\uffff\u04cc\uffff\u84f5\uffff\u04f9\uffff\u0586\uffd0\u9e95\uffff\u1e9b\uffc5\u9ef9\uffff\u1f07\b\u1f15\b\u1f27\b\u1f37\b\u1f45\b\u9f57\b\u1f67\b\u1f71J\u1f75V\u1f77d\u1f79\u0080\u1f7bp\u1f7d~\u1f87\b\u1f97\b\u1fa7\b\u1fb1\b\u1fb3\t\u1fbe\ue3db\u1fc3\t\u1fd1\b\u1fe1\b\u1fe5\u0007\u1ff3\t\u217f\ufff0\u24e9\uffe6\uff5a\uffe0".getValue();
    private static final String lowercaseKeys = "A\u00c0\u00d8\u0100\u0130\u0132\u0139\u014a\u0178\u0179\u0181\u0182\u0186\u0187\u0189\u018b\u018e\u018f\u0190\u0191\u0193\u0194\u0196\u0197\u0198\u019c\u019d\u019f\u01a0\u01a6\u01a7\u01a9\u01ac\u01ae\u01af\u01b1\u01b3\u01b7\u01b8\u01bc\u01c4\u01c5\u01c7\u01c8\u01ca\u01cb\u01de\u01f1\u01f2\u01f6\u01f7\u01f8\u0222\u0386\u0388\u038c\u038e\u0391\u03a3\u03da\u0400\u0410\u0460\u048c\u04c1\u04c7\u04cb\u04d0\u04f8\u0531\u1e00\u1ea0\u1f08\u1f18\u1f28\u1f38\u1f48\u1f59\u1f68\u1f88\u1f98\u1fa8\u1fb8\u1fba\u1fbc\u1fc8\u1fcc\u1fd8\u1fda\u1fe8\u1fea\u1fec\u1ff8\u1ffa\u1ffc\u2126\u212a\u212b\u2160\u24b6\uff21";
    private static final char[] lowercaseValues = "Z \u00d6 \u00de \u812e\u0001\u0130\uff39\u8136\u0001\u8147\u0001\u8176\u0001\u0178\uff87\u817d\u0001\u0181\u00d2\u8184\u0001\u0186\u00ce\u0187\u0001\u018a\u00cd\u018b\u0001\u018eO\u018f\u00ca\u0190\u00cb\u0191\u0001\u0193\u00cd\u0194\u00cf\u0196\u00d3\u0197\u00d1\u0198\u0001\u019c\u00d3\u019d\u00d5\u019f\u00d6\u81a4\u0001\u01a6\u00da\u01a7\u0001\u01a9\u00da\u01ac\u0001\u01ae\u00da\u01af\u0001\u01b2\u00d9\u81b5\u0001\u01b7\u00db\u01b8\u0001\u01bc\u0001\u01c4\u0002\u01c5\u0001\u01c7\u0002\u01c8\u0001\u01ca\u0002\u81db\u0001\u81ee\u0001\u01f1\u0002\u81f4\u0001\u01f6\uff9f\u01f7\uffc8\u821e\u0001\u8232\u0001\u0386&\u038a%\u038c@\u038f?\u03a1 \u03ab \u83ee\u0001\u040fP\u042f \u8480\u0001\u84be\u0001\u84c3\u0001\u04c7\u0001\u04cb\u0001\u84f4\u0001\u04f8\u0001\u05560\u9e94\u0001\u9ef8\u0001\u1f0f\ufff8\u1f1d\ufff8\u1f2f\ufff8\u1f3f\ufff8\u1f4d\ufff8\u9f5f\ufff8\u1f6f\ufff8\u1f8f\ufff8\u1f9f\ufff8\u1faf\ufff8\u1fb9\ufff8\u1fbb\uffb6\u1fbc\ufff7\u1fcb\uffaa\u1fcc\ufff7\u1fd9\ufff8\u1fdb\uff9c\u1fe9\ufff8\u1feb\uff90\u1fec\ufff9\u1ff9\uff80\u1ffb\uff82\u1ffc\ufff7\u2126\ue2a3\u212a\udf41\u212b\udfba\u216f\u0010\u24cf\u001a\uff3a ".getValue();
    private static final String digitKeys = "0Aa\u0660\u06f0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be7\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1369\u17e0\u1810\uff10\uff21\uff41";
    private static final char[] digitValues = "90Z7zW\u0669\u0660\u06f9\u06f0\u096f\u0966\u09ef\u09e6\u0a6f\u0a66\u0aef\u0ae6\u0b6f\u0b66\u0bef\u0be6\u0c6f\u0c66\u0cef\u0ce6\u0d6f\u0d66\u0e59\u0e50\u0ed9\u0ed0\u0f29\u0f20\u1049\u1040\u1371\u1368\u17e9\u17e0\u1819\u1810\uff19\uff10\uff3a\uff17\uff5a\uff37".getValue();

    public Character(char value) {
        this.value = value;
    }

    public char charValue() {
        return this.value;
    }

    public static int digit(char c, int radix) {
        if (radix >= 2 && radix <= 36) {
            if (c < '\u0080') {
                int result = -1;
                if ('0' <= c && c <= '9') {
                    result = c - 48;
                } else if ('a' <= c && c <= 'z') {
                    result = c - 87;
                } else if ('A' <= c && c <= 'Z') {
                    result = c - 55;
                }
                return result < radix ? result : -1;
            }
            int result = BinarySearch.binarySearchRange(digitKeys, c);
            if (result >= 0 && c <= digitValues[result * 2]) {
                char value = (char)(c - digitValues[result * 2 + 1]);
                if (value >= radix) {
                    return -1;
                }
                return value;
            }
        }
        return -1;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Character && this.value == ((Character)object).value;
    }

    private static int getType(char c) {
        int result = BinarySearch.binarySearchRange(typeKeys, c);
        char high = typeValues[result * 2];
        if (c <= high) {
            char code = typeValues[result * 2 + 1];
            if (code < '\u0100') {
                return code;
            }
            return (c & '\u0001') == 1 ? code >> 8 : code & 0xFF;
        }
        return 0;
    }

    public int hashCode() {
        return this.value;
    }

    public static boolean isDigit(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        if (c < '\u0660') {
            return false;
        }
        return Character.getType(c) == 9;
    }

    public static boolean isLowerCase(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if (c < '\u0080') {
            return false;
        }
        return Character.getType(c) == 2;
    }

    public static boolean isUpperCase(char c) {
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        if (c < '\u0080') {
            return false;
        }
        return Character.getType(c) == 1;
    }

    public static char toLowerCase(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 32);
        }
        if (c < '\u0080') {
            return c;
        }
        int result = BinarySearch.binarySearchRange(lowercaseKeys, c);
        if (result >= 0) {
            char end;
            boolean by2 = false;
            char start = lowercaseKeys.charAt(result);
            if ((start & 0x8000) != ((end = lowercaseValues[result * 2]) & 0x8000)) {
                end = (char)(end ^ 0x8000);
                by2 = true;
            }
            if (c <= end) {
                if (by2 && (c & '\u0001') != (start & '\u0001')) {
                    return c;
                }
                char mapping = lowercaseValues[result * 2 + 1];
                return (char)(c + mapping);
            }
        }
        return c;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static char toUpperCase(char c) {
        if ('a' <= c && c <= 'z') {
            return (char)(c - 32);
        }
        if (c < '\u0080') {
            return c;
        }
        int result = BinarySearch.binarySearchRange(uppercaseKeys, c);
        if (result >= 0) {
            char end;
            boolean by2 = false;
            char start = uppercaseKeys.charAt(result);
            if ((start & 0x8000) != ((end = uppercaseValues[result * 2]) & 0x8000)) {
                end = (char)(end ^ 0x8000);
                by2 = true;
            }
            if (c <= end) {
                if (by2 && (c & '\u0001') != (start & '\u0001')) {
                    return c;
                }
                char mapping = uppercaseValues[result * 2 + 1];
                return (char)(c + mapping);
            }
        }
        return c;
    }
}

