/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StringBuffer {
    private static final int INITIAL_SIZE = 16;
    private int count;
    private char[] value;
    private boolean shared;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int capacity) {
        this.count = 0;
        this.value = new char[capacity];
    }

    public StringBuffer(String string) {
        this.count = string.length();
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    public synchronized StringBuffer append(char[] chars) {
        int newSize = this.count + chars.length;
        if (newSize > this.value.length) {
            this.ensureCapacityImpl(newSize);
        } else if (this.shared) {
            this.cloneValue();
            this.shared = false;
        }
        System.arraycopy((Object)chars, 0, (Object)this.value, this.count, chars.length);
        this.count = newSize;
        return this;
    }

    public synchronized StringBuffer append(char[] chars, int start, int length) {
        if (start >= 0 && length >= 0 && length <= chars.length - start) {
            int newSize = this.count + length;
            if (newSize > this.value.length) {
                this.ensureCapacityImpl(newSize);
            } else if (this.shared) {
                this.cloneValue();
                this.shared = false;
            }
            System.arraycopy((Object)chars, start, (Object)this.value, this.count, length);
            this.count = newSize;
            return this;
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer append(char ch) {
        if (this.count >= this.value.length) {
            this.ensureCapacityImpl(this.count + 1);
        }
        if (this.shared) {
            this.cloneValue();
            this.shared = false;
        }
        this.value[this.count] = ch;
        ++this.count;
        return this;
    }

    public StringBuffer append(double value) {
        return this.append(String.valueOf(value));
    }

    public StringBuffer append(float value) {
        return this.append(String.valueOf(value));
    }

    public StringBuffer append(int value) {
        return this.append(Integer.toString(value));
    }

    public StringBuffer append(long value) {
        return this.append(Long.toString(value));
    }

    public StringBuffer append(Object value) {
        return this.append(String.valueOf(value));
    }

    public synchronized StringBuffer append(String string) {
        int adding;
        int newSize;
        if (string == null) {
            string = String.valueOf(string);
        }
        if ((newSize = this.count + (adding = string.length())) > this.value.length) {
            this.ensureCapacityImpl(newSize);
        } else if (this.shared) {
            this.cloneValue();
            this.shared = false;
        }
        string.getChars(0, adding, this.value, this.count);
        this.count = newSize;
        return this;
    }

    public StringBuffer append(boolean value) {
        return this.append(String.valueOf(value));
    }

    public int capacity() {
        return this.value.length;
    }

    public synchronized char charAt(int index) {
        try {
            if (index < this.count) {
                return this.value[index];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized StringBuffer delete(int start, int end) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end > start) {
                int length = this.count - end;
                if (length > 0) {
                    try {
                        if (!this.shared) {
                            System.arraycopy((Object)this.value, end, (Object)this.value, start, length);
                        } else {
                            char[] newData = new char[this.value.length];
                            System.arraycopy((Object)this.value, 0, (Object)newData, 0, start);
                            System.arraycopy((Object)this.value, end, (Object)newData, start, length);
                            this.value = newData;
                            this.shared = false;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new StringIndexOutOfBoundsException();
                    }
                }
                this.count -= end - start;
                return this;
            }
            if (start == end) {
                return this;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer deleteCharAt(int location) {
        if (location >= 0 && location < this.count) {
            int length = this.count - location - 1;
            if (length > 0) {
                try {
                    if (!this.shared) {
                        System.arraycopy((Object)this.value, location + 1, (Object)this.value, location, length);
                    } else {
                        char[] newData = new char[this.value.length];
                        System.arraycopy((Object)this.value, 0, (Object)newData, 0, location);
                        System.arraycopy((Object)this.value, location + 1, (Object)newData, location, length);
                        this.value = newData;
                        this.shared = false;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new StringIndexOutOfBoundsException(location);
                }
            }
            --this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(location);
    }

    public synchronized void ensureCapacity(int min) {
        if (min > this.value.length) {
            this.ensureCapacityImpl(min);
        }
    }

    private void ensureCapacityImpl(int min) {
        int twice = (this.value.length << 1) + 2;
        char[] newData = new char[min > twice ? min : twice];
        System.arraycopy((Object)this.value, 0, (Object)newData, 0, this.count);
        this.value = newData;
        this.shared = false;
    }

    public synchronized void getChars(int start, int end, char[] buffer, int index) {
        try {
            if (start <= this.count && end <= this.count) {
                System.arraycopy((Object)this.value, start, (Object)buffer, index, end - start);
                return;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        throw new StringIndexOutOfBoundsException();
    }

    public synchronized StringBuffer insert(int index, char[] chars) {
        if (index >= 0 && index <= this.count) {
            this.move(chars.length, index);
            System.arraycopy((Object)chars, 0, (Object)this.value, index, chars.length);
            this.count += chars.length;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public synchronized StringBuffer insert(int index, char ch) {
        if (index >= 0 && index <= this.count) {
            this.move(1, index);
            this.value[index] = ch;
            ++this.count;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuffer insert(int index, double value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuffer insert(int index, float value) {
        return this.insert(index, String.valueOf(value));
    }

    public StringBuffer insert(int index, int value) {
        return this.insert(index, Integer.toString(value));
    }

    public StringBuffer insert(int index, long value) {
        return this.insert(index, Long.toString(value));
    }

    public StringBuffer insert(int index, Object value) {
        return this.insert(index, String.valueOf(value));
    }

    public synchronized StringBuffer insert(int index, String string) {
        if (index >= 0 && index <= this.count) {
            if (string == null) {
                string = String.valueOf(string);
            }
            int min = string.length();
            this.move(min, index);
            string.getChars(0, min, this.value, index);
            this.count += min;
            return this;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    public StringBuffer insert(int index, boolean value) {
        return this.insert(index, String.valueOf(value));
    }

    public int length() {
        return this.count;
    }

    private void move(int size, int index) {
        int newSize;
        if (this.value.length - this.count >= size) {
            if (!this.shared) {
                System.arraycopy((Object)this.value, index, (Object)this.value, index + size, this.count - index);
                return;
            }
            newSize = this.value.length;
        } else {
            int a = this.count + size;
            int b = (this.value.length << 1) + 2;
            newSize = a > b ? a : b;
        }
        char[] newData = new char[newSize];
        System.arraycopy((Object)this.value, 0, (Object)newData, 0, index);
        System.arraycopy((Object)this.value, index, (Object)newData, index + size, this.count - index);
        this.value = newData;
        this.shared = false;
    }

    public synchronized StringBuffer reverse() {
        if (this.count < 2) {
            return this;
        }
        if (!this.shared) {
            int i = 0;
            int end = this.count;
            int mid = this.count / 2;
            while (i < mid) {
                char temp = this.value[--end];
                this.value[end] = this.value[i];
                this.value[i] = temp;
                ++i;
            }
        } else {
            char[] newData = new char[this.value.length];
            int i = 0;
            int end = this.count;
            while (i < this.count) {
                newData[--end] = this.value[i];
                ++i;
            }
            this.value = newData;
            this.shared = false;
        }
        return this;
    }

    public synchronized void setCharAt(int index, char ch) {
        if (this.shared) {
            this.cloneValue();
            this.shared = false;
        }
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public synchronized void setLength(int length) {
        if (length > this.value.length) {
            this.ensureCapacityImpl(length);
        }
        if (this.count > length) {
            if (!this.shared) {
                try {
                    int i = length;
                    while (i < this.count) {
                        this.value[i] = '\u0000';
                        ++i;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new IndexOutOfBoundsException();
                }
            } else {
                char[] newData = new char[this.value.length];
                if (length > 0) {
                    System.arraycopy((Object)this.value, 0, (Object)newData, 0, length);
                }
                this.value = newData;
                this.shared = false;
            }
        }
        this.count = length;
    }

    public synchronized String toString() {
        if (this.count >= 256 && this.count <= this.value.length >> 1) {
            return new String(this.value, 0, this.count);
        }
        this.shared = true;
        return new String(0, this.count, this.value);
    }

    char[] shareValue() {
        this.shared = true;
        return this.value;
    }

    private void cloneValue() {
        char[] data = new char[this.value.length];
        System.arraycopy((Object)this.value, 0, (Object)data, 0, this.value.length);
        this.value = data;
    }
}

